﻿define([], function () {

    debug.info("Entering DataService module.");

    var service = function () {

        var self = this;
        self.isConnecting = false;
        self.connectionHandlers = [];
        
        //open the database
        var db = null;
                
        self.connect = function (onconnection) {

            //already connected
            if (db) {
                if (onconnection) onconnection();
                return;
            }

            //is connecting
            if (self.isConnecting) {
                if (onconnection) self.connectionHandlers.push(onconnection);
                return;
            }

            //initiate connection
            self.isConnecting = true;
            if (onconnection) self.connectionHandlers.push(onconnection);
            var request = indexedDB.open("modelhour", 7);

            request.onsuccess = function (e) {
                db = e.target.result;
                debug.info('Database connection opened...');
                while (self.connectionHandlers.length) {
                    var onconn = self.connectionHandlers.pop();
                    if (onconn) onconn();
                }
                
                self.isConnecting = false;
            };

            //create necessary object stores
            request.onupgradeneeded = function (e) {
                debug.info('Database upgradeended...');
                var d = e.target.result;

                
                for (var j = d.objectStoreNames.length - 1; j >= 0; j--) {
                    d.deleteObjectStore(d.objectStoreNames[j]);
                }
                                
                var ds = d.createObjectStore("Models", { keyPath: "Id" });
                ds.createIndex("Created", "Created", { unique: false });
                debug.info('Created object store: Models');

                var mps = d.createObjectStore("ModelPhotos", { keyPath: "Id" });
                mps.createIndex("Created", "Created", { unique: false });
                mps.createIndex("ModelId", "ModelId", { unique: false });
                mps.createIndex("SectionId", "SectionId", { unique: false });
                debug.info('Created object store: ModelPhotos');

                var imgs = d.createObjectStore("Images");
                debug.info('Created object store: Images');
            };

            request.onerror = function (e) { debug.error('Database error:', e); };
        };

        self.saveItem = function (storeName, item, onsuccess, onerror) {

            var trans = db.transaction([storeName], "readwrite");
            var store = trans.objectStore(storeName);
            var request = store.put(item);

            request.onsuccess = onsuccess;

            request.onerror = function (e) {
                debug.error(e.value);
                if (onerror) onerror(e.value);
            };
        };

        self.saveItemWithKey = function (storeName, item, key, onsuccess, onerror) {

            var trans = db.transaction([storeName], "readwrite");
            var store = trans.objectStore(storeName);
            var request = store.put(item, key);

            request.onsuccess = onsuccess;

            request.onerror = function (e) {
                debug.error(e.value);
                if (onerror) onerror();
            };
        };

        self.item = function (storeName, key, onsuccess, onerror) {
            var request = db.transaction(storeName).objectStore(storeName).get(key);
            request.onsuccess = function (event) {
                onsuccess(event.target.result);
            };
            request.onerror = function (err) {
                debug.error(e.value);
                if (onerror) onerror();
            };
        };

        self.getModelsBefore = function (before, onsuccess, onerror) {
            var index = db.transaction('Models').objectStore('Models').index('Created');

            var request = index.openCursor(IDBKeyRange.upperBound(before), "prev");
            request.onsuccess = function (event) {                
                var cursor = event.target.result;
                if (onsuccess) onsuccess(cursor);
            };

            request.onerror = function (e) {
                debug.error(e.value);
                if (onerror) onerror();
            };
        };

        self.clear = function (storeName, onsuccess, onerror) {

            var trans = db.transaction([storeName], "readwrite");
            var store = trans.objectStore(storeName);
            var request = store.clear();

            request.onsuccess = onsuccess;

            request.onerror = function (e) {
                debug.error(e.value);
                if (onerror) onerror(e.value);
            };
        };

        self.itemsByIndex = function (storeName, indexName, key, onsuccess, onerror) {
            var index = db.transaction(storeName).objectStore(storeName).index(indexName);

            var request = index.openCursor(IDBKeyRange.only(key));
            request.onsuccess = function (event) {
                var cursor = event.target.result;
                if (onsuccess) onsuccess(cursor);
            };

            request.onerror = function (e) {
                debug.error(e.value);
                if (onerror) onerror(e.value);
            };

        };
        


        return self;
    };

    return service;
});
