﻿define([], function (Console) {

    debug.info("Entering UtilsService module.");

    var service = function () {

        var self = this;

        self.modelId = function (url) {
            var name = url.split('.')[0];
            return parseInt(name.substring(name.lastIndexOf('-') + 1));
        }

        self.apply = function (scope) {
            if (!scope.$$phase) {
                window.setTimeout(function() { scope.$apply()}, 0);
            }
        }

        self.dateFromSec = function (sec) {
            return (new Date(sec * 1000)).toLocaleDateString();
        }

        self.modelUrl = function (model) {
            if (!model) return '';
            return self.urlName(model.DisplayName) + '-' + model.Id;
        }

        self.urlName = function (name) {

            var s = '';

            var doNotReplace = ("a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,0,1,2,3,4,5,6,7,8,9,-,_").split(",");
            var stringsToReplace = ("а,б,в,г,д,е,ё,ж,з,и,й,к,л,м,н,о,п,р,с,т,у,ф,х,ц,ч,ш,щ,ъ,ы,ь,э,ю,я, ,æ,ø,å,/,\\,ö").split(",");
            var replacements = ("a,b,v,g,d,e,yo,zh,z,i,j,k,l,m,n,o,p,r,s,t,u,f,h,c,ch,sh,sch,,y,,e,yu,ya,-,ae,o,a,-,-,o").split(",");

            var text = DoMultiCharReplacements(name).trim().toLowerCase();

            for (var i = 0; i < text.length; i++) {
                var letter = text[i];
                if (doNotReplace.indexOf(letter) >= 0)
                    s += letter;
                else {
                    var letIndex = stringsToReplace.indexOf(letter);
                    if (letIndex >= 0)
                        s += replacements[letIndex];
                }
            }
            return s;
        }

        function DoMultiCharReplacements(s) {
            var text = !s ? '' : s;
            var substringsToReplace = (" / , \\ ").split(",");
            var replacements = ("-or-,-or-").split(',');

            for (var j = 0; j < substringsToReplace.length; j++) {
                var rep = substringsToReplace[j];
                text = text.replace(rep, replacements[substringsToReplace.indexOf(rep)]);
            }
            return text;
        }

        return self;
    };

    return service;
});
