﻿define([
    'services/SettingsService',
    'services/ModelsService',
    'services/UtilsService',
    'services/DataService',
    'services/ModelsCatalogService',
    'services/AccountService'
], function (ss, ms, u, ds, mcs, as) {
    
    debug.info("Entering Service module.");
    
    var services = {        
        SettingsService: ss,
        ModelsService: ms,
        Utils: u,
        DataService: ds,
        ModelsCatalogService: mcs,
        AccountService: as
    };

    debug.info("Registered services: ", services);

    var initialize = function (angModule) {
        _.each(services, function (service, name) {
            angModule.factory(name, service);
        })
        
        debug.info("Services initialized.");
    }

    return {
        initialize: initialize
    };
});
