var $B = [
	cuentaActual = {}
];

var Cuaderno = Backbone.Model.extend({
    initialize: function() {
        this.bind("change", function() {

        });
    },
    defaults: {
        semilla: "",
        items: [{  
					"saldoTotalCuenta":{
	          "importe": 0.00

	        },
	        "divisa":"€",
	        "id":1,
	         "nombreHoja":"Efectivo"
				}],
				cuentaPrincipal : {
					id : 1,
					name : "Efectivo"
				},
        lastMovs: [],
        listadoCategorias: [
				{ "id" : 1,
					"name" : "General",
					"css" : "usd"
				},  
				{ "id" : 2,
					"name" : "Restaurante",
					"css" : "pizza"
				},  
				{ "id" : 3,
					"name" : "Copas",
					"css" : "beer"
				},  
				{ "id" : 4,
					"name" : "Tiendas",
					"css" : "shopping_bag"
				},  
				{ "id" : 5,
					"name" : "Supermercado",
					"css": "shopping_cart"
				},  
				{ "id" : 6,
					"name" : "Personal",
					"css" : "user"
				},  
				{ "id" : 7,
					"name" : "Entretenimiento",
					"css": "microphone"
				},  
				{ "id" : 8,
					"name" : "Transporte",
					"css": "car"
				},  
				{ "id" : 9,
					"name" : "Aplicaciones",
					"css" : "gamepad"
				},  
				{ "id" : 10,
					"name" : "Móvil",
					"css" : "iphone"
				},  
				{ "id" : 11,
					"name" : "Gadgets",
					"css" : "imac"
				},  
				{ "id" : 12,
					"name" : "Regalos",
					"css" : "gift"
				},  
				{ "id" : 13,
					"name" : "Hogar",
					"css" : "home"
				},  
				{ "id" : 14,
					"name" : "Viajes",
					"css" : "airplane"
				},  
				{ "id" : 15,
					"name" : "Libros",
					"css" : "book"
				},  
				{ "id" : 16,
					"name" : "Salud",
					"css" : "heart"
				},  
				{ "id" : 17,
					"name" : "Traspasos",
					"css" : "retweet"
				}
      ]
    },
    nuevaCuenta: function(data, id) {

        var datosModelo = this.get("items"),
        arrayPlantilla = [],
	    	datosModeloArray = [];

				for (var i = 0, len = datosModelo.length; i < len; i++) {
				    datosModeloArray.push([datosModelo[i]]);
				}

        arrayPlantilla.items = (_.isEmpty(datosModelo)) ? datosModeloArray : datosModelo;
        arrayPlantilla.items.push(data);

        if (arrayPlantilla.items.length === 1) {
        	this.set("cuentaPrincipal",{ id: id, name : arrayPlantilla.items[0].nombreHoja});
        }

        this.set(arrayPlantilla);
        this.set("semilla",id);
        localStorage.datosAplicacion = JSON.stringify(this.attributes);
    },
    borrarCuenta: function(id) {

        var datosModelo = this.get("items"),
        arrayPlantilla = [],
	    	datosModeloArray = [],
	    	datosMovimientos = this.get("lastMovs"),
	    	datosMovimientosArray = [];

				for (var i = 0, len = datosModelo.length; i < len; i++) {
					if (datosModelo[i].id !== $B.cuentaActual.id) {
				    datosModeloArray.push(datosModelo[i]);
				  }
				}

				for (var j = 0, numeroMovimientos = datosMovimientos.length; j < numeroMovimientos; j++) {
		    	if(datosMovimientos[j].idCuenta !== $B.cuentaActual.id) {
		    		datosMovimientosArray.push(datosMovimientos[j]);
		    	}
		    }

        arrayPlantilla.items = datosModeloArray;
        arrayPlantilla.lastMovs = datosMovimientosArray;

        this.set(arrayPlantilla);
        this.set("semilla",id);
        localStorage.datosAplicacion = JSON.stringify(this.attributes);
    },
    renombrarCuenta: function (id, nombreNuevo, semilla, principal) {
        var datosModelo = this.get("items"),
        arrayPlantilla = [],
	    	datosModeloArray = [],
	    	nombreFinal = "",
	    	cuentaPrincipal = this.get("cuentaPrincipal");

				for (var i = 0, len = datosModelo.length; i < len; i++) {
					if (datosModelo[i].id === $B.cuentaActual.id && nombreNuevo !== "") {
						datosModelo[i].nombreHoja = nombreNuevo;
				  }
				  datosModeloArray.push(datosModelo[i]);
				}

        arrayPlantilla.items = datosModeloArray;

        if (principal) {
        	this.set("cuentaPrincipal",{ id: id, name : $B.cuentaActual.nombre});
        } else if ( cuentaPrincipal.id === id){
        	this.set("cuentaPrincipal",{});        	
        } else {
        	this.set("semilla",semilla);
        }

        this.set(arrayPlantilla);
        localStorage.datosAplicacion = JSON.stringify(this.attributes);

    },
    nuevoMov: function(data, id) {

        var datosModelo = this.get("lastMovs"),
        datosCuentas = this.get("items"),
        arrayPlantilla = [],
	    	datosModeloArray = [],
	    	numeroCuenta,
	    	self = this;

				for (var i = 0, len = datosModelo.length; i < len; i++) {
				    datosModeloArray.push([datosModelo[i]]);
				}

        arrayPlantilla.lastMovs = (_.isEmpty(datosModelo)) ? datosModeloArray : datosModelo;

        arrayPlantilla.lastMovs.reverse();
        arrayPlantilla.lastMovs.push(data);
				arrayPlantilla.lastMovs.reverse();
        this.set(arrayPlantilla);
        localStorage.datosAplicacion = JSON.stringify(this.attributes);
    },
		actualizarImporte: function (cuenta, importe) {
			var datosModelo = this.get("items"),
        arrayPlantilla = [],
	    	datosModeloArray = [],
	    	importeModelo,
	    	aleatorio = new Date(),
	    	id = aleatorio.getTime();

				for (var i = 0, len = datosModelo.length; i < len; i++) {
				    if(datosModelo[i].id.toString() === cuenta) {
				    	importeModelo = datosModelo[i].saldoTotalCuenta.importe;
				    	datosModelo[i].saldoTotalCuenta.importe = parseFloat(importeModelo) + parseFloat(importe);
				    }
				}

        arrayPlantilla.items = datosModelo;

        this.set(arrayPlantilla);
        this.set("semilla",id);
        localStorage.datosAplicacion = JSON.stringify(this.attributes);
		}
});

var SingleCuaderno = Backbone.View.extend({

		events: {
			'click section:not(.noActivo)#drawer [data-cuenta], section:not(.noActivo)#sidebar [data-cuenta]': 'verCuenta',
			'click [data-promo="nueva"], #botonNueva, [data-new-account]': 'enableNewCuenta',
			'click [data-edit-cuenta]': 'enableEditCuenta',
			'click #botonProvisional.enabled': 'mostrarCuentas',
			'keyup [data-input-nueva-cuenta]': 'enableNewButton',
			'click [data-boton-editar]': 'guardarBorrar',
			'click [data-cuenta-check]': 'checkToDelete',
			'click #botonCerrar': 'mostrarCuentas',
			'click [data-promo="gasto"],[data-apunte]': 'hacerApunte',
			'click [data-cerrar-new-mov]': 'cerrarNuevoApunte',
			'click [data-cerrar-new-account]': 'cerrarNuevaCuenta',
			'click [data-cerrar-edit-account]': 'cerrarEditarCuenta',
			'click [data-cancel-form]': 'cancelForm',
			'click [data-cancel-selector]': 'cancelSelectorCuentas',
			'click [data-cancel-selector-ubicacion]': 'cancelSelectorUbicaciones',
			'click [data-cancel-selector-categoria]': 'cancelSelectorCategorias',
			'click [data-nuevo-apunte-cuenta]': 'seleccionNuevaCuenta',
			'click [data-nuevo-apunte-ubicacion]': 'seleccionNuevaUbicacion',
			'click [data-nuevo-apunte-categoria]': 'seleccionNuevaCategoria',
			'click #botonVolver': 'volverAlInicio',
			'focus [data-nuevo-apunte-importe], [data-input-importe-inicial]': 'prepararImporte',
			'blur [data-nuevo-apunte-importe], [data-input-importe-inicial]': 'validarImporte',
			'keyup [data-nuevo-apunte-importe], [data-input-importe-inicial]': 'formatEditor',
			'click #botoneraSelectorCuentas button[data-id-boton]' : 'seleccionarCuentaApunte',
			'click #botoneraSelectorUbicaciones li[data-id-ubicacion]' : 'seleccionarUbicacionApunte',
			'click #botoneraSelectorCategorias li[data-id-categoria]' : 'seleccionarCategoriaApunte',
			'click [data-aceptar-editor]' : 'nuevoMovimiento',
			'click [data-back-to-pg]' : 'volverAlInicio',
			'click [data-boton-borrar-cuenta]' : 'borrarCuenta',
			'click [data-cancel-delete]' : 'cancelAlert',
			'click [data-confirm-delete]' : 'borrarCuentaConfirmado'
		},
		initialize: function() {
			_.bindAll(this);

			templateLista = $('#fila-lista-template').html(),
			this.template = $('#fila-movs-template').html();

			if(!_.isEmpty(localStorage.datosAplicacion)) {
				this.model = new Cuaderno(JSON.parse(localStorage.datosAplicacion));
			} else {
				this.model = new Cuaderno({});
			}
			this.model.bind("reset", this.render, this);
			this.model.bind("change", this.render, this);
		},
		render: function(evdata) {
			var movs = this.model.get('lastMovs'),
			cuentas = this.model.get('items'),
			codigo = "",
			firstPageTmpl = $('#first-page-content').html(),
			alertaTmpl = $('#mensaje-info').html(),
			alertaTmplMov = $('#mensaje-informativo-mov').html();

			codigo = codigo + _.template(this.template,{items:movs, cuentas: cuentas});

			$('[data-alerts]').remove();

			if(cuentas.length !== 0) {
				this.$el.find('#first-page').html(_.template(firstPageTmpl));
				this.$el.find('#lista-last-movs').html(codigo);
				this.$el.find('#toolbarInferior').removeClass('inactivo');
				this.$el.find('#subheader').removeClass('inactivo');
				this.$el.find('#botonProvisional').addClass('enabled');
				if(movs.length !== 0) {
					this.$el.find('[data-header-pg]').html('Posición Global');
					if (cuentas.length === 1) {
						this.$el.find('#lista-last-movs').append(_.template(alertaTmplMov, {data_promo: "nueva", icono: "pin_classic", mensaje:"Crea nuevas cuentas.", submensaje:"Usa el menú lateral para ello."}));
					} else {
						this.$el.find('#lista-last-movs').append(_.template(alertaTmplMov, {data_promo: "", icono: "star", mensaje:"Elige una cuenta principal.", submensaje:"¿Cuál es tu cuenta frecuente?"}));
					}
				} else {
					this.$el.find('#lista-last-movs').append(_.template(alertaTmplMov, {data_promo: "gasto", icono: "pin_classic", mensaje:"Ya puedes empezar.", submensaje:"Apunta tus primeros gastos."}));
					this.$el.find('#lista-last-movs').append(_.template(alertaTmplMov, {data_promo: "", icono: "google_maps", mensaje:"Para que no te pierdas.", submensaje:"Geolocalizamos tus apuntes."}));				
				}
			} else {
				if ($('#firstAlert').length === 0) {
					$('body').prepend(_.template(alertaTmpl, {mensaje:"Necesitas una cuenta donde apuntar tus gastos."}));
				}
			}
			
			this.$el.find('#lista-cuadernos').html(_.template(templateLista,{items:cuentas}));			
			this.getSaldoTotal();
		},
		checkToDelete: function(evdata) {
			var $check = $(evdata.currentTarget),
			resultado = false;
			$check.closest('ul').find('input').each(function(){ var children = $(this); if (children.attr('checked') === 'checked') { resultado = true;}});
			if(resultado){
				$(this.$el.find('[data-boton-editar]')).removeAttr('disabled');
			} else {
				$(this.$el.find('[data-boton-editar]')).attr('disabled','disabled');
			}
		},
		fuerzaRefrescoAside: function () {
			this.$el.find('#lista-cuadernos').html(_.template(templateLista,{items:cuentas}));
		},
		seleccionarCuentaApunte: function (evdata){
			evdata.stopPropagation();
			evdata.preventDefault();
			evdata = evdata || {};
			var $target = $(evdata.currentTarget);

			$('[data-nuevo-apunte-cuenta]').val($target.html()).attr('data-nuevo-apunte-cuenta',$target.attr('data-id-boton'));
			$target.siblings('button[data-cancel-selector]').trigger('click');

			this.evaluarEditor();
		},

		seleccionarUbicacionApunte: function (evdata){
			evdata.stopPropagation();
			evdata.preventDefault();
			evdata = evdata || {};
			var $target = $(evdata.currentTarget);

			$('[data-nuevo-apunte-ubicacion]').val($target.attr('data-nombre-ubicacion'))
				.attr('data-nuevo-apunte-ubicacion',$target.attr('data-id-ubicacion'));

			$target.closest('section').find('button[data-cancel-selector-ubicacion]').trigger('click');

		},

		seleccionarCategoriaApunte: function (evdata){
			evdata.stopPropagation();
			evdata.preventDefault();
			evdata = evdata || {};
			var $target = $(evdata.currentTarget);

			$('[data-nuevo-apunte-categoria]').val($target.attr('data-nombre-categoria'))
				.attr('data-nuevo-apunte-categoria',$target.attr('data-id-categoria'));

			$target.closest('section').find('button[data-cancel-selector-categoria]').trigger('click');

		},

		formatEditor: function (evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget),
			nuevoImporte = $target.val(),
			importeAnterior = $target.attr('data-valor-anterior'),
			huecoComa;

			nuevoImporte = nuevoImporte.substring(0,nuevoImporte.indexOf(".")) + nuevoImporte.substring(nuevoImporte.indexOf(".")+1);

			for (var i = 0; i < 2; i++) {
				if(nuevoImporte.length <= 2) {
					nuevoImporte = 0 + nuevoImporte;
				}
			}

			nuevoImporte = nuevoImporte.substring(0,nuevoImporte.length-2) + "." + nuevoImporte.substring(nuevoImporte.length-2);

			if(nuevoImporte.substring(0,nuevoImporte.length-3) === "00") {
				nuevoImporte = nuevoImporte.substring(1);
			}
			if(nuevoImporte.substring(0,nuevoImporte.length-2) >= 1 && nuevoImporte.substring(0,1) === "0") {
				nuevoImporte = nuevoImporte.substring(1);
			}

			$target.val(nuevoImporte).attr('data-valor-anterior',nuevoImporte);

			this.evaluarEditor();
		},
		evaluarEditor: function () {
			var valorCuenta = $('[data-nuevo-apunte-cuenta]').val(),
			valorImporte = $('[data-nuevo-apunte-importe]').val();

			if(valorCuenta !== "" && valorImporte !== "") {
				 $('[data-aceptar-editor]').removeAttr('disabled');
			} else {
				$('[data-aceptar-editor]').attr('disabled','disabled');
			}
		},
		nuevoMovimiento: function () {
			var id = $('[data-nuevo-apunte-cuenta]').attr('data-nuevo-apunte-cuenta'),
			nombreHoja = $('[data-nuevo-apunte-cuenta]').val(),
			valorImporte = $('[data-nuevo-apunte-importe]').val(),
			ubicacionMov = $('[data-nuevo-apunte-ubicacion]').val(),
			ubicacionMovId = $('[data-nuevo-apunte-ubicacion]').attr('data-nuevo-apunte-ubicacion'),
			categoriaMovId = $('[data-nuevo-apunte-categoria]').attr('data-nuevo-apunte-categoria'),
			categoriaCss = "",
			nuevosMovs,
			etiqueta,
			fecha = new Date();

			if($B.tipoApunte === "I") {
				etiqueta = "Ingreso";
			} else {
				etiqueta = "Gasto";
				valorImporte = "-" + valorImporte;
			}

			if(categoriaMovId) {				
				categoriaCss = this.model.get('listadoCategorias')[parseInt(categoriaMovId) - 1].css;
			} else {
				categoriaMovId = 1;
				categoriaCss = this.model.get('listadoCategorias')[parseInt(categoriaMovId) - 1].css;
			}

			valorImporte = parseFloat(valorImporte.substring(0,valorImporte.indexOf("€")));
			nuevosMovs = {  
                "tipo": $B.tipoApunte,
                "importe": valorImporte,
                "divisa": "€",
                "concepto": etiqueta,
                "cuenta" : nombreHoja,
                "idCuenta" : parseInt(id),
                "fecha" : fecha,
                "ubicacion" : ubicacionMov,
                "ubicacionId" : ubicacionMovId,
          			"categoriaId" : parseInt(categoriaMovId),
          			"categoriaCss" : categoriaCss
              };

	    this.model.nuevoMov(nuevosMovs, id);
	    this.model.actualizarImporte(id, valorImporte);
	    this.cerrarNuevoApunte();
			this.volverAlInicio();
			this.cerrarSidebar();

		},
		cancelAlert: function (evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget);

			$target.closest('form').remove();
		},
		validarImporte: function (evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget),
			importe;

			importe = $target.val();

			if(importe !== "" && importe !== "€") {
				if(importe.indexOf("€") !== -1) {
					importe = importe.substring(0,importe.indexOf("€"));
				}
				$target.val(importe + "€");
			}
		},
		prepararImporte: function (evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget),
			importe;

			importe = $target.val();

			if(importe.indexOf("€") !== -1) {
				importe = importe.substring(0,importe.indexOf("€"));
			}

			$target.val(importe);
		},
		cancelForm: function(evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget);

			this.fadeInfadeOut($target.closest('form') ,false);			
		},
		cancelSelectorCuentas: function() {

			$('#selectorCuentas').removeClass('oculto');
			this.fadeInfadeOut($('#selectorCuentas'), false);			
		},
		cancelSelectorUbicaciones: function() {

			this.fadeInfadeOut($('#selectorUbicaciones'), false);
			
			$('#selectorUbicaciones').addClass('oculto');			
		},
		cancelSelectorCategorias: function() {

			this.fadeInfadeOut($('#selectorCategorias'), false);
			
			$('#selectorCategorias').addClass('oculto');			
		},
		seleccionNuevaCuenta: function(evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget),
			templateBoton = $('#boton-cuenta-template').html();

			this.$el.find('#botoneraSelectorCuentas').html(_.template(templateBoton,{items:this.model.get('items')}));			
			$('#selectorCuentas').removeClass('oculto');
			this.fadeInfadeOut($('#selectorCuentas'), true);

		},
		seleccionNuevaUbicacion: function(evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget);

			//this.obtenerUbicaciones();		
			$('#selectorUbicaciones').removeClass('oculto');
			this.fadeInfadeOut($('#selectorUbicaciones'), true);

		},
		seleccionNuevaCategoria: function(evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget);

			$('#botoneraSelectorCategorias').html(_.template($('#boton-categoria-template').html(),{items:this.model.get('listadoCategorias')}));		
			$('#selectorCategorias').removeClass('oculto');
			this.fadeInfadeOut($('#selectorCategorias'), true);

		},
		obtenerUbicaciones: function() {

				function success(position) {

				  var url = 'https://api.foursquare.com/v2/venues/search?ll=' + position.coords.latitude + ',' + position.coords.longitude + '&client_id=3HZIYFAZJTQFGANJSB5HYXCN0IGHBR5J4TWR5QFY01UZLG2S&client_secret=3HHOMNILP5HDWADLDSN2GKQS33XINXITTBQDTAW3M34QWGOR&v=20130517',
				  	jsonError = [{id:"",name:"No hemos encontrado ubicaciones"}];
					$.ajax({
		        type: 'GET',
		        url: url,
		        success: function (json) {
		          var nombreUbicacion, idUbicacion, venues, response;
		          	
	          	if (_.isObject(json)) {
		          	venues = json.response.venues;
	          	} else {
	          		venues = JSON.parse(json);
	          		venues = venues.response.venues;	          		
	          	}

	          	$('#botoneraSelectorUbicaciones').html(_.template($('#boton-ubicacion-template').html(),{items:venues}));

	          	$('[data-nuevo-apunte-ubicacion]').val(venues[0].name).attr('data-nuevo-apunte-ubicacion',venues[0].id);
		        },
			      error: function () {
			        $('#botoneraSelectorUbicaciones').html(_.template($('#boton-no-ubicacion-template').html(),{items:jsonError}));
			      }
		      });
				};

				function error(err) {
					var jsonNoPermiso; 

					switch (err.code) {
						case 1:
							jsonNoPermiso = [{id:"",name:"Permita localización en Ajustes"}];
						break;
						case 2:
							jsonNoPermiso = [{id:"",name:"Posición desconocida"}];
						break;
						case 3:
							jsonNoPermiso = [{id:"",name:"Inténtelo de nuevo"}];
						break;
						default:
							jsonNoPermiso = [{id:"",name:"Habilite localización"}];
					}

					$('#botoneraSelectorUbicaciones').html(_.template($('#boton-no-ubicacion-template').html(),{items:jsonNoPermiso}));

				};

				var options = {
				  enableHighAccuracy: true,
				  timeout: 5000,
				  maximumAge: 0
				},
				jsonErrorGPS = [{id:"",name:"No hay datos de GPS"}];

			if ("geolocation" in navigator) {
				navigator.geolocation.getCurrentPosition(success, error, options);
			} else {
			  $('#botoneraSelectorUbicaciones').html(_.template($('#boton-no-ubicacion-template').html(),{items:jsonErrorGPS}));
			}
		},
		hacerApunte: function(evdata) {
			evdata.stopPropagation();
			evdata.preventDefault();

			$('[data-nuevo-apunte-importe]').val('');
			$('[data-nuevo-apunte-cuenta]').val('');
			$('[data-aceptar-editor]').attr('disabled','disabled');

			var etiqueta;
			
			$('body').prepend(_.template($('#new-movement-template').html()));
			this.fadeInfadeOut($('#newMovement'), true);

			if($(evdata.currentTarget).attr('data-apunte') === "ingreso") {
				$B.tipoApunte = "I";
				etiqueta = "Ingreso";
				$('[data-nuevo-apunte-ubicacion]').closest('[data-input-nuevo]').addClass('oculto');
				$('[data-nuevo-apunte-categoria]').closest('[data-input-nuevo]').addClass('oculto');
			} else {
				etiqueta = "Gasto";
				$B.tipoApunte = "G";
				this.obtenerUbicaciones();
				$('[data-nuevo-apunte-categoria]').val(this.model.get('listadoCategorias')[0].name).attr('data-nuevo-apunte-categoria',this.model.get('listadoCategorias')[0].id);	
			}

			$('#newMovement').find('[data-type="edit"]').find('h1').html(etiqueta);

			if (!_.isEmpty($B.cuentaActual)) {
				$('[data-nuevo-apunte-cuenta]').val($B.cuentaActual.nombre).attr('data-nuevo-apunte-cuenta', $B.cuentaActual.id);
			} else if(this.model.get('cuentaPrincipal').id !== "") {
				$('[data-nuevo-apunte-cuenta]').val(this.model.get('cuentaPrincipal').name).attr('data-nuevo-apunte-cuenta', this.model.get('cuentaPrincipal').id);
			}

			$('#drawer').addClass('oculto');	

		},
		cerrarNuevoApunte: function() {

			this.fadeInfadeOut($('#newMovement'), false);
			$('#newMovement').remove();
			$('#drawer').removeClass('oculto');

		},
		cerrarNuevaCuenta: function() {
			$('#drawer').removeClass('oculto');

			if(this.model.get('items').length === 0) {
				$('body').prepend(_.template($('#mensaje-info').html(), {mensaje:"Para empezar crea una cuenta"}));
			}

			this.fadeInfadeOut($('#newAccount'), false);
			$('#newAccount').remove();
		},
		cerrarEditarCuenta: function() {
			$('#drawer').removeClass('oculto');

			this.fadeInfadeOut($('#editAccount'), false);
			$('#editAccount').remove();
		},
		mostrarCuentas: function(evdata) {
			evdata.stopPropagation();
			evdata = evdata || {};
			$('#sidebar').toggleClass('noActivo');
			$('#drawer').removeClass('oculto').toggleClass('noActivo');

		},
		verCuenta: function(evdata) {
			evdata.stopPropagation();
			evdata = evdata || {};
			var $target = $(evdata.currentTarget),
			templateCuenta = $('#una-cuenta-template').html(),
			idCuenta,
			nombreCuenta,
			numeroCuenta,
			cuentas = this.model.get('items');

			$('#sidebar').addClass('noActivo');
			$('#drawer').removeClass('noActivo');

			idCuenta = parseInt($target.attr("data-cuenta"));

			for (var i = cuentas.length - 1; i >= 0; i--) {
				if (cuentas[i].id === idCuenta) {
					numeroCuenta = i;
				}
			};

			nombreCuenta = cuentas[numeroCuenta].nombreHoja;
			$B.cuentaActual = {id: idCuenta, nombre : nombreCuenta};

			this.fadeInfadeOut($('#first-page'), false);
			this.fadeInfadeOut($('#cuaderno'), true);
			$('#first-page').addClass('oculto');

			$target.closest('#topAplicacion').find('#botonVolver').removeClass('oculto');
			$target.closest('#topAplicacion').find('#botonCerrar').addClass('oculto');
			$target.closest('#topAplicacion').find('#botoneraEditarCuentas').addClass('oculto');

			this.$el.find("#cuaderno").html(_.template(templateCuenta,{hoja:this.model.get('items')[numeroCuenta]}));
			$('#subcabecera').html(nombreCuenta);
			this.seeLastMovs(idCuenta);
			this.mostrarBackButton(true);
			
		},
		mostrarBackButton: function(boolean) {
			if (boolean) {
				$('[data-cuenta-toolbar]').removeClass('oculto');
			} else {
				$('[data-cuenta-toolbar]').addClass('oculto');
			}			
		},
		seeLastMovs: function(cuenta) {
			var templateMovs = $('#last-movs-template').html(),
			alertaTmplMov = $('#mensaje-informativo-mov').html(),
			contenido = "",
			lastMovs,
			allMovs = [];

			lastMovs = this.model.get('lastMovs');
			
			for (var i = 0, len = lastMovs.length; i < len; i++) {
				if(lastMovs[i].idCuenta === cuenta) {
					allMovs.push(lastMovs[i]);
				}
			}
			if (lastMovs.length !== 0) {
				$('#contenidoHoja').html(_.template(templateMovs,{items:allMovs}));
			} else {				
				this.$el.find('#contenidoHoja').append(_.template(alertaTmplMov, {data_promo: "gasto", icono: "pin_classic", mensaje:"No tienes movimientos.", submensaje:"Usa la barra inferior."}));	
				}
		},
		getSaldoTotal: function() {
			var cuentas = this.model.get('items'),
			saldoTotal = 0.00;
			
			for (var i = 0, len = cuentas.length; i < len; i++) {
				saldoTotal = saldoTotal + parseFloat(cuentas[i].saldoTotalCuenta.importe);
			}

			$('#saldoHojaCuaderno').html(this.formatSaldo(saldoTotal) + "€");
		},
		formatSaldo: function (saldoTotal) {

			saldoTotal=Math.round(saldoTotal*100)/100;
			saldoTotal.toFixed(2);
			saldoTotal = saldoTotal.toString();

			if(saldoTotal.indexOf(".") === -1) {
				saldoTotal = saldoTotal + ".00";
			}
			return saldoTotal;
		},
		enableNewCuenta: function (evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget),
			templateInput = $('#fila-input-template').html(),
			$dataInput = this.$el.find('section').find('[data-input-nuevo]');

			$('body').prepend(_.template($('#new-account-template').html()));

			this.fadeInfadeOut($('#newAccount'), true);
			$('#firstAlert').remove();

			$('[data-input-nueva-cuenta]').focus();
			$target.addClass("activo");
		},
		enableEditCuenta: function (evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget),
			templateInput = $('#fila-input-template').html(),
			$dataInput = this.$el.find('section').find('[data-input-edit-cuenta]'),
			$dataCheckPrincipal,
			cuentaPrincipal = this.model.get('cuentaPrincipal');

			$('body').prepend(_.template($('#edit-account-template').html()));

			this.fadeInfadeOut($('#editAccount'), true);
			$('#firstAlert').remove();

			$('[data-input-edit-cuenta]').attr('placeholder',$B.cuentaActual.nombre).focus();
			$dataCheckPrincipal = this.$el.find('section#editAccount').find('[data-input-principal]');
			if (!_.isEmpty(cuentaPrincipal) && cuentaPrincipal.id === $B.cuentaActual.id) {
				$dataCheckPrincipal.attr('checked', 'checked');
			}
			$target.addClass("activo");
		},
		borrarCuenta: function () {
			var confirmDeleteTmpl = $('#confirm-delete-info').html();

			if ($('#confirmDelete').length === 0) {
				$('body').prepend(_.template(confirmDeleteTmpl, {mensaje:"¿Está seguro de querer borrar la cuenta?", cuenta: $B.cuentaActual.nombre}));
			}
			
		},
		borrarCuentaConfirmado: function () {

			this.model.borrarCuenta($B.cuentaActual.id);
			this.volverAlInicio();

			$('#editAccount').remove();

		},
		fadeInfadeOut: function (data, ponerDelante) {
			if(!ponerDelante) {
				$(data).removeClass('delante').addClass('detras');
			} else {
				$(data).removeClass('detras').addClass('delante');
			}
		},
		enableNewButton: function (evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget),
			$botonGuardar = this.$el.find('#menuInferior').find('[data-boton-editar]'),
			$botonObjetivo;

			if ($target.val()) {
				$botonGuardar.removeAttr('disabled');
			} else {
				$botonGuardar.attr('disabled','disabled');		
			}
		},
		cerrarSidebar: function () {
			$('#sidebar').addClass('noActivo');
			$('#drawer').removeClass('noActivo');
		},
		volverAlInicio: function () {

			this.cerrarSidebar();
			$('#first-page').removeClass('oculto');
			this.fadeInfadeOut($('#first-page'), true);
			this.fadeInfadeOut($('#cuaderno'), false);

			$('#botonCerrar').removeClass('oculto');
			$('#botoneraEditarCuentas').removeClass('oculto');
			$('#subcabecera').html('Posición Global');
			this.mostrarBackButton(false);

			$B.cuentaActual = {};
		},

		guardarBorrar: function(evdata) {
			evdata = evdata || {};
			var $target = $(evdata.currentTarget),
			$campoTexto = this.$el.find('[data-input-nueva-cuenta]'),
			$campoImporte = this.$el.find('[data-input-importe-inicial]'),
			nombreCuenta = this.$el.find('[data-input-edit-cuenta]').val(),
			$principalCheck = this.$el.find('[data-input-principal]'),
			cuentaPrincipal = false,
	    nombreHoja = $campoTexto.val(),
	    importeInicial = $campoImporte.val(),
	    self =this,
	    aleatorio = new Date(),
	    nuevosDatos,
	    nuevosMovs,
	    id = aleatorio.getTime(),
	    seleccion = [],
	    fecha = new Date(),
	    nuevoImporte,
	    accionFuncion = $target.attr('data-boton-editar');

	    if(importeInicial) {
	    	nuevoImporte = parseFloat(importeInicial.substring(0,importeInicial.length-1));
	    } else {
	    	nuevoImporte = 0;
	    }

	    if(accionFuncion === 'guardar' && nombreHoja !== "") {

				nuevosDatos = {  
					"saldoTotalCuenta":{
	              "importe": nuevoImporte

	        },
	        "divisa":"€",
	        "id":id,
	         "nombreHoja":nombreHoja
				};

				nuevosMovs = {  
          "tipo": "I",
          "importe": nuevoImporte || "0.00",
          "divisa": "€",
          "concepto": "Importe inicial",
          "cuenta" : nombreHoja,
          "idCuenta" : id,
          "fecha" : fecha,
          "ubicacion" : "",
          "ubicacionId" : "",
          "categoriaId" : "ingreso",
          "categoriaCss" : "credit"
        };

				this.model.nuevoMov(nuevosMovs, id);
				this.model.nuevaCuenta(nuevosDatos, id);

		    $campoTexto.val("");
		    this.$el.find('#firstAlert').remove();

  		} else if (accionFuncion === 'editar') {

				if ($principalCheck.attr('checked') === "checked") {
					cuentaPrincipal = true;
				} else {
					cuentaPrincipal = false;
				}
				
				this.model.renombrarCuenta($B.cuentaActual.id, nombreCuenta, id, cuentaPrincipal);
				this.cerrarEditarCuenta();  			
  		}	
  			this.cerrarNuevaCuenta();
  			this.cerrarSidebar();
		    this.volverAlInicio();
	},
});

$(document).ready(function() {
	var vs = new SingleCuaderno();
	vs.setElement($('#topAplicacion')).render();
});
