  (function () {
    _.mixin({

      c_fila_movs_template: function (data) {
        var defaults ={
          elementos: [],
          closable : true,
          classExtra: null
        };
        return _.template("#fila-movs-template", data);
      },

      formatSaldo: function (saldoTotal) {

      saldoTotal=Math.round(saldoTotal*100)/100;
      saldoTotal.toFixed(2);
      saldoTotal = saldoTotal.toString();

      if(saldoTotal.indexOf(".") === -1) {
        saldoTotal = saldoTotal + ".00";
      }
      return saldoTotal;
      },

      formatDate: function (value) {
        var fecha = new Date(value),
        fechaHOY = new Date(),
        fechaMovimiento = fecha;

        fechaHOY = fechaHOY.getFullYear().toString() + fechaHOY.getMonth().toString() + fechaHOY.getDate().toString();
        fechaMovimiento = fechaMovimiento.getFullYear().toString() + fechaMovimiento.getMonth().toString() + fechaMovimiento.getDate().toString();

        if(parseInt(fechaHOY) === parseInt(fechaMovimiento) + 1) {
          return "Ayer";
        } if (parseInt(fechaHOY) === parseInt(fechaMovimiento)) {
          return "Hoy";
        } else {
          return fecha.getDate() + "/" + (parseInt(fecha.getMonth())+1) + "/" + fecha.getFullYear().toString().substring(2);
        }
      },
      capitaliseFirstLetter: function (string) {
          return string.charAt(0).toUpperCase() + string.slice(1);
      },

      truncate: function (cadena, caracteres) {
        var cadena = cadena;

        if (cadena.length > caracteres) {
          return cadena.substring(0,caracteres) + "...";
        } else {
          return cadena;
        }
        
      }
    });
  }());

