





var PlayScreen = me.ScreenObject.extend({
	/**	
	 *  action to perform on state change
	 */
     
	onResetEvent: function() {	
      //me.game.reset();
		// add the background & foreground
	    // add the foreground

	    // add parallax background
	  //  me.game.add(new BackgroundObject(), 1);

	    // add a default HUD
	    me.game.addHUD(0, 0, me.video.getWidth(), 45);

	    // add a new HUD item
	    me.game.HUD.addItem("score", new ScoreObject());

	    // add a new HUD item
	    me.game.HUD.addItem("score2", new TimeObject());

	  


     
		var background_sprite10 = new me.SpriteObject (0, 0,   me.loader.getImage("background"));
		var grass_upper_1	    = new me.SpriteObject (0, 0,   me.loader.getImage("grass_upper"));
		
		var background_sprite11 = new me.SpriteObject (0, 127, me.loader.getImage("background"));
		var grass_lower_1       = new me.SpriteObject (0, 127, me.loader.getImage("grass_lower"));
		
		var background_sprite20 = new me.SpriteObject (0, 255, me.loader.getImage("background"));
		var grass_upper_2       = new me.SpriteObject (0, 255, me.loader.getImage("grass_upper"));
		
		var background_sprite21 = new me.SpriteObject (0, 383, me.loader.getImage("background"));
		var grass_lower_2       = new me.SpriteObject (0, 383, me.loader.getImage("grass_lower"));
		
		var background_sprite30 = new me.SpriteObject (0, 511, me.loader.getImage("background"));
		var grass_upper_3       = new me.SpriteObject (0, 511, me.loader.getImage("grass_upper"));
		
		var background_sprite31 = new me.SpriteObject (0, 639, me.loader.getImage("background"));
		var grass_lower_3 = new me.SpriteObject(0, 639, me.loader.getImage("grass_lower"));

		//var background_sprite40 = new me.SpriteObject(0, 127, me.loader.getImage("background"));
		//var grass_upper_4 = new me.SpriteObject(0, 12, me.loader.getImage("grass_upper1"));
		
		// instantiate teh mole Manager 
		var moleManager = new game.MoleManager(0, 0);
		
		// add all objects
		me.game.add (background_sprite10, 0);
		me.game.add (background_sprite11, 0);
		me.game.add (background_sprite20, 0);
		me.game.add (background_sprite21, 0);
		me.game.add (background_sprite30, 0);
		me.game.add (background_sprite31, 0);
		//me.game.add(background_sprite40, 0);

		me.game.add (grass_upper_1, 10);
		me.game.add (grass_lower_1, 20);
		me.game.add (grass_upper_2, 30);
		me.game.add (grass_lower_2, 40);
		me.game.add (grass_upper_3, 50);
		me.game.add(grass_lower_3, 60);
	//	me.game.add(grass_upper_4, 10);

		me.game.add(moleManager, 0);

	
		// make sure everything is sorted
		me.game.sort();

		
		// start the main soundtrack
		me.audio.playTrack("whack");
	},
	/**	
	 *  action to perform when leaving this screen (state change)
	 */
	onDestroyEvent: function() {
	    me.audio.stopTrack();

	    // remove the HUD
	    me.game.disableHUD();
	 //   me.input.releasePointerEvent('click', this);
	}
     
});



// create a custom loading screen
var PlayScreen2 = me.ScreenObject.extend(
{
   // constructor
   init: function()
   {
      // pass true to the parent constructor
      // as we draw our progress bar in the draw function
      this.parent(true);
      // a font logo
      this.logo = new me.Font('century gothic', 32, 'white');
      // flag to know if we need to refresh the display
      this.invalidate = false;
      // load progress in percent
      this.loadPercent = 0;
      // setup a callback
      me.loader.onProgress = this.onProgressUpdate.bind(this);

   },

   // will be fired by the loader each time a resource is loaded
   onProgressUpdate: function(progress)
   {
      this.loadPercent = progress;
      this.invalidate = true;
   },


   // make sure the screen is only refreshed on load progress
   update: function()
   {
      if (this.invalidate===true)
      {
         // clear the flag
         this.invalidate = false;
         // and return true
         return true;
      }
      // else return false
      return false;
   },

   // on destroy event
   onDestroyEvent : function ()
   {
      // "nullify" all fonts
      this.logo = null;
   },

   //	draw function
   draw : function(context)
   {
      // clear the screen
      me.video.clearSurface (context, "SaddleBrown");

      // measure the logo size
      logo_width = this.logo.measureText(context,"TIME OVER").width;

      // draw our text somewhere in the middle
      this.logo.draw(context,
                     "WELCOME monkeyFAST! ",
                     ((me.video.getWidth() - logo_width) / 2),
                     (me.video.getHeight() + 60) / 2);

      // display a progressive loading bar
      var width = Math.floor(this.loadPercent * me.video.getWidth());

      // draw the progress bar
      context.strokeStyle = "silver";
      context.strokeRect(0, (me.video.getHeight() / 2) + 40, me.video.getWidth(), 6);
      context.fillStyle = "SaddleBrown";
      context.fillRect(2, (me.video.getHeight() / 2) + 42, width-4, 2);



   context.fillText('...', 50, 420);
         context.beginPath();
         context.arc(50, 420, 150, 0, (Math.PI / 180) * 360, true);
         context.strokeStyle = "#794522"; //cafe
         context.lineWidth = 10;
         context.stroke();
         context.closePath()

         context.beginPath();
         context.arc(570, 480, 250, 0, (Math.PI / 180) * 360, true);
         context.strokeStyle = "#794522"; //cafe
         context.lineWidth = 10;
         context.stroke();
         context.closePath()



   },
});




/* loanding  screen inicio*/

var LoadingScreen = me.ScreenObject.extend(
{
	/*
	 * constructor
	 */
	init: function()
	{/// <reference path="../../data/img/background/bg_dirt128.png" />

		this.parent(true);
		this.bg = new Image();
		this.bg.src = "no/data/img/background/bkg0.jpg";//jpg
		this.loading = new me.Font("Verdana", 20, "white");
	},

	/*
	 * drawing function
	 */
	draw: function(context)
	{
		// clear the screen
		me.video.clearSurface(context, "black");
		context.drawImage(this.bg, 0, 0);

		var loadingText = "Loading...";
		var loadingSize = this.loading.measureText(context, loadingText);
		this.loading.draw(context, loadingText,
			(me.video.getWidth() / 2) - (loadingSize.width / 2),
			(me.video.getHeight() / 2) - (loadingSize.height / 2));
	}
});

/*loading screen fin*/






/*
 * menu screen
 */
var MenuScreen = me.ScreenObject.extend(
{
	/*
	 * constructor
	 */
	init: function()
	{
		// call parent constructor
		this.parent(true, true);

		// init stuff
		this.title = null;
		this.play = null;
		this.version = null;

		this.bg = new Image();
		this.bg.src = "no/data/img/background/bkg0.jpg";


	},

	/*
	 * reset function
	 */
	onResetEvent: function()
	{
	    // add parallax background
	   // me.game.add(new BackgroundObject(), 1);



		// load title image
		this.title = me.loader.getImage("title");
/// <reference path="../../data/img/background/play.png" />

		// play button
		this.play = new Button("play", me.state.PLAY, 280);

		// version
		this.version = new me.Font("Verdana", 20, "white");
	},

	/*
	 * drawing function
	 */
	draw: function(context) {

	   

	    // clear the screen
	 //  me.video.clearSurface(context, "orange");
	    context.drawImage(this.bg, 0, 0);


		// draw title
		context.drawImage(this.title, (me.video.getWidth() / 2 - this.title.width / 2), 200);

		// draw play button
		this.play.draw(context);

		// game version
		var versionText = "0.3";
		var versionSize = this.version.measureText(context, versionText);

		this.version.draw(context, versionText,
			me.video.getWidth() - versionSize.width - 3, me.video.getHeight() - 5);

           


	},

	/*
	 * destroy event function
	 */
	onDestroyEvent: function()
	{
		// release mouse event
		//me.input.releaseMouseEvent("mousedown", this.play);
	    me.input.releasePointerEvent('click', this.play);

          
	}
});





  /*
  * menu screen
  */
var GameOverScreen = me.ScreenObject.extend(
{
    /*
    * constructor
    */
    init: function () {
        // call parent constructor
        this.parent(true, true);

        // init stuff
        this.title = null;
        this.title2 = null;

        this.restart = null;

        this.bg = new Image();
        this.bg.src = "no/data/img/background/bkg0.jpg";

        this.end = null;

        this.score = null;
        this.finalScore = null;
    },

    /*
    * reset function
    */
    onResetEvent: function (score) {

        this.finalScore = score;
      //  alert("score resultado es" + score);

        // load title image
        this.title = me.loader.getImage("title");
        // load title image
        // this.title2 = me.loader.getImage("title2");
        /// <reference path="../../data/img/background/play.png" />

        // play button
        this.restart = new Button("play2", me.state.PLAY, 280);


        // labels
        this.end = new me.Font("Verdana", 25, "white");
        this.score = new me.Font("Verdana", 22, "white");


    },

    /*
    * drawing function
    */
    draw: function (context) {



        // clear the screen
        //  me.video.clearSurface(context, "orange");
        context.drawImage(this.bg, 0, 0);


        // draw title
        context.drawImage(this.title, (me.video.getWidth() / 2 - this.title.width / 2), 200);

        // draw play button
        this.restart.draw(context);


        // draw end label
        var endText = "finish!";
        var endSize = this.end.measureText(context, endText);

        this.end.draw(context, endText,
			me.video.getWidth() / 2 - endSize.width / 2, 120);

        // draw score label
        var scoreText = "Score : " + this.finalScore;
        
        var scoreSize = this.score.measureText(context, scoreText);

	 document.getElementById("lbscorecurrent").innerHTML= this.finalScore;
	
	
        this.score.draw(context, scoreText,
			me.video.getWidth() / 2 - scoreSize.width / 2, 150);
	
	
	document.getElementById("btnplay").style.display="block";;

	document.getElementById("btntwit").style.left="60%";
	
	
		document.getElementById("btntwit2").style.left="-60%";
	
    },

    /*
    * destroy event function
    */
    onDestroyEvent: function () {
        // release mouse event
        //me.input.releaseMouseEvent("mousedown", this.play);
        me.input.releasePointerEvent('click', this.play);


    }
});
















