/**
 * Singleton Push notifications
 */
define([
  'jquery'
],function($) {

  var config = {};

  var instance = null;
  
  var pushRegistered = false;
  var pushNotification = null;
  
  function PushNotifications(){
    if(instance !== null){
      throw new Error("Cannot instantiate more than one PushNotifications, use PushNotifications.getInstance()");
    }
  }

  PushNotifications.prototype = {
    init: function(config) {
      var push = this;
      this.config = config;
      
      this.handleRegistrationOld();
      
      /*var push = PushNotification.init({ 
        "android": {"senderID": "764810367497"},
        "ios": {"alert": "true", "badge": "true", "sound": "true"}, 
        "windows": {} 
      });

      push.on('registration', push.handleRegistration);

      push.on('notification', push.handleNotification);

      push.on('error', function(e) {
          // e.message
          console.log('Registration:', JSON.stringify(e));
      });*/
    },

    /*handleRegistration: function(data) {
      // data.registrationId
      console.log('Registration:', JSON.stringify(data));
      $.ajax(API_BASE_URL + "?v=" + API_VERSION + "&service=registerPushChannel", {
        xhrFields: { mozAnon: true, mozSystem: true },
        data: JSON.stringify({
          token: localStorage["loginToken"],
          device: device.platform,
          model: device.model,
          registrationId: data.registrationId
        }),
        type: 'POST',
        cache: false,
        dataType: "json"
      }).done(function(data) {
        $(EVENT_BUS).trigger("moviesom.pushNotifications:registration:done", data);
      })
      .fail(function(data) {
        $(EVENT_BUS).trigger("moviesom.pushNotifications:registration:fail", data);
      })
      .always(function() {
        $(EVENT_BUS).trigger("moviesom.pushNotifications:registration:always");
      });
    },*/
    
    /*handleNotification: function() {
      // data.message,
      // data.title,
      // data.count,
      // data.sound,
      // data.image,
      // data.additionalData
      alert(JSON.stringify(notification));
    },*/

    handleRegistrationOld: function() {
      var push = this;
      if (push.pushRegistered === false && window.plugins != null && window.plugins.pushNotification != null) {
        push.pushNotification = window.plugins.pushNotification;
        var platform = device.platform.toString().toLowerCase();
        if (platform == 'android') {
          push.pushNotification.register(push.androidSuccessHandler, push.pushErrorHandler, { "senderID": "701902199774", "ecb": "onNotificationGCM" });
        } else if (platform == 'ios') {
          push.pushNotification.register(push.iOsTokenHandler, push.pushErrorHandler, { "badge": "true", "sound": "true", "alert": "true", "ecb": "onNotificationAPN" });
        } else if (platform == 'wince' || platform == 'win32nt') {
          push.pushNotification.register(push.wp8SuccessHandler, push.pushErrorHandler, { "channelName": "MovieSom", "ecb": "onNotificationEcb" });
        } else if (platform == 'firefoxos') {
          //console.log("Register FirefoxOS push notification service");
          navigator.mozSetMessageHandler("push", function (message) {
            //console.log("push notification endpoint: " + message.pushEndpoint);
            //console.log("push notification: " + message.version);
            var notification = navigator.mozNotification.createNotification("MovieSom", "An event has occurred");
            notification.show();
          });
          navigator.mozSetMessageHandler("push-register", function () {
            registerPushNotifications();
          });
          var req = navigator.push.register();
          req.onsuccess = function () {
            //console.log("Register FirefoxOS push channel success");
            var endpoint = req.result;
            // send uri to notification server
            //console.log('FireFoxOS push registered: ' + endpoint);
            push.pushRegistered = true;
            push.setPushChannel("pozzy", endpoint);
          }
          req.onerror = function (e) {
            alert("FireFoxOS push register error: " + JSON.stringify(e))
          }
        }
      }
    },
    
    /**
     * WP8
     */
    wp8SuccessHandler: function (result) {
      // send uri to notification server
      //console.log('push registered: ' + JSON.stringify(result));
      this.pushRegistered = true;
      this.setPushChannel(result.channel, result.uri);
    },

    /**
     * Android
     */
    androidSuccessHandler: function (result) {
      //console.log('push registered: ' + result);
      this.pushRegistered = true;
    },

    /**
     * iOS
     */
    iOsTokenHandler: function (result) {
      //console.log('push registered, device token: ' + result);
      this.pushRegistered = true;
      this.setPushChannel("MovieSom", result);
    },

    // result contains any error description text returned from the plugin call
    pushErrorHandler: function (error) {
      alert(JSON.stringify(error));
    },

    // WP8
    onNotificationEcb: function (e) {
      navigator.notification.alert(e.text2, function () { }, e.text1);
    },

    // iOS
    onNotificationAPN: function (event) {
      if (event.alert) {
        navigator.notification.alert(event.alert);
      }

      if (event.sound) {
        var snd = new Media(event.sound);
        snd.play();
      }

      if (event.badge) {
        this.pushNotification.setApplicationIconBadgeNumber(this.successHandler, this.errorHandler, event.badge);
      }
    },

    // Android
    onNotificationGCM: function (e) {
      //consoleLog("Push event received: " + e.event);

      switch (e.event) {
        case 'registered':
          if (e.regid.length > 0) {
            //console.log("Push event registered, regID: " + e.regid);
            // Your GCM push server needs to know the regID before it can push to this device
            // here is where you might want to send it the regID for later use.
            this.setPushChannel("MovieSom", e.regid);
          }
          break;

        case 'message':
          // if this flag is set, this notification happened while we were in the foreground.
          // you might want to play a sound to get the user's attention, throw up a dialog, etc.
          if (e.foreground) {
            //console.og("Inline push notification");

            // if the notification contains a soundname, play it.
            // var my_media = new Media("/android_asset/www/" + e.soundname);
            // my_media.play();
          }
          else {  // otherwise we were launched because the user touched a notification in the notification tray.
            if (e.coldstart) {
              //console.log("Coldstart push notification");
            }
            else {
              //console.log("Background push notification");
            }
          }

          navigator.notification.alert(e.payload.message, function () { });
          break;

        case 'error':
          alert(JSON.stringify(e));
          break;

        default:
          alert("Push notification error: Unknown, an event was received and we do not know what it is");
          break;
      }
    },

    /**
     * Register push notification channel on notifications server.
     */
    setPushChannel: function (channel, token) {
      //console.log("setPushChannel called: [" + channel + "] " + token);
      $(EVENT_BUS).trigger("setPushChannel");

      $.ajax(API_BASE_URL + "?v=" + API_VERSION + "&service=registerPushChannel", {
        xhrFields: { mozAnon: true, mozSystem: true },
        data: JSON.stringify({
          token: localStorage["loginToken"],
          channel: channel,
          device: device.platform,
          model: device.model,
          registrationId: token
        }),
        type: 'POST',
        cache: false,
        dataType: "json"
      }).done(function(data) {
        alert(JSON.stringify(data));
        $(EVENT_BUS).trigger("moviesom.pushNotifications:registration:done", data);
      })
      .fail(function(data) {
        alert(JSON.stringify(data));
        $(EVENT_BUS).trigger("moviesom.pushNotifications:registration:fail", data);
      })
      .always(function() {
        $(EVENT_BUS).trigger("moviesom.pushNotifications:registration:always");
      });
    },
    
    getInstance: function() {
      if(instance === null) {
        instance = new PushNotifications();
      }
      return instance;
    }
    
  };
  
  return instance||new PushNotifications();
});