MovistarCo.module('DestacadosApp.List', function(List, MovistarCo, Backbone, Marionette, $, _){
    List.Controller = {
        listDestacados: function(){
            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);
      
            var fetchingDestacados = MovistarCo.request('destacados:entities');
            
            var destacadosListLayout = new MovistarCo.Common.Views.ViewLayout();
            var destacadosHeadView = new MovistarCo.Common.Views.HeadMenu({opcion: "<span class='icon-chat-blanco'></span>"});
            
            $.when(fetchingDestacados).done(function (destacados){
                
                var destacadosCollectionView;
                
                if(destacados !== undefined){
                    destacadosCollectionView = new List.Destacados({
                        collection: destacados 
                    });
                
                    destacadosCollectionView.on('itemview:share:facebook', function(childView, model){
                        console.log('shared fb ' + model.get('id'));
                        /*FB.init({
                            appId: '1425440847688665'
                        });
                        console.log(FB);*/

                        /*var url = encodeURIComponent('http://www.movistar.co');
                        new MozActivity({ 
                            name:'view', 
                            data: 
                            { 
                                type: 'url', 
                                url: 'https://www.facebook.com/sharer/sharer.php?u='+url
                            } 

                        });*/

                        FB.ui(
                        {
                          method: 'feed',
                          name: 'MovistarCo',
                          link: 'http://www.movistar.co/',
                          picture: model.get('imagen'),
                          caption: model.get('titulo'),
                          description: model.get('descripcion')
                        },
                        function(response) {
                          if (response && response.post_id) {
                            alert('El Post fué publicado.');
                          } else {
                            alert('El Post no pudo ser publicado.');
                          }
                        }
                      );
              
              console.log(FB);
                    });
                
                    destacadosCollectionView.on('itemview:share:twitter', function(childView, model){

                        var url = encodeURIComponent('http://www.movistar.co');
                        var via = encodeURIComponent('MovistarCo');
                        var text = encodeURIComponent(model.get('titulo') + ' - ' + model.get('descripcion'));
                        new MozActivity({ 
                            name:'view', 
                            data: 
                            { 
                                type: 'url', 
                                url: 'http://twitter.com/share?url='+url+'&via='+via+'&text='+text
                            } 

                        });
                    });
                
                    destacadosCollectionView.on('itemview:share:google', function(childView, model){
                        console.log('shared gp ' + model.get('id'));

                        //con esto solo puedo publicar una url
                        var url = encodeURIComponent('http://www.movistar.co');

                        new MozActivity({ 
                            name:'view', 
                            data: 
                            { 
                                type: 'url', 
                                url: 'https://plus.google.com/share?url='+url
                            } 
                        });
                    });
                
                    destacadosCollectionView.on('itemview:destacados:detalle', function(childView, model){
                        MovistarCo.trigger('destacados:detalle', {
                            id: model.get('id'), 
                            titulo: model.get('titulo'), 
                            descripcion: model.get('descripcion'),
                            imagen: model.get('imagen')
                        });
                    });

                }else{
       
                    destacadosCollectionView = new MovistarCo.Common.Views.Error();
                }
                
                destacadosListLayout.on('show', function(){
                    destacadosListLayout.headRegion.show(destacadosHeadView);
                    destacadosListLayout.bodyRegion.show(destacadosCollectionView);
                });

                MovistarCo.mainRegion.show(destacadosListLayout);
  
            });
        }
    };
});
