MovistarCo.module('DestacadosApp.List', function(List, MovistarCo, Backbone, Marionette, $, _){
    
    List.Destacado = Marionette.ItemView.extend({
        template: '#destacado-template',
        className: 'item-destacados',
        
        events : {
            'click span.icon-fb': 'shareFacebook',
            'click span.icon-tw': 'shareTwitter',
            'click span.icon-gp': 'shareGoogle',
            'click div.destacados-body': 'detalle'
        },
        
        shareFacebook: function(){
            this.trigger('share:facebook', this.model);
        },
        
        shareTwitter: function(){
            this.trigger('share:twitter', this.model);
        },
        
        shareGoogle: function(){
            this.trigger('share:google', this.model);
        },
        
        detalle: function(){
            this.trigger('destacados:detalle', this.model);
        }
    });
    
    List.Destacados = Marionette.CollectionView.extend({
        itemView: List.Destacado
    });
});
