MovistarCo.module('MenuApp.List', function(List, MovistarCo, Backbone, Marionette, $, _){

    List.MenuChild = Marionette.ItemView.extend({
        template: '#menu-item-child',
        className: 'menu-child',

        onRender: function(){
            if(this.model.selected){
                this.$el.addClass('active');
            }
        },

        events: {
            'click': 'navigate'
        },

        navigate : function(e){
            e.preventDefault();
            //se cierra el menu
            $('#menu').toggleClass("spmenu-open");
            $("body").toggleClass("spmenu-push-toright");
            this.trigger('navigate', this.model);
        }
    });

    List.MenuRow = Marionette.CompositeView.extend({
        template: '#menu-item-row',
        className: 'menu-row',
        itemView: List.MenuChild,
        itemViewContainer: 'div.menu-body',

        initialize: function(){
            this.collection = this.model.get('children');
        },

        onRender: function(){
            if(this.model.selected){
                this.$el.addClass('active');
            }
        }
    });

    List.ItemsMenu = Marionette.CollectionView.extend({
        itemView: List.MenuRow,
        id: 'menu',
        tagName: 'nav',
        className: 'spmenu spmenu-vertical spmenu-left'
    });
});
