MovistarCo.module('OfertasApp.List', function(List, MovistarCo, Backbone, Marionette, $, _){
    List.Controller = {
        listOfertas: function(){
            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);
      
            var ofertasListLayout = new MovistarCo.Common.Views.ViewLayout();
            var ofertasHeadView = new MovistarCo.Common.Views.HeadMenu({opcion: "<span class='icon-chat-blanco'></span>"});;
      
            var fetchingOfertas = MovistarCo.request('ofertas:entities');
            $.when(fetchingOfertas).done(function (ofertas){
                
                var ofertasCollectionView;
                if(ofertas){
                    ofertasCollectionView = new List.Ofertas({
                        collection: ofertas
                    });

                    ofertasCollectionView.on('itemview:share:facebook', function(childView, model){
                        console.log('shared fb ' + model.get('id'));
                        FB.ui(
                        {
                          method: 'feed',
                          name: 'MovistarCo',
                          link: 'http://www.movistar.co/',
                          picture: model.get('imagen'),
                          caption: model.get('titulo'),
                          description: model.get('descripcion')
                        },
                        function(response) {
                          if (response && response.post_id) {
                            alert('El Post fué publicado.');
                          } else {
                            alert('El Post no pudo ser publicado.');
                          }
                        }
                      );
                    });

                    ofertasCollectionView.on('itemview:share:twitter', function(childView, model){
                        console.log('shared tw ' + model.get('id'));
                        var url = encodeURIComponent('http://www.movistar.co');
                        var via = encodeURIComponent('MovistarCo');
                        var text = encodeURIComponent(model.get('titulo') + ' - ' + model.get('descripcion'));
                        new MozActivity({ 
                            name:'view', 
                            data: 
                            { 
                                type: 'url', 
                                url: 'http://twitter.com/share?url='+url+'&via='+via+'&text='+text
                            } 

                        });

                    });

                    ofertasCollectionView.on('itemview:share:google', function(childView, model){
                        console.log('shared gp ' + model.get('id'));
                        var url = encodeURIComponent('http://www.movistar.co');

                        new MozActivity({ 
                            name:'view', 
                            data: 
                            { 
                                type: 'url', 
                                url: 'https://plus.google.com/share?url='+url
                            } 
                        });
                    });

                    ofertasCollectionView.on('itemview:ofertas:detalle', function(childView, model){
                        MovistarCo.trigger('ofertas:detalle', {
                            id: model.get('id'), 
                            titulo: model.get('titulo'), 
                            descripcion: model.get('descripcion'),
                            imagen: model.get('imagen')
                        });
                    });
                }else{
                    ofertasCollectionView = new MovistarCo.Common.Views.Error();
                }
 
                ofertasListLayout.on('show', function(){
                    ofertasListLayout.headRegion.show(ofertasHeadView);
                    ofertasListLayout.bodyRegion.show(ofertasCollectionView);
                });
                MovistarCo.mainRegion.show(ofertasListLayout);
            });
        }
    };
});
