MovistarCo.module('OfertasApp.Show', function(Show, MovistarCo, Backbone, Marionette, $, _){
    Show.Controller = {
        showOfertaDetalle: function(data){
            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);
            
            var detalleListLayout = new MovistarCo.Common.Views.ViewLayout();
            var detalleHeadView = new MovistarCo.Common.Views.HeadBack({titulo: 'Oferta', url: 'ofertas'});
                
            var fetchingDetalle = MovistarCo.request('ofertas:detalle:entity', data);
            $.when(fetchingDetalle).done(function (detalle){
                
                var detalleView;
                if(detalle !== undefined){
                    detalleView = new Show.Detalle({
                        model: detalle 
                    });
                }else{
                    detalleView = new MovistarCo.Common.Views.Error();
                }

                detalleListLayout.on('show', function(){
                    detalleListLayout.headRegion.show(detalleHeadView);
                    detalleListLayout.bodyRegion.show(detalleView);
                });
                
                MovistarCo.mainRegion.show(detalleListLayout);
            });
        }
    };
});


