MovistarCo.module('OficinasApp.Pagos', function(Pagos, MovistarCo, Backbone, Marionette, $, _){
    
    Pagos.Controller = {
        showPagos : function(){
            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);
            
            var fetchingPagos = MovistarCo.request('pagos:entities');
            
            var pagosShowLayout = new MovistarCo.Common.Views.ViewLayout();
            var pagosHeadView = new MovistarCo.Common.Views.HeadBack({titulo: 'Puntos de Pago', url: 'oficinas', data: MovistarCo.OficinasApp.Show.Utilities.ciudad});
            
            $.when(fetchingPagos).done(function (pagos){
                
                var pagosCollectionView;
                if(pagos){
                    pagosCollectionView = new Pagos.PuntosPago({
                        collection: pagos 
                    });
                }else{
                    pagosCollectionView = new MovistarCo.Common.Views.Error();
                }

                pagosShowLayout.on('show', function(){
                    pagosShowLayout.headRegion.show(pagosHeadView);
                    pagosShowLayout.bodyRegion.show(pagosCollectionView);
                });
                
                MovistarCo.mainRegion.show(pagosShowLayout);
            });
        }
    };
});
