MovistarCo.module('OficinasApp.Show', function(Show, MovistarCo, Backbone, Marionette, $, _){
    
    Show.Utilities = {
        drawMarkets : function(map, ciudades, ciudad){
            if(Show.Utilities.markets !== undefined){
                Show.Utilities.clearMarkets();
            }else{
                Show.Utilities.markets = new Array();
            }
            
            var infoWindow = new google.maps.InfoWindow({content: '', maxWidth: 250});
            
            for(var i=0;i<ciudades.length;i++){
                if(ciudades[i].nombre === ciudad){
                    var fetchingOficinas = MovistarCo.request('oficinas:entities', ciudades[i].id);
                    $.when(fetchingOficinas).done(function(tiendas){
                        for(var j=0;j<tiendas.length;j++){
                            var tienda = tiendas[j];
                            Show.Utilities.markets[j] = new google.maps.Marker({
                                position: new google.maps.LatLng(tienda.latitud, tienda.longitud),
                                map: map,
                                icon: 'assets/images/pin.png'
                            });

                            var iconTienda = Show.Utilities.validarAperturaTienda(tienda) === 1 ? 'icon-abierto' : 'icon-cerrado';
                            
                            Show.Utilities.bindInfoWindow(Show.Utilities.markets[j], 
                                map, 
                                infoWindow, 
                                _.template($('#info-window-template').html(), 
                                    {nombre: tienda.nombre, 
                                     direccion: tienda.direccion,
                                     icon: iconTienda})
                            );
                    
                            //console.log(tienda.nombre + ': ' + Show.Utilities.validarAperturaTienda(tienda));
                        }
                        Show.Utilities.tiendas = tiendas;
                    });
                    map.setCenter(new google.maps.LatLng(ciudades[i].latitud,ciudades[i].longitud));
                    map.setZoom(11);
                    Show.Utilities.ciudad = ciudad;
                    i = ciudades.length;
                }
            }
        },
        
        clearMarkets: function(){
            Show.Utilities.markets.forEach(function(market){
                market.setMap(null);
                delete market;
            });
        },
        
        bindInfoWindow: function (marker, map, infowindow, description) {
            google.maps.event.addListener(marker, 'click', function() {
                infowindow.setContent(description);
                infowindow.open(map, marker);
            });
        },
        
        validarAperturaTienda: function(tienda){
            var horaApertura, minutosApertura, horaCierre, minutosCierre;
            var horaAperturaT, minutosAperturaT, horaCierreT, minutosCierreT;
            var horaAperturaS, minutosAperturaS, horaCierreS, minutosCierreS;
            var horaAperturaD, minutosAperturaD, horaCierreD, minutosCierreD;
            
            if(Show.Utilities.validarHora(tienda.horaApertura)){
                var horaSplit = tienda.horaApertura.split(":");
                horaApertura = parseInt(horaSplit[0]);
                minutosApertura = parseInt(horaSplit[1]);
            }else{
                horaApertura = parseInt(tienda.horaApertura);
                minutosApertura = 0;
            }
            if(Show.Utilities.validarHora(tienda.horaCierre)){
                var horaSplit = tienda.horaCierre.split(":");
                horaCierre = parseInt(horaSplit[0]);
                minutosCierre = parseInt(horaSplit[1]);
            }else{
                horaCierre = parseInt(tienda.horaCierre);
                minutosCierre = 0;
            }
            
            if(Show.Utilities.validarHora(tienda.horaAperturaT)){
                var horaSplit = tienda.horaAperturaT.split(":");
                horaAperturaT = parseInt(horaSplit[0]);
                minutosAperturaT = parseInt(horaSplit[1]);
            }else{
                horaAperturaT = parseInt(tienda.horaAperturaT);
                minutosAperturaT = 0;
            }
            if(Show.Utilities.validarHora(tienda.horaCierreT)){
                var horaSplit = tienda.horaCierreT.split(":");
                horaCierreT = parseInt(horaSplit[0]);
                minutosCierreT = parseInt(horaSplit[1]);
            }else{
                horaCierreT = parseInt(tienda.horaCierreT);
                minutosCierreT = 0;
            }
            
            if(Show.Utilities.validarHora(tienda.horaAperturaS)){
                var horaSplit = tienda.horaAperturaS.split(":");
                horaAperturaS = parseInt(horaSplit[0]);
                minutosAperturaS = parseInt(horaSplit[1]);
            }else{
                horaAperturaS = parseInt(tienda.horaAperturaS);
                minutosAperturaS = 0;
            }
            if(Show.Utilities.validarHora(tienda.horaCierreS)){
                var horaSplit = tienda.horaCierreS.split(":");
                horaCierreS = parseInt(horaSplit[0]);
                minutosCierreS = parseInt(horaSplit[1]);
            }else{
                horaCierreS = parseInt(tienda.horaCierreS);
                minutosCierreS = 0;
            }
            
            if(Show.Utilities.validarHora(tienda.horaAperturaD)){
                var horaSplit = tienda.horaAperturaD.split(":");
                horaAperturaD = parseInt(horaSplit[0]);
                minutosAperturaD = parseInt(horaSplit[1]);
            }else{
                horaAperturaD = parseInt(tienda.horaAperturaD);
                minutosAperturaD = 0;
            }
            if(Show.Utilities.validarHora(tienda.horaCierreD)){
                var horaSplit = tienda.horaCierreD.split(":");
                horaCierreD = parseInt(horaSplit[0]);
                minutosCierreD = parseInt(horaSplit[1]);
            }else{
                horaCierreD = parseInt(tienda.horaCierreD);
                minutosCierreD = 0;
            }

            var date = new Date();
            var hora = date.getHours();
            var min = date.getMinutes();
            var dia = date.getDay();
            var tiendaAbierta;
            
            /*console.log('dia: ' + dia + ' hora: ' + hora + ' min: ' + min);
            console.log('h: ' + horaApertura + ' m: ' + minutosApertura);
            console.log('hC ' + horaCierre + ' mC: ' + minutosCierre);
            console.log('hT: ' + horaAperturaT + ' mT: ' + minutosAperturaT);
            console.log('hTC ' + horaCierreT + ' mTC: ' + minutosCierreT);
            console.log('hS: ' + horaAperturaS + ' mS: ' + minutosAperturaS);
            console.log('hSC ' + horaCierreS + ' mSC: ' + minutosCierreS);
            console.log('hD: ' + horaAperturaD + ' mD: ' + minutosAperturaD);
            console.log('hDC ' + horaCierreD + ' mDC: ' + minutosCierreD);*/
            
            if(dia === 0){//domingo
                if (hora >= horaAperturaD && hora < horaCierreD) {
                    tiendaAbierta = 1;
                } else if (hora === horaAperturaD) {
                    if (min >= minutosAperturaD) {
                        tiendaAbierta = 1;
                    } else {
                        tiendaAbierta = 0;
                    }
                } else if (hora === horaCierreD) {
                    if (min < minutosCierreD) {
                        tiendaAbierta = 1;
                    } else {
                        tiendaAbierta = 0;
                    }
                } else {
                    tiendaAbierta = 0;
                }
            } else if (dia === 6) {//sabado
                if (hora >= horaAperturaS && hora < horaCierreS) {
                    tiendaAbierta = 1;
                } else if (hora === horaAperturaS) {
                    if (min >= minutosAperturaS) {
                        tiendaAbierta = 1;
                    } else {
                        tiendaAbierta = 0;
                    }
                } else if (hora === horaCierreS) {
                    if (min < minutosCierreS) {
                        tiendaAbierta = 1;
                    } else {
                        tiendaAbierta = 0;
                    }
                } else {
                    tiendaAbierta = 0;
                }
            } else {//otro dia
                if ((hora > horaApertura && hora < horaCierre) || (hora > horaAperturaT && hora < horaCierreT)) {

                    tiendaAbierta = 1;
                } else if (hora === horaApertura) {
                    if (min >= minutosApertura) {
                        tiendaAbierta = 1;
                    } else {
                        tiendaAbierta = 0;
                    }
                } else if (hora === horaCierre) {
                    if (min < minutosCierre) {
                        tiendaAbierta = 1;
                    } else {
                        tiendaAbierta = 0;
                    }
                } else if (hora === horaAperturaT) {
                    if (min >= minutosAperturaT) {
                        tiendaAbierta = 1;
                    } else {
                        tiendaAbierta = 0;
                    }
                } else if (hora === horaCierreT) {
                    if (min < minutosCierreT) {
                        tiendaAbierta = 1;
                    } else {
                        tiendaAbierta = 0;
                    }
                } else {
                    tiendaAbierta = 0;
                }
            }
            return tiendaAbierta;
        },
        
        validarHora: function(hora){
            if(hora.indexOf(":") !== -1){
                return true;
            }else{
                return false;
            }
        }
    };
    
    Show.Controller = {
        showOficinas: function(ciudad){
            
            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);
            
            var fetchingCiudades = MovistarCo.request('ciudades:entities');
            var oficinasShowLayout = new MovistarCo.Common.Views.ViewLayout();
            var oficinasHeadView = new MovistarCo.Common.Views.HeadMenu({opcion: "<div class='js-pagos'>Pagos</div>"});
            
            $.when(fetchingCiudades).done(function (ciudades){
                
                var successPosition = function(position){
                    var lat = position.coords.latitude;
                    var lgn = position.coords.longitude;
                    var fetchingCiudad = MovistarCo.Entities.getCity(lat,lgn);
                    $.when(fetchingCiudad).done(function(ciudad){
                        var myloc = new google.maps.Marker({
                            clickable: false,
                            icon: new google.maps.MarkerImage('https://maps.gstatic.com/mapfiles/mobile/mobileimgs2.png',
                                                    new google.maps.Size(22,22),
                                                    new google.maps.Point(0,18),
                                                    new google.maps.Point(11,11)),
                            shadow: null,
                            zIndex: 999,
                            map: oficinasView.map,
                            position: new google.maps.LatLng(lat,lgn)
                        });
                        Show.Utilities.drawMarkets(oficinasView.map, ciudades, ciudad);
                    });
                };
                
                var errorPosition = function(error){
                    alert('No se ha podido obtener su posición. Error ' + error.code);
                };
                
                var ciudadesName = _.map(ciudades, function(item){
                    return item.nombre;
                });
                
                var oficinasView = new Show.Oficinas({
                    tags: ciudadesName
                });
                
                oficinasView.on('change:city', function(ciudad){
                    Show.Utilities.drawMarkets(oficinasView.map, ciudades, ciudad);
                });
                
                oficinasView.on('oficinas:list', function(){
                    
                    var tiendas = _.map(Show.Utilities.tiendas, function(item){
                        return {nombre: item.nombre, direccion: item.direccion};
                    });

                    MovistarCo.trigger('oficinas:list', ciudadesName, tiendas);
                });
                
                oficinasView.on('oficinas:location', function(){
                    if(navigator.geolocation){
                        navigator.geolocation.getCurrentPosition(successPosition, errorPosition);
                    }else{
                        alert('La geolocalización no está soportada.');
                    }
                });
                
                oficinasView.on('oficinas:reload', function(){
                    MovistarCo.trigger('oficinas');
                });

                oficinasShowLayout.on('show', function(){
                    oficinasShowLayout.headRegion.show(oficinasHeadView);
                    oficinasShowLayout.bodyRegion.show(oficinasView);
                });

                MovistarCo.mainRegion.show(oficinasShowLayout);
                
                if(ciudad !== undefined){
                    Show.Utilities.drawMarkets(oficinasView.map, ciudades, ciudad);
                }else{
                    if(navigator.geolocation){
                        navigator.geolocation.getCurrentPosition(successPosition, errorPosition);
                    }else{
                        alert('La geolocalización no está soportada.');
                    }
                }
            });
        },
        
        showTiendas: function(ciudades, tiendas){
            var tiendasShowLayout = new MovistarCo.Common.Views.ViewLayout();
            var tiendasHeadView = new MovistarCo.Common.Views.HeadMenu();
            
            var tiendasView = new Show.Lista({
                tags: ciudades,
                collection: new MovistarCo.Entities.TiendaCollection(tiendas)
            });
                    
            tiendasView.on('oficinas:map', function(){
                MovistarCo.trigger('oficinas', Show.Utilities.ciudad);
            });
            
            tiendasView.on('change:city:list', function(ciudad){
                MovistarCo.trigger('oficinas', ciudad);
            });
            
            tiendasView.on('oficinas:location', function(){
                MovistarCo.trigger('oficinas');
            });
            
            tiendasView.on('oficinas:reload', function(){
                MovistarCo.trigger('oficinas');
            });
                    
            tiendasShowLayout.on('show', function(){
                    tiendasShowLayout.headRegion.show(tiendasHeadView);
                    tiendasShowLayout.bodyRegion.show(tiendasView);
                });

            MovistarCo.mainRegion.show(tiendasShowLayout);
        }
    };
});


