MovistarCo.module('OficinasApp.Show', function(Show, MovistarCo, Backbone, Marionette, $, _){
    
    Show.Oficinas = Marionette.ItemView.extend({
        template: '#oficinas-template',
        className: 'oficinas',
        
        events: {
            'click input#r-list': 'list',
            'click span.js-location': 'location',
            'click span.js-reload': 'reload'
        },
        
        list: function(){
            this.trigger('oficinas:list');
        },
        
        location: function(){
            this.trigger('oficinas:location');
        },
        
        reload: function(){
            this.trigger('oficinas:reload');
        },
        
        initialize: function(options){
            var options = options || {};
            this.tags = options.tags;
        },
        
        onRender: function(){
            var mapOptions = {
                center: new google.maps.LatLng(4.592852,-74.081669),//por defecto bogota
                zoom: 8,
                disableDefaultUI: true,
                zoomControl: true,
                zoomControlOptions: {
                    position: google.maps.ControlPosition.RIGHT_BOTTOM
                }
            };
            this.map = new google.maps.Map(this.el.children[1], mapOptions);
            var self = this;
            
            //con esto se trata de dar solucion a un bug de google maps que hace que no se renderice adecuadamente el mapa
            google.maps.event.addListener(this.map, "idle", function(){
                google.maps.event.trigger(self.map, 'resize'); 
            });
            
            /*----------------*/

            //text para busqueda de las ciudades
            $(this.el.children[0].children[0]).autocomplete({
                source:self.tags, 
                select: function(event, ui){
                    self.trigger('change:city', ui.item.label);
                }
            });
        }
    });
    
    Show.ItemLista = Marionette.ItemView.extend({
        template: '#oficinas-itemlist-template',
        className: 'itemlist'
    });
    
    Show.Lista = Marionette.CompositeView.extend({
        template: '#oficinas-template',
        className: 'oficinas tiendas',
        itemView: Show.ItemLista,
        itemViewContainer: '#map',
        
        events: {
            'click input#r-map': 'map',
            'click span.js-location': 'location',
            'click span.js-reload': 'reload'
        },
        
        map: function(){
            this.trigger('oficinas:map');
        },
        
        location: function(){
            this.trigger('oficinas:location');
        },
        
        reload: function(){
            this.trigger('oficinas:reload');
        },
        
        initialize: function(options){
            var options = options || {};
            this.tags = options.tags;
        },
        
        onRender: function(){
            this.el.children[2].children[3].checked = true;
            var self = this;
            //text para busqueda de las ciudades
            $(this.el.children[0].children[0]).autocomplete({
                source:self.tags, 
                select: function(event, ui){
                    self.trigger('change:city:list', ui.item.label);
                }
            });
        }
    });
});


