MovistarCo.module('ProgramacionApp.Canal', function(Canal, MovistarCo, Backbone, Marionette, $, _){
    Canal.Controller = {
        listProgramacionCanal: function(data){
            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);

            var fetchingProgramacion = MovistarCo.request('programacion:canal:entities', data);
            
            var programacionListLayout = new MovistarCo.Common.Views.ViewLayout();
            var programacionHeadView = new MovistarCo.Common.Views.HeadBack({titulo: data.nombre, url: 'programacion'});
            
            $.when(fetchingProgramacion).done(function (programacion){
                var programacionCollectionView;
                if(programacion !== undefined){
                    programacionCollectionView = new Canal.Programacion({
                        model: programacion,
                        nombre: data.nombre,
                        dia: data.dia
                    });
                }else{
                    programacionCollectionView = new MovistarCo.Common.Views.Error();
                }

                programacionListLayout.on('show', function() {
                    programacionListLayout.headRegion.show(programacionHeadView);
                    programacionListLayout.bodyRegion.show(programacionCollectionView);
                });

                MovistarCo.mainRegion.show(programacionListLayout);
                
                if (programacion.get('programacion').length === 0 && data.filtro !== undefined) {
                    alert("No se encontraron resultados para '" + data.filtro + "'");
                    MovistarCo.trigger('programacion:canal', {nombre: data.nombre, dia: data.dia});
                }
            });
        },
        
        showProgramaDetalle: function(data, dia) {
            var detalleLayout = new MovistarCo.Common.Views.ViewLayout();
            var detalleHeadView = new MovistarCo.Common.Views.HeadBack({titulo: 'Detalle Programa', url: 'programacion:canal', data: {dia: dia}});

            var detalelView = new Canal.Detalle({
                model: data
            });

            detalleLayout.on('show', function() {
                detalleLayout.headRegion.show(detalleHeadView);
                detalleLayout.bodyRegion.show(detalelView);
            });

            MovistarCo.mainRegion.show(detalleLayout);
        }
    };
});
                

