MovistarCo.module('ProgramacionApp.Canal', function(Canal, MovistarCo, Backbone, Marionette, $, _){
    
    Canal.ProgramacionRow = Marionette.ItemView.extend({
        template: '#programacion-canal-row',
        className: 'programacion-canal-row',
        
        events: {
            'click' : 'detalle'
        },
        
        detalle : function(){
            //console.log(this.model);
            MovistarCo.trigger('programacion:canal:detalle', this.model.get('detalle'), this.model.get('dia'));
        }
    });

    Canal.Programacion = Marionette.CompositeView.extend({
        template: '#programacion-canal-template',
        className: 'programacion-canal',
        itemView: Canal.ProgramacionRow,
        itemViewContainer: 'div.programacion-canal-body',
        
        events: {
            'click div.js-hoy' : 'hoy',
            'click div.js-manana' : 'manana',
            'click div.js-despues' : 'despues',
            'click button#js-buscar' : 'buscar'
        },
        
        hoy : function(){
            if(this.dia !== 'uno'){
                var data = {nombre: this.nombre, dia: 'uno'};
                MovistarCo.trigger('programacion:canal', data);
            }
        },
        
        manana : function(){
            if(this.dia !== 'dos'){
                var data = {nombre: this.nombre, dia: 'dos'};
                MovistarCo.trigger('programacion:canal', data);
            }
        },
        
        despues : function(){
            if(this.dia !== 'tres'){
                var data = {nombre: this.nombre, dia: 'tres'};
                MovistarCo.trigger('programacion:canal', data);
            }
        },
        
        buscar : function(event){
            event.preventDefault();
            var filtro = $('#filtro')[0].value.trim();
            var data;
            if(filtro !== ''){
                data = {nombre: this.nombre, dia: this.dia, filtro: filtro};
                
            }else{
                data = {nombre: this.nombre, dia: this.dia};
            }
            MovistarCo.trigger('programacion:canal',data);
        },
        
        initialize: function(options){
            var options = options || {};
            this.dia = options.dia;
            this.nombre = options.nombre;
            
            this.collection = this.model.get('programacion');
        },
        
        onRender: function(){
            var clas;
            if(this.dia === 'uno'){
                clas = this.el.children[1].children[0].className;
                this.el.children[1].children[0].className = clas + ' select';
            }else if(this.dia === 'dos'){
                clas = this.el.children[1].children[1].className;
                this.el.children[1].children[1].className = clas + ' select';
            }else{//tres
                clas = this.el.children[1].children[2].className;
                this.el.children[1].children[2].className = clas + ' select';
            }
        }
    });
    
    Canal.Detalle = Marionette.ItemView.extend({
        template: '#programacion-canal-detalle',
        className: 'programacion-canal-detalle'
    });
});