MovistarCo.module('ProgramacionApp.List', function(List, MovistarCo, Backbone, Marionette, $, _){
    List.Controller = {
        listProgramacion: function(orden, filtro){
            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);
      
            orden = orden === undefined ? 'numerico' : orden;

            var fetchingProgramacion = MovistarCo.request('programacion:entities', orden, filtro);
            
            var programacionListLayout = new MovistarCo.Common.Views.ViewLayout();
            var programacionHeadView = new MovistarCo.Common.Views.HeadMenu();
            
            $.when(fetchingProgramacion).done(function (programacion){
                
                var programacionCollectionView;
                if(programacion !== undefined){
                    programacionCollectionView = new List.Programacion({
                        collection: programacion,
                        orden: orden
                    });
                }else{
                    programacionCollectionView = new MovistarCo.Common.Views.Error();
                }
                
                programacionListLayout.on('show', function() {
                    programacionListLayout.headRegion.show(programacionHeadView);
                    programacionListLayout.bodyRegion.show(programacionCollectionView);
                });

                MovistarCo.mainRegion.show(programacionListLayout);
                
                if (programacion.length === 0) {
                    alert("No se encontraron resultados para '" + filtro + "'");
                    MovistarCo.trigger('programacion', orden);
                }
            });
        }
    };
});
                

