MovistarCo.module('ProgramacionApp.List', function(List, MovistarCo, Backbone, Marionette, $, _){
    
    List.ProgramacionRow = Marionette.ItemView.extend({
        template: '#programacion-row',
        className: 'programacion-row',
        
        events: {
            'click': 'detalle'
        },
        
        detalle: function(){
            var data = {id: this.model.get('id'), nombre: this.model.get('nombre'), dia: 'uno'};
            MovistarCo.trigger('programacion:canal',data);
        }
    });

    List.Programacion = Marionette.CompositeView.extend({
        template: '#programacion-template',
        className: 'programacion',
        itemView: List.ProgramacionRow,
        itemViewContainer: 'div.programacion-body',
        
        events: {
            'click div.js-alfabetico' : 'alfabetico',
            'click div.js-numerico' : 'numerico',
            'click button#js-buscar' : 'buscar'
        },
        
        alfabetico : function(){
            if(this.orden === 'numerico'){
                MovistarCo.trigger('programacion','alfabetico');
            }
        },
        
        numerico : function(){
            if(this.orden === 'alfabetico'){
                MovistarCo.trigger('programacion','numerico');
            }
        },
        
        buscar : function(event){
            event.preventDefault();
            var filtro = $('#filtro')[0].value.trim();
            if(filtro !== ''){
                MovistarCo.trigger('programacion',this.orden,filtro);
            }else{
                MovistarCo.trigger('programacion',this.orden,undefined);
            }
        },
        
        initialize: function(options){
            var options = options || {};
            this.orden = options.orden;
        },
        
        onRender: function(){
            var clas;
            if(this.orden === 'numerico'){
                clas = this.el.children[1].children[0].className;
                this.el.children[1].children[0].className = clas + ' select';
            }else{
                clas = this.el.children[1].children[1].className;
                this.el.children[1].children[1].className = clas + ' select';
            }
        }
    });
});