MovistarCo.module('TelefoniaApp.Consumos', function(List, MovistarCo, Backbone, Marionette, $, _) {
    List.Controller = {
        showConsumos: function(data) {

            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);
            
            var telefoniaConsumosLayout = new MovistarCo.Common.Views.ViewLayout();
            var telefoniaHeadView = new MovistarCo.Common.Views.HeadBack({titulo: 'Consumo y detalle', url: 'telefonia:info'});

            var fetchingConsumos = MovistarCo.request('telefonia:consumos',data);
            
            $.when(fetchingConsumos).done(function(consumos){
                
                if(consumos.error === undefined){
                    var consumosView = new List.ItemsConsumo({
                        collection: consumos
                    });

                    consumosView.on('telefonia:detalles:pospago', function(){
                        MovistarCo.trigger('telefonia:detalles:pospago', data);
                    });

                    telefoniaConsumosLayout.on('show', function() {
                        telefoniaConsumosLayout.headRegion.show(telefoniaHeadView);
                        telefoniaConsumosLayout.bodyRegion.show(consumosView);
                    });

                    MovistarCo.mainRegion.show(telefoniaConsumosLayout);
                }else{
                    alert(consumos.error);
                    MovistarCo.trigger('telefonia:info');
                }     
	   });
        }
    };
});



