MovistarCo.module('TelefoniaApp.Detalles', function(List, MovistarCo, Backbone, Marionette, $, _) {
    List.Controller = {
        showDetalles: function(data) {

            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);
            
            var telefoniaDetallesLayout = new MovistarCo.Common.Views.ViewLayout();
            var telefoniaHeadView = new MovistarCo.Common.Views.HeadBack({titulo: 'Detalle de llamadas', url: 'telefonia:info'});

            var fetchingDetalles = MovistarCo.request('telefonia:detalles:prepago',data);
            
            $.when(fetchingDetalles).done(function(detalles){
                
                if(detalles.error === undefined){
                    var detallesView = new List.ItemsDetalle({
                        collection: detalles
                    });

                    telefoniaDetallesLayout.on('show', function() {
                        telefoniaDetallesLayout.headRegion.show(telefoniaHeadView);
                        telefoniaDetallesLayout.bodyRegion.show(detallesView);
                    });

                    MovistarCo.mainRegion.show(telefoniaDetallesLayout); 
                }else{
                    alert(detalles.error);
                    MovistarCo.trigger('telefonia:info');
                }      
	   });
        },
        
        showDetallesExt: function(data){
            var telefoniaDetallesLayout = new MovistarCo.Common.Views.ViewLayout();
            var telefoniaHeadView = new MovistarCo.Common.Views.HeadBack({titulo: data.get('destino'), url: 'telefonia:detalles'});
            
            var detallesView = new List.ItemsDetalleExt({
                 collection: data.get('detalles'),
                 unidad: data.get('unidad')
            });
	
	    telefoniaDetallesLayout.on('show', function() {
                telefoniaDetallesLayout.headRegion.show(telefoniaHeadView);
                telefoniaDetallesLayout.bodyRegion.show(detallesView);
	    });
	
            MovistarCo.mainRegion.show(telefoniaDetallesLayout);
        },
        
        showDetallesPospago: function(data){
            
            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);
            
            var telefoniaDetallesLayout = new MovistarCo.Common.Views.ViewLayout();
            var telefoniaHeadView = new MovistarCo.Common.Views.HeadBack({titulo: 'Consumo y detalle', url: 'telefonia:info'});

            var fetchingDetalles = MovistarCo.request('telefonia:detalles:pospago',data);
            
            $.when(fetchingDetalles).done(function(detalles){
                
                if(detalles.error === undefined){
                    var detallesView = new List.ItemsDetallePospago({
                        collection: detalles
                    });

                    detallesView.on('telefonia:consumos', function(){
                        MovistarCo.trigger('telefonia:consumos', data);
                    });

                    telefoniaDetallesLayout.on('show', function() {
                        telefoniaDetallesLayout.headRegion.show(telefoniaHeadView);
                        telefoniaDetallesLayout.bodyRegion.show(detallesView);
                    });

                    MovistarCo.mainRegion.show(telefoniaDetallesLayout);
                }else{
                    alert(detalles.error);
                    MovistarCo.trigger('telefonia:info');
                }   
	   });
        },
        
        showDetallesPospagoExt: function(data){
            var telefoniaDetallesLayout = new MovistarCo.Common.Views.ViewLayout();
            var telefoniaHeadView = new MovistarCo.Common.Views.HeadBack({titulo: data.get('destino'), url: 'telefonia:detalles:pospago'});
            
            var detallesView = new List.ItemsDetalleExt({
                 collection: data.get('detalles'),
                 unidad: data.get('unidad')
            });
	
	    telefoniaDetallesLayout.on('show', function() {
                telefoniaDetallesLayout.headRegion.show(telefoniaHeadView);
                telefoniaDetallesLayout.bodyRegion.show(detallesView);
	    });
	
            MovistarCo.mainRegion.show(telefoniaDetallesLayout);
        }
    };
});

