MovistarCo.module('TelefoniaApp.Detalles', function(List, MovistarCo, Backbone, Marionette, $, _){

    List.DetalleChild = Marionette.ItemView.extend({
        template: '#telefonia-detalle-item-child',
        className: 'detalle-child',
        
        events: {
            'click': 'detalle'
        },
        
        detalle: function(){
            MovistarCo.trigger('telefonia:detalles:ext', this.model);
        }
    });

    List.DetalleRow = Marionette.CompositeView.extend({
        template: '#telefonia-detalle-item-row',
        className: 'detalle-row',
        itemView: List.DetalleChild,
        itemViewContainer: 'div.detalle-body',

        initialize: function(){
            this.collection = this.model.get('consumos');
        }/*,
        
        onRender: function(){
            var date = new Date();
            var fechaI = date.getDate() + '/' + ( '0' + (date.getMonth() + 1)).slice(-2) + '/' + date.getFullYear() + ' ' + date.getHours() + ':' + date.getMinutes();
            var fechaF = (date.getDate()+3) + '/' + ( '0' + (date.getMonth() + 1)).slice(-2) + '/' + date.getFullYear() + ' ' + date.getHours() + ':' + date.getMinutes();
            var message = 'Detalles desde ' + fechaI + ' hasta ' + fechaF + 
                    'Para más información ingrese a www.movistar.co';
            alert(message);
        }*/
    });

    List.ItemsDetalle = Marionette.CollectionView.extend({
        itemView: List.DetalleRow,
        className: 'telefonia-detalles'
    });
    
    /* especificacion del detalle de llamada*/
    
    List.DetalleRowExt = Marionette.ItemView.extend({
        template: '#telefonia-detalle-item-row-ext',
        className: 'detalle-row'
    });
    
    List.ItemsDetalleExt = Marionette.CollectionView.extend({
        itemView: List.DetalleRowExt,
        className: 'telefonia-detalles-ext'
    });
    
    /* detalles pospago*/
    
    List.DetalleChildPospago = Marionette.ItemView.extend({
        template: '#telefonia-detalle-item-child',
        className: 'detalle-child',
        
        events: {
            'click': 'detalle'
        },
        
        detalle: function(){
            MovistarCo.trigger('telefonia:detalles:pospago:ext', this.model);
        }
    });

    List.DetalleRowPospago = Marionette.CompositeView.extend({
        template: '#telefonia-detalle-item-row',
        className: 'detalle-row',
        itemView: List.DetalleChildPospago,
        itemViewContainer: 'div.detalle-body',

        initialize: function(){
            this.collection = this.model.get('consumos');
        }
    });
    
    List.ItemsDetallePospago = Marionette.CompositeView.extend({
        itemView: List.DetalleRowPospago,
        className: 'telefonia-detalles',
        template: '#telefonia-consumo-layout',
        itemViewContainer: 'div.body',
        
        events: {
            'click div.js-consumo': 'consumo'
        },
        
        consumo: function(event){
            event.preventDefault();
            this.trigger('telefonia:consumos');
        }
    });
});
