MovistarCo.module('TelefoniaApp.Info', function(Info, MovistarCo, Backbone, Marionette, $, _) {
    Info.Controller = {
        showInformacion: function() {

            var telefoniaInfoLayout = new MovistarCo.Common.Views.ViewLayout();
            var telefoniaHeadView = new MovistarCo.Common.Views.HeadMenu({opcion: "<div class='js-cerrar'>Cerrar</div>"});

            var informacion = MovistarCo.request('telefonia:info');

            if (informacion.get('tipo_plan').toLowerCase() === 'prepago') {
                informacion.set('visible_button','hidden');
                informacion.set('consumo_detalle','Detalle de llamadas');
            } else if (informacion.get('tipo_plan').toLowerCase() === 'postpago') {
                informacion.set('visible_button', 'visible');
                informacion.set('consumo_detalle', 'Consumo y detalle');
            } else {//cuenta control
                informacion.set('visible_button', 'visible');
                informacion.set('consumo_detalle', 'Detalle de llamadas');
            }

            if (informacion.get('tipo_cliente') === '4') {
                informacion.set('visible_saldo', 'none');
                informacion.set('visible_fecha_corte', 'inline');
                informacion.set('visible_fecha_pago',  'none');
                informacion.set('visible_pago', 'none');
            } else if (informacion.get('tipo_cliente') === '7') {
                informacion.set('visible_saldo', 'inline');
                informacion.set('visible_fecha_corte', 'none');
                informacion.set('visible_fecha_pago', 'none');
                informacion.set('visible_pago', 'none');
            } else {//6
                informacion.set('visible_saldo', 'inline');
                informacion.set('visible_fecha_corte', 'inline');
                informacion.set('visible_fecha_pago', 'inline');
                informacion.set('visible_pago', 'inline');
            }

            //console.log('informacion', informacion);

            var telefoniaView = new Info.View({
                model: informacion
            });

            telefoniaInfoLayout.on('show', function() {
                telefoniaInfoLayout.headRegion.show(telefoniaHeadView);
                telefoniaInfoLayout.bodyRegion.show(telefoniaView);
            });

            MovistarCo.mainRegion.show(telefoniaInfoLayout);
        }
    };
});

