MovistarCo.module('TelefoniaApp.Registrar', function(Show, MovistarCo, Backbone, Marionette, $, _){
    
    Show.Registrar = Marionette.ItemView.extend({
        template: '#telefonia-registrar-template',
        className: 'telefonia-registrar',
        
        events: {
            'click button#registrar': 'registrar',
            'click button#cancelar': 'cancelar'
        },
        
        registrar: function(event){
            event.preventDefault();
            var identificacion = $('#identificacion')[0].value.trim();
            var telefono = $('#telefono')[0].value.trim();
            var tipo_id = $('#tipo_identificacion')[0].value.trim();
            if(telefono === 'Número Celular'){
                alert("El campo 'Número Celular' está vacio");
            }else if(identificacion === 'Identificación'){
                alert("El campo 'Identificación' está vacio");
            }else{
                this.trigger('registrar', {telefono: telefono, identificacion: identificacion, tipo_identificacion: tipo_id});
            }
        },
        
        cancelar: function(event){
            event.preventDefault();
            MovistarCo.trigger('telefonia');
        }
    });
});


