MovistarCo.module('TelefoniaApp.Servicios', function(Servicios, MovistarCo, Backbone, Marionette, $, _) {
    Servicios.Controller = {
        showServicios: function(data) {

            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);

            var serviciosLayout = new MovistarCo.Common.Views.ViewLayout();
            var serviciosHeadView = new MovistarCo.Common.Views.HeadBack({titulo: 'Servicios Contratados', url: 'telefonia:info'});

            var fetchingServicios = MovistarCo.request('telefonia:servicios', data);
            
            $.when(fetchingServicios).done(function(servicios) {

                if (servicios.error === undefined) {
                    var serviciosCollectionView = new Servicios.ServiciosView({
                        collection: servicios
                    });

                    serviciosLayout.on('show', function() {
                        serviciosLayout.headRegion.show(serviciosHeadView);
                        serviciosLayout.bodyRegion.show(serviciosCollectionView);
                    });

                    MovistarCo.mainRegion.show(serviciosLayout);
                } else {
                    alert(servicios.error);
                    MovistarCo.trigger('telefonia:info');
                }
            });
        }
    };
});

