MovistarCo.module('TelefoniaApp.Show', function(Show, MovistarCo, Backbone, Marionette, $, _){
    
    Show.Telefonia = Marionette.ItemView.extend({
        template: '#telefonia-form-template',
        className: 'telefonia-form',
        
        events: {
            'click button': 'login',
            'click a.js-contasena': 'contrasena',
            'click a.js-registrar': 'registrar'
        },
        
        login: function(event){
            event.preventDefault();
            var telefono = $('#telefono')[0].value.trim();
            var contrasena = $('#contrasena')[0].value.trim();
            if(telefono === 'Número Celular'){
                alert("El campo 'Número Celular' está vacio");
            }else if(contrasena === 'Contraseña'){
                alert("El campo 'Contraseña' está vacio");
            }else{
                var recordar = $('#recordar')[0].checked;
                if(recordar){
                    localStorage.celular = telefono;
                }else{
                    localStorage.clear();
                }
                this.trigger('login', {telefono: telefono, contrasena: contrasena});
            } 
        },
        
        contrasena: function(event){
            event.preventDefault();
	    MovistarCo.trigger('telefonia:recordar');
        },
        
        registrar: function(event){
            event.preventDefault();
	    MovistarCo.trigger('telefonia:registrar');
        },
        
        onRender: function(){
            if(localStorage.celular !== undefined){
                this.el.children[1][0].value = localStorage.celular;
                this.el.children[1][2].checked = true;
            }
        }
    });
});


