MovistarCo.module('TelefoniaApp', function(Telefonia, MovistarCo, Backbone, Marionette, $, _){
    var API = {
        showTelefonia: function(){
            Telefonia.Show.Controller.showTelefonia();
        },
        
        showInformacion: function(){
            Telefonia.Info.Controller.showInformacion();
        },
        
        showServicios: function(data){
	    Telefonia.Servicios.Controller.showServicios(data);
        },
        
        showDetalles: function(data){
	    Telefonia.Detalles.Controller.showDetalles(data);
        },
        
        showDetallesExt: function(data){
	    Telefonia.Detalles.Controller.showDetallesExt(data);
        },
        
        showConsumos: function(data){
            Telefonia.Consumos.Controller.showConsumos(data);
        },
        
        showDetallesPospago: function(data){
            Telefonia.Detalles.Controller.showDetallesPospago(data);
        },
        
        showDetallesPospagoExt: function(data){
	    Telefonia.Detalles.Controller.showDetallesPospagoExt(data);
        },
        
        showRecordarContrasena: function(){
	    Telefonia.Recordar.Controller.showRecordarContrasena();
        },
        
        showRegistrarUsuario: function(){
	    Telefonia.Registrar.Controller.showRegistrarUsuario();
        }
    };

    MovistarCo.on('telefonia', function(){
        API.showTelefonia();
    });
    
    MovistarCo.on('telefonia:info', function(){
        API.showInformacion();
    });
    
    MovistarCo.on('telefonia:servicios', function(data){
        API.showServicios(data);
    });
    
    MovistarCo.on('telefonia:detalles', function(data){
        API.showDetalles(data);
    });
    
    MovistarCo.on('telefonia:detalles:ext', function(data){
        API.showDetallesExt(data);
    });
    
    MovistarCo.on('telefonia:consumos', function(data){
        API.showConsumos(data);
    });
    
    MovistarCo.on('telefonia:detalles:pospago', function(data){
        API.showDetallesPospago(data);
    });
    
    MovistarCo.on('telefonia:detalles:pospago:ext', function(data){
        API.showDetallesPospagoExt(data);
    });
    
    MovistarCo.on('telefonia:recordar', function(){
        API.showRecordarContrasena();
    });
    
    MovistarCo.on('telefonia:registrar', function(){
        API.showRegistrarUsuario();
    });
});


