MovistarCo.module('TerminosApp.Show', function(Show, MovistarCo, Backbone, Marionette, $, _){
    Show.Controller = {
        showTerminos: function(){
            
            var loadingView = new MovistarCo.Common.Views.Loading();
            MovistarCo.mainRegion.show(loadingView);
            
            var fetchingTerminos = MovistarCo.request('terminos:entity');
            
            var terminosShowLayout = new MovistarCo.Common.Views.ViewLayout();
            var terminosHeadView = new MovistarCo.Common.Views.HeadMenu();
            
            
            $.when(fetchingTerminos).done(function (terminos){
                
                var terminosView;
                if(terminos !== undefined){
                    terminosView = new Show.Terminos({
                        model: terminos
                    });
                }else{
                    terminosView = new MovistarCo.Common.Views.Error();
                }
 
                terminosShowLayout.on('show', function(){
                    terminosShowLayout.headRegion.show(terminosHeadView);
                    terminosShowLayout.bodyRegion.show(terminosView);
                });

                MovistarCo.mainRegion.show(terminosShowLayout);
            });
        }
    };
});
