MovistarCo.module("Common.Views", function(Views, MovistarCo, Backbone, Marionette, $, _){
  Views.Loading = Marionette.ItemView.extend({
    template: "#loading-view-template",
    className: 'loading',

    initialize: function(options){
      var options = options || {};
      this.title = options.title || "Loading Data";
      this.message = options.message || "Cargando...";
    },

    serializeData: function(){
      return {
        title: this.title,
        message: this.message
      };
    },

    onShow: function(){
      var opts = {
        lines: 10, // The number of lines to draw
        length: 7, // The length of each line
        width: 4, // The line thickness
        radius: 10, // The radius of the inner circle
        corners: 1, // Corner roundness (0..1)
        rotate: 0, // The rotation offset
        direction: 1, // 1: clockwise, -1: counterclockwise
        color: "#000", // #rgb or #rrggbb
        speed: 1, // Rounds per second
        trail: 60, // Afterglow percentage
        shadow: false, // Whether to render a shadow
        hwaccel: false, // Whether to use hardware acceleration
        className: "spinner", // The CSS class to assign to the spinner
        zIndex: 2e9, // The z-index (defaults to 2000000000)
        top: "30px", // Top position relative to parent in px
        left: "auto" // Left position relative to parent in px
      };
      $("#spinner").spin(opts);
    }
  });

  Views.HeadMenu = Marionette.ItemView.extend({
        template: '#head-template',
        className: 'head',

        initialize: function(options){
            var options = options || {};
            this.opcion = options.opcion || "";
        },

        serializeData: function(){
          return {
            opcion: this.opcion
          };
        },

        events: {
            'click button.js-menu': 'showMenu',
            'click div.js-pagos': 'pagos',
            'click div.js-cerrar': 'cerrar',
            'click span.icon-chat-blanco': 'chat'
        },

        showMenu: function(e){
            e.preventDefault();
            $('#menu').toggleClass("spmenu-open");
            $("body").toggleClass("spmenu-push-toright");
        },

        pagos: function(){
            MovistarCo.trigger('oficinas:pagos');
        },

        cerrar: function(){
            MovistarCo.trigger('telefonia');
        },

        chat: function(){
            var url = 'https://canalesalternos.movistar.co/WebAPI810/Chat/Chat_Site_Home/inicio_sitehomemovistar.jsp';
            new MozActivity({
                name:'view',
                data:
                {
                    type: 'url',
                    url: url
                }
            });
        }
    });

    Views.HeadBack = Marionette.ItemView.extend({
        template: '#head-back-template',
        className: 'head',

        initialize: function(options){
            this.titulo = options.titulo;
            this.url = options.url;
            this.data = options.data || undefined;
        },

        serializeData: function(){
            return {
                titulo: this.titulo
            };
        },

        events: {
            'click button.js-back': 'back'
        },

        back: function(){
            MovistarCo.trigger(this.url, this.data);
        }
    });

    Views.ViewLayout = Marionette.Layout.extend({
        template: '#common-layout',

        regions: {
            headRegion: '#head-region',
            bodyRegion: '#body-region'
        }
    });

    Views.Error = Marionette.ItemView.extend({
        template: '#error-template',
        className: 'error',

        initialize: function(options){
            var options = options || {};
            this.message = options.message || "Ha ocurrido un error al obtener los datos. Verifique su conexión a internet.";
        },

        serializeData: function(){
          return {
            message: this.message
          };
        }
    });
});

