MovistarCo.module('Entities', function(Entities, MovistarCo, Backbone, Marionette, $, _) {
    Entities.GetFromServer = function(url) {

        var defer = $.Deferred();
        
        var createCORSRequest = function(method, url) {
            var xhr = new XMLHttpRequest();
            if ("withCredentials" in xhr) {
                // Check if the XMLHttpRequest object has a "withCredentials" property.
                // "withCredentials" only exists on XMLHTTPRequest2 objects.
                xhr.open(method, url, true);

            } else if (typeof XDomainRequest !== "undefined") {
                // Otherwise, check if XDomainRequest.
                // XDomainRequest only exists in IE, and is IE's way of making CORS requests.
                xhr = new XDomainRequest();
                xhr.open(method, url);

            } else {
                // Otherwise, CORS is not supported by the browser.
                xhr = null;
            }
            return xhr;
        };

        var makeCORSRequest = function(url) {
            // All HTML5 Rocks properties support CORS.
            var xhr = createCORSRequest('GET', url);
            if (!xhr) {
                //alert('CORS not supported');
                alert('Por favor actualice su sistema a la versión más reciente.');
                defer.resolve(undefined);
                return;
            }

            // Response handlers.
            xhr.onload = function() {
                var text = xhr.responseText;
                var json = JSON.parse(text);
                //return json;
                defer.resolve(json);
            };

            xhr.onerror = function() {
                //alert('Woops, there was an error making the request.' + ' data ' + xhr.responseText);
                defer.resolve(undefined);
            };

            xhr.send();
        };
        
        makeCORSRequest(url);
        return defer.promise();
        //return makeCORSRequest(url);
    };
    
    Entities.getCity = function(Lat,Lng){
        
        var defer = $.Deferred();
        
        var url = 'https://maps.googleapis.com/maps/api/geocode/json?latlng='+Lat+','+Lng+'&sensor=true';
        var fetchingJson = Entities.GetFromServer(url);
        $.when(fetchingJson).done(function (json){
            var components = json.results[0].address_components;
            for(var i=0;i<components.length;i++){
                if(components[i].types[0] === 'locality'){
                    var city = components[i].long_name;
                    defer.resolve(city);
                    i=components.length;
                }
            }
        });
        return defer.promise();
    };
    
    Entities.replaceURLWithHTMLLinks = function (text) {
        var exp = /(\b(https?|ftp|file):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;]*[-A-Z0-9+&@#\/%=~_|])/ig;
        return text.replace(exp,"<a href='$1'>$1</a>"); 
    };
    
    Entities.clear = function(){
        delete Entities.destacados;
        Entities.destacados = undefined;
        delete Entities.detalle;
        Entities.detalle = undefined;
        delete Entities.ofertas;
        Entities.ofertas = undefined;
        delete Entities.detalle;
        Entities.detalle = undefined;
        
        delete Entities.ciudades;
        Entities.ciudades = undefined;
        delete Entities.pagos;
        Entities.pagos = undefined;
        delete Entities.programacion;
        Entities.programacion = undefined;
        delete Entities.canales;
        Entities.canales = undefined;
        delete Entities.programacionCanal;
        Entities.programacionCanal = undefined;
        delete Entities.programas;
        Entities.programas = undefined;
        
        delete Entities.roaming;
        Entities.roaming = undefined;
        delete Entities.preguntas;
        Entities.preguntas = undefined;
        delete Entities.terminos;
        Entities.terminos = undefined;
        
        delete Entities.servicios;
        Entities.servicios = undefined;
        
        delete Entities.detalles;
        Entities.detalles = undefined;
        delete Entities.consumos;
        Entities.consumos = undefined;
    };
});

