MovistarCo.module('Entities', function(Entities, MovistarCo, Backbone, Marionette, $, _){
    Entities.Destacado = Backbone.Model.extend();
    Entities.DestacadoCollection = Backbone.Collection.extend({
        model: Entities.Destacado
    });
    
    Entities.DetalleInfo = Backbone.Model.extend();
    Entities.DetalleInfoCollection = Backbone.Collection.extend({
        model: Entities.DetalleInfo
    });
    
    Entities.DestacadoDetalle = Backbone.Model.extend();
    
    var API = {
        getDestacados: function(){
            var defer = $.Deferred();
            if(Entities.destacados === undefined){//está comentado para que se actualice si existe nuevo contenido
                var url = "http://apps.mv.col.clubcontento.com/cms/movistar/uc/destacados/general/2048/1536";
                var fetchingDestacados = Entities.GetFromServer(url);
                $.when(fetchingDestacados).done(function(destacados){
                  if(destacados !== undefined){
                    Entities.destacados = new Entities.DestacadoCollection(destacados.novedades);
                  }
                  defer.resolve(Entities.destacados);
                });
            }else{
                defer.resolve(Entities.destacados);
            }
            return defer.promise();
        },
        
        getDestacadoDetalle: function(data){
            var defer = $.Deferred();
            var url = 'http://apps.mv.col.clubcontento.com/cms/movistar/uc/destacados/ver/' + data.id;
            var fetchingDestacadoDetalle = Entities.GetFromServer(url);
            $.when(fetchingDestacadoDetalle).done(function(detalle){
                if(detalle !== undefined){
                    detalle.textos.forEach(function(item){
                        item.descripcion = Entities.replaceURLWithHTMLLinks(item.descripcion);
                    });
                    Entities.detalle = new Entities.DestacadoDetalle({
                        titulo: data.titulo,
                        descripcion: data.descripcion,
                        imagen: data.imagen,
                        detalles: new Entities.DetalleInfoCollection(detalle.textos)
                    });
                }
                defer.resolve(Entities.detalle);
            });
            return defer.promise();
        }
    };
    
    MovistarCo.reqres.setHandler('destacados:entities', function(){
        return API.getDestacados();
    });
    
    MovistarCo.reqres.setHandler('destacados:detalle:entity', function(data){
        return API.getDestacadoDetalle(data);
    });
});

