MovistarCo.module('Entities', function(Entities, MovistarCo, Backbone, Marionette, $, _){
    Entities.MenuChild = Backbone.Model.extend({
        initialize: function(){
            var selectable = new Backbone.Picky.Selectable(this);
            _.extend(this, selectable);
        }
    });

    Entities.MenuChildCollection = Backbone.Collection.extend({
        model: Entities.MenuChild,

        initialize: function(){
            var singleSelect = new Backbone.Picky.SingleSelect(this);
            _.extend(this, singleSelect);
        }
    });

    Entities.MenuRow = Backbone.Model.extend({
        initialize: function(){
            var selectable = new Backbone.Picky.Selectable(this);
            _.extend(this, selectable);
        }
    });

    Entities.MenuRowCollection = Backbone.Collection.extend({
        model: Entities.MenuRow,

        initialize: function(){
            var singleSelect = new Backbone.Picky.SingleSelect(this);
            _.extend(this, singleSelect);
        }
    });

    var initializeItemsMenu = function(){
        Entities.itemsMenu = new Entities.MenuRowCollection([
            new Entities.MenuRow({name:'Noticias', children: new Entities.MenuChildCollection([
                {name: 'Destacados', url: 'destacados', icon: 'destacados'},
                {name: 'Oferta', url: 'ofertas', icon: 'ofertas'}
            ])}),
            new Entities.MenuRow({name: 'Mi Movistar', children: new Entities.MenuChildCollection([
                {name: 'Telefonía Móvil', url: 'telefonia', icon: 'telefonia'}
            ])}),
            new Entities.MenuRow({name: 'Servicio al Cliente', children: new Entities.MenuChildCollection([
                {name: 'Roaming', url: 'roaming', icon: 'roaming'},
                {name: 'Oficinas y puntos de pago', url: 'oficinas', icon: 'oficinas'},
                {name: 'Guía de Programación', url: 'programacion', icon: 'programacion'},
                {name: 'Youtube Movistar', url: 'youtube', icon: 'youtube'}
            ])}),
            new Entities.MenuRow({name: 'Legal', children: new Entities.MenuChildCollection([
                {name: 'Términos y Condiciones', url: 'terminos', icon: 'terminos'}])})
        ]);
    };

    var API = {
        getItemsMenu: function(){
            if(Entities.itemsMenu === undefined){
                initializeItemsMenu();
            }
            return Entities.itemsMenu;
        }
    };

    MovistarCo.reqres.setHandler('menu:entities', function(){
        return API.getItemsMenu();
    });
});
