MovistarCo.module('Entities', function(Entities, MovistarCo, Backbone, Marionette, $, _){
    Entities.Oferta = Backbone.Model.extend();
    Entities.OfertaCollection = Backbone.Collection.extend({
        model: Entities.Oferta
    });
    
    Entities.OfertaDetalle = Backbone.Model.extend();
    
    var API = {
        getOfertas: function(){
            var defer = $.Deferred();
            if(Entities.ofertas === undefined){
                var url = "http://apps.mv.col.clubcontento.com/cms/movistar/uc/noticias/general/2048/1536";
                var fetchingOfertas = Entities.GetFromServer(url);
                $.when(fetchingOfertas).done(function(ofertas){
                  if(ofertas !== undefined){
                    Entities.ofertas = new Entities.OfertaCollection(ofertas.noticias);
                  }
                  defer.resolve(Entities.ofertas);
                });
            }else{
                defer.resolve(Entities.ofertas);
            }
            return defer.promise();
        },
        
        getOfertaDetalle: function(data){
            var defer = $.Deferred();
            var url = 'http://apps.mv.col.clubcontento.com/cms/movistar/uc/noticias/ver/' + data.id;
            var fetchingOfertaDetalle = Entities.GetFromServer(url);
            $.when(fetchingOfertaDetalle).done(function(detalle){
                if(detalle !== undefined){
                    detalle.textos.forEach(function(item){
                        item.descripcion = Entities.replaceURLWithHTMLLinks(item.descripcion);
                    });
                    Entities.detalle = new Entities.OfertaDetalle({
                        titulo: data.titulo,
                        descripcion: data.descripcion,
                        imagen: data.imagen,
                        detalles: new Entities.DetalleInfoCollection(detalle.textos)
                    });
                }
                defer.resolve(Entities.detalle);
            });
            return defer.promise();
        }
    };
    
    MovistarCo.reqres.setHandler('ofertas:entities', function(){
        return API.getOfertas();
    });
    
    MovistarCo.reqres.setHandler('ofertas:detalle:entity', function(data){
        return API.getOfertaDetalle(data);
    });
});