MovistarCo.module('Entities', function(Entities, MovistarCo, Backbone, Marionette, $, _){
    
    Entities.Tienda = Backbone.Model.extend();
    Entities.TiendaCollection = Backbone.Collection.extend({
        model: Entities.Tienda
    });
    
    Entities.Pago = Backbone.Model.extend();
    Entities.PagoCollection = Backbone.Collection.extend({
        model: Entities.Pago
    });
    Entities.PagoRow = Backbone.Model.extend();
    Entities.PagoRowCollection = Backbone.Collection.extend({
        model: Entities.PagoRow
    });
    
    var API = {
        getOficinas: function(IdCiudad){
            var defer = $.Deferred();
            var url = 'http://apps.mv.col.clubcontento.com/cms/movistar/uc/puntos/ciudad/oficina/'+ IdCiudad;
            var fetchingOficinas = Entities.GetFromServer(url);
            $.when(fetchingOficinas).done(function(oficinas){
                if(oficinas !== undefined){
                    Entities.oficinas = oficinas.puntos;
                }
                defer.resolve(Entities.oficinas);
            });
            return defer.promise();
            
        },
        getCiudades: function(){
            var defer = $.Deferred();
            if(Entities.ciudades === undefined){
                var url = 'http://apps.mv.col.clubcontento.com/cms/movistar/uc/puntos/ciudades';
                var fetchingCiudades = Entities.GetFromServer(url);
                $.when(fetchingCiudades).done(function(ciudades){
                    if(ciudades !== undefined){
                        Entities.ciudades = ciudades.ciudades;
                    }
                    defer.resolve(Entities.ciudades);
                });
            }else{
                defer.resolve(Entities.ciudades);
            }
            return defer.promise();
        },
        getPuntosPago: function(){
            var defer = $.Deferred();
            if(Entities.pagos === undefined){
                var url = 'http://apps.mv.col.clubcontento.com/cms/movistar/uc/puntosrecaudos/puntos';
                var fetchingPagos = Entities.GetFromServer(url);
                $.when(fetchingPagos).done(function(pagos){
                    if(pagos !== undefined){
                        
                        Entities.pagos = new Entities.PagoRowCollection(
                                _.map(pagos.puntos_de_pago, function(item){
                                    return { name : item.tipo_punto,
                                             children: new Entities.PagoCollection(
                                                     _.map(item.puntos,function(punto){
                                                            return {name: punto.nombre_punto}; 
                                                     }))
                                           };
                                       }));
                            
                    }
                    defer.resolve(Entities.pagos);
                });
            }else{
                defer.resolve(Entities.pagos);
            }
            return defer.promise();
        }
    };

    MovistarCo.reqres.setHandler('oficinas:entities', function(IdCiudad){
        return API.getOficinas(IdCiudad);
    });
    
    MovistarCo.reqres.setHandler('ciudades:entities', function(){
        return API.getCiudades();
    });
    
     MovistarCo.reqres.setHandler('pagos:entities', function(){
        return API.getPuntosPago();
    });
});


