MovistarCo.module('Entities', function(Entities, MovistarCo, Backbone, Marionette, $, _){
    
    Entities.Canal = Backbone.Model.extend();
    Entities.Canales = Backbone.Collection.extend({
        model: Entities.Canal
    });
    
    Entities.Programa = Backbone.Model.extend();
    Entities.Programas = Backbone.Collection.extend({
        model: Entities.Programa
    });
    
    Entities.DetallePrograma = Backbone.Model.extend();
    
    var API = {
        getProgramacion: function(orden, filtro){
            var defer = $.Deferred();
            if(Entities.programacion === undefined){
                var url = 'http://descubre.movistar.co/getGuia.php?tabla=canales&tipo=json';
                var fetchingProgramacion = Entities.GetFromServer(url);
                $.when(fetchingProgramacion).done(function(programacion){
                    if(programacion !== undefined){
                        Entities.canales = _.sortBy(programacion, function(canal){
                            return canal.numero;
                        });
                        _parseProgramacion(Entities.canales, filtro);
                    }
                    defer.resolve(Entities.programacion);
                });
            }else{
                if(orden === 'alfabetico'){
                    Entities.canales = _.sortBy(Entities.canales, function(canal){
                        return canal.nombre;
                    });
                }else{
                    Entities.canales = _.sortBy(Entities.canales, function(canal){
                        return canal.numero;
                    });
                }
                _parseProgramacion(Entities.canales, filtro);
                defer.resolve(Entities.programacion);
            }
            delete Entities.programacionCanal;
            Entities.programacionCanal = undefined;
            return defer.promise();
        },
        
        getProgramacionCanal: function(data){
            var defer = $.Deferred();
            if(Entities.programacionCanal === undefined){
                var date = new Date();
                var month = ( '0' + (date.getMonth() + 1)).slice(-2);
                var year = date.getFullYear();
                var day = date.getDate();
                var url = 'http://descubre.movistar.co/getGuia.php?canalesxguia&idc='+ data.id +'&fecha=' + year + month  + day;
                var fetchingProgramacion = Entities.GetFromServer(url);
                $.when(fetchingProgramacion).done(function(programacion){
                    if(programacion !== undefined){
                        Entities.programas = programacion;
                        _parseProgramas(Entities.programas, data);
                    }
                    defer.resolve(Entities.programacionCanal);
                });
            }else{
                _parseProgramas(Entities.programas, data);
                defer.resolve(Entities.programacionCanal);
            }
            return defer.promise();
        }
    };
    
    MovistarCo.reqres.setHandler('programacion:entities', function(orden, filtro){
        return API.getProgramacion(orden, filtro);
    });
    
    MovistarCo.reqres.setHandler('programacion:canal:entities', function(data){
        return API.getProgramacionCanal(data);
    });
    
    _parseProgramacion = function(canales, filtro) {
        if(filtro !== undefined){
            canales = _.filter(canales, function(canal){
                return canal.nombre.contains(filtro) || canal.numero.contains(filtro);
            });
        }
        
        Entities.programacion = new Entities.Canales(
                _.map(canales, function(canal) {
                    return {
                        id: canal.id,
                        logo: canal.logo,
                        nombre: canal.nombre.toUpperCase(),
                        numero: canal.numero
                    };
                    
                }));
    };
    
    _parseProgramas = function(programas, data) {
        var programacion;
        if(data.dia === 'uno'){
            programacion = programas[0];
        }else if(data.dia === 'dos'){
            programacion = programas[1];
        }else{//dia 3
            programacion = programas[2];
        }
        
        if(data.filtro !== undefined){
            programacion = _.filter(programacion.dia.programacion, function(programa){
                return programa.titulo.contains(data.filtro) || programa.resumen.contains(data.filtro);
            });
        }else{
            programacion = programacion.dia.programacion;
        }
        
                
        var fechaAnio = programas[2].dia.fecha.substring(0,4);
        var fechaMes = programas[2].dia.fecha.substring(4,6);
        var fechaDia = programas[2].dia.fecha.substring(6,8);
        
        Entities.programacionCanal = new Entities.Canal({
            fecha: fechaAnio + '/' + fechaMes + '/' + fechaDia,
            programacion: new Entities.Programas(_.map(programacion, function(programa){
                return {
                    hora: programa.tiempoaire.substring(0,2) + ':' + programa.tiempoaire.substring(2,4),
                    titulo: programa.titulo,
                    dia: data.dia,
                    detalle : new Entities.DetallePrograma({
                        titulo: programa.titulo,
                        resumen: programa.resumen,
                        genero: programa.genero,
                        anio: programa.anio,
                        actores: programa.actores,
                        visible_actores: programa.actores === 'null' ? 'none' : 'inline',
                        duracion: programa.tiempoduracion.substring(0,2) + ':' + programa.tiempoduracion.substring(2,4)
                    })
                };
            }))
       });
    };
});



