MovistarCo.module('Entities', function(Entities, MovistarCo, Backbone, Marionette, $, _) {

    Entities.Telefonia = Backbone.Model.extend();

    Entities.Servicio = Backbone.Model.extend();
    Entities.Servicios = Backbone.Collection.extend({
        model: Entities.Servicio
    });
    
    Entities.ItemDetalle = Backbone.Model.extend();
    Entities.ItemDetalles = Backbone.Collection.extend({
        model: Entities.ItemDetalle
    });
    Entities.Detalle = Backbone.Model.extend();
    Entities.Detalles = Backbone.Collection.extend({
        model: Entities.Detalle
    });

    Entities.ItemConsumo = Backbone.Model.extend();
    Entities.ItemConsumos = Backbone.Collection.extend({
        model: Entities.ItemConsumo
    });
    Entities.Consumo = Backbone.Model.extend();
    Entities.Consumos = Backbone.Collection.extend({
        model: Entities.Consumo
    });

    var API = {
        getLogin: function(data) {
            //console.log('getLogin - data', data);
            var defer = $.Deferred();
            var url = 'http://apps.mv.col.clubcontento.com/soapFirefoxOS.php';
            var metodo = 'AutenticaUsuario';
            var pl = new SOAPClientParameters();
            pl.add('Login', 'wsmovistarvpn');
            pl.add('Password', 'wsmov2011vpn');
            pl.add('celular', data.telefono);
            pl.add('clave', data.contrasena);
            pl.add('ip', '190.168.1.1');
            SOAPClient.invoke(url, metodo, pl, true, function(response) {
                //console.log('response',response);
                var obj;
                var error = parseInt(response);
                if (!isNaN(error)) {
                    obj = {error: _getError(error)};
                } else {
                    obj = {success: 'OK'};
                    var data = response.split(',');
                    Entities.telefonia_info = new Entities.Telefonia({
                        num_celular: data[3],
                        num_cuenta: data[4],
                        saldo_actual: data[10],
                        fecha_corte: data[6],
                        fecha_pago: data[8],
                        valor_pago: data[7],
                        tipo_plan: data[9],
                        tipo_cliente: data[15]
                    });
                    delete Entities.servicios;
                    Entities.servicios = undefined;
                }
                defer.resolve(obj);
            });

            return defer.promise();
        },
        
        getInfo: function() {
            delete Entities.detalles;
            delete Entities.consumos;
            Entities.detalles = undefined;
            Entities.consumos = undefined;
            return Entities.telefonia_info;
        },
        
        getServicios: function(data) {
            var defer = $.Deferred();
            if (Entities.servicios === undefined || Entities.servicios.error !== undefined) {
                var url = 'http://apps.mv.col.clubcontento.com/soapFirefoxOS.php';
                var metodo = 'ConsultaServiciosContratados';
                var pl = new SOAPClientParameters();
                pl.add('Login', 'wsmovistarvpn');
                pl.add('Password', 'wsmov2011vpn');
                pl.add('celular', data.telefono);
                SOAPClient.invoke(url, metodo, pl, true, function(response) {
                    var s = response.split(',');
                    if (s.length !== 1) {
                        var x2js = new X2JS();
                        var jsonObj = x2js.xml_str2json(s[3]);
                        Entities.servicios = new Entities.Servicios(jsonObj.serviciosContratados.servicio);
                        //defer.resolve(Entities.servicios);
                    } else {
                        var error = parseInt(response);
                        Entities.servicios = {error: _getError(error)};
                    }

                    defer.resolve(Entities.servicios);
                });
            } else {
                defer.resolve(Entities.servicios);
            }

            return defer.promise();
        },
        
        getDetalleLlamadasPrepago: function(data) {
            var defer = $.Deferred();
            if (Entities.detalles === undefined || Entities.detalles.error !== undefined) {
                var url = 'http://apps.mv.col.clubcontento.com/soapFirefoxOS.php';
                var metodo = 'DetalleDeLlamadasPrepago';
                var pl = new SOAPClientParameters();
                pl.add('Login', 'wsmovistarvpn');
                pl.add('Password', 'wsmov2011vpn');
                pl.add('celular', data.telefono);
                pl.add('rango', 'CORTO');
                SOAPClient.invoke(url, metodo, pl, true, function(response) {

                    var s = response.split(',');
                    if (s.length !== 1) {
                        var x2js = new X2JS();
                        var jsonObj = x2js.xml_str2json(s[2]);
                        if (jsonObj.listadoDetalleLlamadas === "") {
                            Entities.detalles = {error: 'No hay detalle de llamadas para este usuario'};
                        } else {
                            _parseDetalles(jsonObj);
                            //console.log('json', jsonObj);
                            //console.log('obj', Entities.detalles);
                        }
                    } else {
                        var error = parseInt(response);
                        Entities.detalles = {error: _getError(error)};
                    }
                    defer.resolve(Entities.detalles);
                });
            } else {
                defer.resolve(Entities.detalles);
            }

            return defer.promise();
        },
        
        getDetalleLlamadasPospago: function(data) {
            var defer = $.Deferred();
            if (Entities.detalles === undefined || Entities.detalles.error !== undefined) {
                var url = 'http://apps.mv.col.clubcontento.com/soapFirefoxOS.php';
                var metodo = 'DetalleDeLlamadasPospago';
                var pl = new SOAPClientParameters();
                pl.add('Login', 'wsmovistarvpn');
                pl.add('Password', 'wsmov2011vpn');
                pl.add('fechafac', data.fecha_corte);
                pl.add('celular', data.telefono);
                SOAPClient.invoke(url, metodo, pl, true, function(response) {
                    var s = response.split(',');
                    if (s.length !== 1) {
                        var x2js = new X2JS();
                        var jsonObj = x2js.xml_str2json(s[0]);
                        if (jsonObj.listadoDetalleLlamadas === "") {
                            Entities.detalles = {error: 'No hay detalle de llamadas para este usuario'};
                        } else {
                            _parseDetalles(jsonObj);
                            //console.log('json', jsonObj);
                            //console.log('obj', Entities.detalles);
                        }
                    } else {
                        var error = parseInt(response);
                        Entities.detalles = {error: _getError(error)};
                    }
                    defer.resolve(Entities.detalles);
                });
            } else {
                defer.resolve(Entities.detalles);
            }

            return defer.promise();
        },
        
        getConsumosPospago: function(data) {
            var defer = $.Deferred();
            if (Entities.consumos === undefined || Entities.consumos.error !== undefined) {
                var url = 'http://apps.mv.col.clubcontento.com/soapFirefoxOS.php';
                var metodo = 'ObtenerConsumosPospago';
                var pl = new SOAPClientParameters();
                pl.add('Login', 'wsmovistarvpn');
                pl.add('Password', 'wsmov2011vpn');
                pl.add('celular', data.telefono);
                SOAPClient.invoke(url, metodo, pl, true, function(response) {

                    var s = response.split(',');
                    if (s.length !== 1) {
                        var x2js = new X2JS();
                        var jsonObj = x2js.xml_str2json(s[2]);
                        if (jsonObj.xmlDetalles === "") {
                            Entities.consumos = {error: 'No hay detalle de cosumos para este usuario'};
                        } else {
                            
                            var items = jsonObj.xmlDetalles.item.length === undefined ? [jsonObj.xmlDetalles.item] : jsonObj.xmlDetalles.item;
                            Entities.consumos = new Entities.ItemConsumos(_.map(items, function(item) {
                                var tipo = item._tipo;
                                delete item._tipo;
                                return {
                                    descripcion: tipo,
                                    consumos: new Entities.Consumos(_.map(item, function(i){
                                        var valor;
                                        if(i._unidad === 'minutos'){
                                            valor = i.__text + ' min';
                                        }else if(i._unidad === 'dinero'){
                                            valor = '$ ' + i.__text;
                                        }else if(i._unidad === 'mensajes'){
                                            valor = i.__text + ' msj';
                                        }else if(i._unidad === 'datos' || i._unidad === 'kb'){
                                            valor = i.__text + ' ' + i._unidad;
                                        }else {
                                            valor = i.__text;
                                        }
                                        return {
                                            descripcion: i._des,
                                            valor: valor
                                        };
                                    }))
                                };
                            }));
                            
                            //console.log('json', jsonObj);
                            //console.log('obj', Entities.consumos);
                        }
                    } else {
                        var error = parseInt(response);
                        Entities.consumos = {error: _getError(error)};
                    }
                    defer.resolve(Entities.consumos);
                });
            } else {
                defer.resolve(Entities.consumos);
            }

            return defer.promise();
        },
        
        getRecordarContrasena : function(data){
            var defer = $.Deferred();
            var url = 'http://apps.mv.col.clubcontento.com/soapFirefoxOS.php';
            var metodo = 'RecordarClave';
            var pl = new SOAPClientParameters();
            pl.add('Login', 'wsmovistarvpn');
            pl.add('Password', 'wsmov2011vpn');
            pl.add('celular', data.telefono);
            pl.add('identificacion', data.identificacion);
            SOAPClient.invoke(url, metodo, pl, true, function(response) { 
                if(response.contains('OK')){
                    Entities.recordar = {error: 'En breve le llegará un sms con su clave.'}
                }else{
                    var error = parseInt(response);
                    Entities.recordar = {error: _getError(error)};
                }  
                defer.resolve(Entities.recordar);
            });
            return defer.promise();
        },
        
        getRegistrarUsuario : function(data){
            var defer = $.Deferred();
            var url = 'http://apps.mv.col.clubcontento.com/soapFirefoxOS.php';
            var metodo = 'RegistrarUsuarioIndividual';
            var pl = new SOAPClientParameters();
            pl.add('Login', 'wsmovistarvpn');
            pl.add('Password', 'wsmov2011vpn');
            pl.add('celular', data.telefono);
            pl.add('identificacion', data.identificacion);
            pl.add('tipo_identificacion', data.tipo_identificacion);
            SOAPClient.invoke(url, metodo, pl, true, function(response) {   
                var error = parseInt(response);
                Entities.registrar = {error: _getError(error)};
                defer.resolve(Entities.registrar);
            });
            return defer.promise();
        }
    };

    MovistarCo.reqres.setHandler('telefonia:login', function(data) {
        return API.getLogin(data);
    });

    MovistarCo.reqres.setHandler('telefonia:info', function() {
        return API.getInfo();
    });

    MovistarCo.reqres.setHandler('telefonia:servicios', function(data) {
        return API.getServicios(data);
    });

    MovistarCo.reqres.setHandler('telefonia:detalles:prepago', function(data) {
        return API.getDetalleLlamadasPrepago(data);
    });

    MovistarCo.reqres.setHandler('telefonia:detalles:pospago', function(data) {
        return API.getDetalleLlamadasPospago(data);
    });

    MovistarCo.reqres.setHandler('telefonia:consumos', function(data) {
        return API.getConsumosPospago(data);
    });
    
    MovistarCo.reqres.setHandler('telefonia:recordar', function(data) {
        return API.getRecordarContrasena(data);
    });
    
    MovistarCo.reqres.setHandler('telefonia:registrar', function(data) {
        return API.getRegistrarUsuario(data);
    });

    _parseDetalles = function(jsonObj) {
        var items = jsonObj.listadoDetalleLlamadas.item.length === undefined ? [jsonObj.listadoDetalleLlamadas.item] : jsonObj.listadoDetalleLlamadas.item;
        Entities.detalles = new Entities.ItemDetalles(_.map(items, function(item) {
            var consumos = item.consumo.length === undefined ? [item.consumo] : item.consumo;
            return {
                descripcion: item._descripcion,
                consumos: new Entities.Consumos(_.map(consumos, function(consumo) {
                    var detalles = consumo.detalle.length === undefined ? [consumo.detalle] : consumo.detalle;
                    return {
                        destino: consumo._destino,
                        cantidad: consumo.detalle.length === undefined ? 1 : consumo.detalle.length,
                        detalles: new Entities.Detalles(_.map(detalles, function(detalle) {
                            return {
                                unidad: item._unidad,
                                fecha: detalle.fecha,
                                duracion: detalle.duracion,
                                hora: detalle.hora
                            };
                        }))
                    };
                }))
            };
        }));
    };

    _getError = function(error) {
        switch (error) {
            case -1:
                return 'Ha ocurrido un error con el servidor. Intente de nuevo más tarde. (-1)';
                break;
            case -2:
                return 'Ha ocurrido un error con el servidor intermedio. Intente de nuevo más tarde. (-2)';
                break;
            case -3:
                return 'Ha ocurrido un error al codificar la clave del cliente. (-3)';
                break;
            case -4:
                return 'Ha ocurrido un error al autenticar el cliente. (-4)';
                break;
            case -5:
                return 'Ha ocurrido un error inesperado. (-5)';
                break;
            case -6:
                return 'La información no es correcta. Verifica tus datos e ingresa nuevamente. El documento de identidad no fue enviado. (-6)';
                break;
            case -7:
                return 'En este momento no podemos atender tu solicitud, por favor intenta en unos minutos. (-7)';
                break;
            case -8:
                return 'No se encontró información para este usuario. (-8)';
                break;
            case -9:
                return 'La clave digitada está errada. (-9)';
                break;
            case -10:
                return 'Los datos ingresados no son válidos. (-10)';
                break;
            case -11:
                return 'No tienes registrada una cuenta de correo electrónico. Por favor comunícate con #600. (-11)';
                break;
            case -12:
                return 'No se pudo enviar el mail de registro al usuario. (-12)';
                break;
            case -13:
                return 'La clave de acceso debe cumplir con las siguientes normas: Debe tener como mínimo seis (6) caracteres. Debe estar compuesto de letras y números. No podrá tener repeticiones de letras como AAA o CCC. No podrá tener repeticiones de números como 111 o 333. La clave es sensible a mayúsculas y minúsculas. (-13)';
                break;
            case -14:
                return 'El documento de identidad ingresado no corresponde con el del cliente. (-14)';
                break;
            case -15:
                return 'La clave de acceso que ingreses debe cumplir con las siguientes normas: Debe tener cuatro (4) caracteres. Debe estar compuesto solo por números. (-15)';
                break;
            case -16:
                return 'La clave que ingresaste está errada. Por favor intenta nuevamente. No se pudo validar al usuario con la clave ingresada. (-16)';
                break;
            case -17:
                return 'No pudimos clasificar tus datos de tasación, intente en unos minutos. Error al recuperar la clasificación de tasación del abonado. (-17)';
                break;
            case -18:
                return 'Abonado no existe o no se encuentra activo en el sistema. (-18)';
                break;
            case -19:
                return 'Estimado usuario. Lo invitamos a utilizar nuestros canales tradicionales de Atención *611, Oficinas de servicio movistar. (-19)';
                break;
            case -20:
                return 'Estimado usuario. Lo invitamos a utilizar nuestros canales tradicionales de Atención *611, Oficinas de servicio movistar. (-20)';
                break;
            case -21:
                return 'Estimado usuario, ya te encuentras registrado. (-21)';
                break;
            case -22:
                return 'Apreciado usuario, actualmente te encuentras registrado en servicio en línea, te invitamos a recordar tu clave. (-22)';
                break;
            case -23:
                return 'No fue posible registrar el usuario en servicio en línea. (-23)';
                break;
            case -24:
                return 'No se pudieron actualizar tus datos, por favor intenta en unos minutos. (-24)';
                break;
            case -25:
                return 'Se debe solicitar el documento de identidad al cliente para poder recordar la clave. (-25)';
                break;
            case -26:
                return 'La clave fue modificada pero no pudo ser enviada al cliente por SMS. (-26)';
                break;
            case -27:
                return 'El abonado no está registrado. (-27)';
                break;
            case -28:
                return 'En este momento no podemos atender tu solicitud, por favor intenta en unos minutos. (-28)';
                break;
            case -29:
                return 'En este momento no podemos atender tu solicitud, por favor intenta en unos minutos. (-29)';
                break;
            case -30:
                return 'En este momento no podemos atender tu solicitud, por favor intenta en unos minutos. (-30)';
                break;
            case -31:
                return 'En este momento no podemos atender tu solicitud, por favor intenta en unos minutos. (-31)';
                break;
            case -32:
                return 'En este momento no podemos atender tu solicitud, por favor intenta en unos minutos. (-32)';
                break;
            case -33:
                return 'No fue posible obtener información básica del usuario. (-33)';
                break;
            case -34:
                return 'En este momento no podemos atender tu solicitud, por favor intenta en unos minutos. Excepción general al intentar obtener los consumos del cliente. (-34)';
                break;
            case -35:
                return 'No pudimos consultar los consumos generados. (-35)';
                break;
            case -36:
                return 'No pudimos consultar los consumos generados. (-36)';
                break;
            case -37:
                return 'No pudimos consultar los consumos generados. (-37)';
                break;
            case -38:
                return 'No pudimos consultar los consumos generados. (-38)';
                break;
            case -39:
                return 'No pudimos obtener algunos de tus consumos. (-39)';
                break;
            case -40:
                return 'No pudimos obtener algunos de tus consumos. (-40)';
                break;
            case -41:
                return 'El usuario no tiene consumos. (-41)';
                break;
            case -42:
                return 'En este momento no podemos atender tu solicitud, por favor intenta en unos minutos. (-42)';
                break;
            case -43:
                return 'No pudimos obtener algunos datos para mostrar tus consumos. (-43)';
                break;
            case -44:
                return 'No pudimos obtener algunos datos para mostrar tus consumos. (-44)';
                break;
            case -45:
                return 'No pudimos consultar los consumos generados. (-45)';
                break;
            case -46:
                return 'En este momento no podemos atender tu solicitud, por favor intenta en unos minutos. (-46)';
                break;
            case -47:
                return 'En este momento no podemos atender tu solicitud, por favor intenta en unos minutos. (-47)';
                break;
            case -48:
                return 'No pudimos obtener algunos datos para mostrar tus consumos. (-48)';
                break;
            case -49:
                return 'El saldo no es suficiente para poder consultar consumos. (-49)';
                break;
            case -50:
                return 'No pudimos obtener algunos datos para mostrar tus consumos. (-50)';
                break;
            case -51:
                return 'En este momento no podemos atender tu solicitud, por favor intenta en unos minutos. (-51)';
                break;
            case -52:
                return 'No pudimos consultar los servicios contratados. (-52)';
                break;
            case -53:
                return 'No pudimos consultar los servicios contratados. (-53)';
                break;
            case -54:
                return 'No pudimos consultar los servicios contratados. (-54)';
                break;
            case -55:
                return 'No pudimos consultar los servicios contratados. (-55)';
                break;
            case 300:
                return 'Ha ocurrido un error al obtener los datos. Verifique su conexión a internet';
                break;
            default:
                return error + ' - Error 502';
        }
    };
});