(function ( $ ) {
 
    $.fn.powerTouch = function( options ) {
		
        // This is the easiest way to have default options.
        var settings = $.extend({
        }, options );
		
		/*
			@General
		*/
		function getC(event){
			if(!event.pageX){
				endCoords = event.originalEvent.targetTouches[0];
				event.pageX=endCoords.pageX;
				event.pageY=endCoords.pageY;
			}
			return [event.pageX, event.pageY];
		}
		
		if(settings.load=="core"){
			/*
				@User interface
			*/
			function UI(){
				mywindow={"height": $(window).height(), "width": $(window).width() };
				if( $(".menu-bottom").length > 0 ){
					hmb=$(".menu-bottom").outerHeight();
					
					$(".tree").css({"height": mywindow.height-hmb});
				}
				$(".tree").each(function(){
					size=$(this).find("li").children().length;
					li=$(this).children("li");
					$(this).css({"width": mywindow.width*size});
					li.css({"width": mywindow.width});
					size_content=mywindow.height-li.find(".navigation").outerHeight();
					$(".ui-fixed").each(function(){
						size_content -= $(this).outerHeight();
					});
					
					li.find(".content").css({"height":size_content});
				});
			}
			UI(); 
			$(window).resize(function(){ 
				UI(); 
			}); // refresh UI
			/*
				@End User interface
			*/
			function getCoord(target){
				catOrigin={
					"width":parseInt(target.outerWidth()), 
					"height":parseInt(target.outerHeight()),
					"left":parseInt(target.offset().left),
					"top":parseInt(target.offset().top), 
					"target":target
				};
			}
			drag=false;
			animationEnd=true;
			disable=false;
			speedClick="a.button, .listView li a, .ui-el";
			tapped="a.button, .listView li a, .block-switch .switch-circle, .ui-el, .menu li a";
			
			
			menufix=false;
			$(document).on("touchstart mousedown", ".menu li a", function(event){ menufix=true;});
			$(document).on("touchend mouseup", ".menu li a", function(event){ menufix=false;});
			
			$(document).on("touchstart mousedown", tapped, function(event){
				
				
				//event.preventDefault();
				if(animationEnd==false){ return true; }
				drag=true;
				
				$(this).addClass("hover");
				//$(this).data("hover",true);
				//$(this).trigger("tap");return true;
				// coordinate iniziali
				
				getCoord($(this));
				if(menufix==true){ return false; }
				if (!(typeof longtimer === 'undefined')) {
					clearTimeout( longtimer );
				}
				longtimer=setTimeout(function(){
					if(catOrigin.target.hasClass("hover")){
					//if( catOrigin.target.data("hover")==true){
						catOrigin.target.trigger("longtap");
					}
				},400);
				
			});
			
			$(document).on("touchmove mousemove", "html", function(event){
				if(!$(event.target).parents(".scrollable").hasClass("scrollable") || slider.drag==true ) {
					event.preventDefault();
					return false;
				}
				drag=false;
			});
			
			$(document).on("touchmove mousemove", "html", function(event){
				
				if(drag==true){
					//event.preventDefault();
					getCoord(catOrigin.target);
					if(!event.pageX){
						endCoords = event.originalEvent.targetTouches[0];
						event.pageX=endCoords.pageX;
						event.pageY=endCoords.pageY;
					}
					
					if(!(
						event.pageX > catOrigin.left && event.pageX < catOrigin.left+catOrigin.width &&
						event.pageY > catOrigin.top && event.pageY < catOrigin.top+catOrigin.height
					)){
						catOrigin.target.removeClass("hover");
					}
					else {
						catOrigin.target.addClass("hover");
					}
				}
				else{
					if (!(typeof catOrigin === 'undefined')) {
						catOrigin.target.removeClass("hover");
					}
				}
				

			});

			$(document).on("touchend mouseup", "html", function(){
				if (!(typeof longtimer === 'undefined')) {
					clearTimeout( longtimer );
				}
				if(drag==true && animationEnd == true){
					drag=false;
					if(catOrigin.target.hasClass("longtap")){
						catOrigin.target.removeClass("longtap");
						catOrigin.target.removeClass("hover");
					}
					else if(catOrigin.target.hasClass("hover")){
					//if( catOrigin.target.data("hover")==true){
						catOrigin.target.removeClass("hover");
						catOrigin.target.trigger("tap");
					}	
				}
			});

			$(document).on("tap", speedClick, function(event) {
				
				list=$(this).parents("ul.ajaxList");
				ajax=list.attr("data-ajax");
				ajax_=$(this).attr("data-ajax");
				if( ajax_ ){
					ajax=ajax_;
				}
				//tree=$(this).parents("ul.tree");
				par=$(this).attr("data-post");
				if( ajax && par ){
					
					params=$(this).attr("data-post");
					target=list.attr("data-targetPanel");
					target_=$(this).attr("data-targetPanel");
					if( target_ ){
						target=target_;
					}
					$.ajax({
						type: "POST",
						url: ajax,
						data: params,
						dataType: "json",
						success: function(data){
							
							if( data.html ){
								$.each(data.html, function(i, html){
									
									$(target).find( i ).html( html );
								});
							}
						}
					});
					effect=list.attr("data-effect");
					animatePanel(target, effect, 1);
				}
				if( $(this).hasClass("back") ){ // indietro
					animatePanel($(this).parents(".panel"), last_effect, 0);
				}
				if( $(this).hasClass("menu") ){ // menu
					if( $(".framework").hasClass("slideright") ){
						$(".framework").removeClass("slideright");
					}
					else
					{
						$(".framework").addClass("slideright");
					}
				}
			});
			
			last_effect="slide";
			function animatePanel(t, effect, next){
				target=t;
				
				panel=$(target);
				panel.show();
				tree=panel.parents("ul.tree");
				if(effect=="slide" && next==0){
					panel=$(tree.data("prev"));
				}
				width=panel.width();
				c=tree.data("number");
				if(c==null){
					c=0;
				}
				add=-1;
				if(next==1){
					add=1;
				}
				
				if(effect=="popIn" || effect=="popOut" || effect=="slideUp" || effect=="slideBottom" || effect=="slideLeft"){
					
						if(effect=="popIn" || effect=="popOut"){
							p="pop";
						}
						if(effect=="slideUp" || effect=="slideBottom" || effect=="slideLeft"){
							p="slide";
						}

						ef=effect;
						animationEnd=false;
						if(next==0){ // remove
							panel.addClass(ef);
							
							panel.bind("webkitTransitionEnd", function(){
								tree.find("li.panel").removeClass("p");
								panel.removeClass(p+" animate "+ef);
								panel.unbind("webkitTransitionEnd");
								panel.hide();
								animationEnd=true;
							});
						}
						else{
							last_effect=effect; 
							
							panel.css({"z-index":(100+c)});
							tree.find("li.panel").addClass(p);
							panel.addClass(ef);panel.addClass(ef+"_");
							panel.height();
							panel.addClass("animate");
							panel.removeClass(ef);
							panel.bind("webkitTransitionEnd", function(){
								animationEnd=true;
								panel.unbind("webkitTransitionEnd");
							});
						}
				}
				else{ // slide
						last_effect="slide";
						
						move=((c+add)*width);
						
						tree.data({"effect": "slide", "number":c+add, "prev":target});
						tree.css({"-webkit-transform":"translateX(-"+move+"px)"});
						
						animationEnd=false;
						tree.bind("webkitTransitionEnd", function(e){
							animationEnd=true;
							tree.unbind("webkitTransitionEnd");
							//if(next==0){ panel.hide(); }
						});
				}
				
				
			}

			
			
			/* UI REPLACEMENT */
			function uiBuild(){
			$(".listView li a").each(function(){
				$(this).append("<span class='arrow-right'></div>");
			});
				/* Switches */
				$(".block-switch").each(function(){
					input=$(this).find("input");
					c="";
					if(!input.attr("checked")){
						c=" inactive";
					}
					$(this).find("span").html( "<div class='switch-container'><a class='switch-circle"+c+"' href='javascript:;'></a><div class='switch-flow'><div class='switch-film"+c+"'>  <div class='switch-active'></div><div class='switch-inactive'></div>   </div></div></div>");
					$(this).find(".switch-film").addClass("animate");
					$(this).find(".switch-circle").addClass("animate");
				});
				
				/* Slider */
				$(".block-slider").each(function(){
					val=$(this).attr("data-value");
					min=$(this).attr("data-min");
					max=$(this).attr("data-max");
					range=max-min;
					$(this).data("range", range);
					$(this).find("input").val( val );
					$(this).find("span").html("<div class='slider-film'><div class='slider-line'></div><div class='slider-circle scrollable'><div class='slider-label'></div></div></div>");
					
					line=$(this).find(".slider-line");
					w=line.width();
					c=$(this).find(".slider-circle");
					c.css({"left": val/range*100+"%"});
					c.find(".slider-label").html( val );
				});
				
				/* Search bar */
				$(".search-bar").each(function(){
					th=$(this);
					th.find("span").html('<i class="icon"></i>');
					cancel=th.find("input").attr("data-cancel");
					if(cancel==1){
						th.find("span").append('<a class="cancel ui-el" href="javascript:;">&times;</a>');
					}
				});
			}
			uiBuild();
			
			/* Switches */
			
			
			$(document).on("tap", ".block-switch .switch-circle", function(){
				p=$(this).parents(".switch-container");
				pp=$(this).parents(".block-switch");
				d=pp.find("input");
				if($(this).hasClass("inactive")){
					d.attr("checked", true);
					$(this).removeClass("inactive");
					p.find(".switch-film").removeClass("inactive");
				}
				else{
					d.attr("checked", false);
					$(this).addClass("inactive");
					p.find(".switch-film").addClass("inactive");
				}
			});
			
			/* Slider */
			
			slider={"drag":false, "target":false, "x":0};
			$(document).on("touchstart mousedown", ".block-slider .slider-circle", function(){
				$(this).addClass("enlarge");
				slider.drag=true;
				slider.target=$(this);
				
			});
			$(document).on("touchmove mousemove", "html", function(event){
				if( slider.drag==true ){
					sli=slider.target.parents(".block-slider");
					if(!event.pageX){
						endCoords = event.originalEvent.targetTouches[0];
						event.pageX=endCoords.pageX;
						event.pageY=endCoords.pageY;
					}
					line=slider.target.parents(".block-slider").find(".slider-line")
					l=line.offset().left;
					w=line.width();
					fx=event.pageX-l;
					//console.log( w );
					if(fx < 0){
						fx=0;
					}
					else if(fx > w){
						fx=w;
					}
					slider.x=fx;
					perc=slider.x/w;
					
					range=sli.data("range");
					min=sli.attr("data-min");
					q=Math.round(perc*range);
					slider.target.css({"left": q/range*100+"%"}); //perc*range
					slider.target.find(".slider-label").html(q+parseInt(min));
					sli.find("input").val( q );
				}
			});
			$(document).on("touchend mouseup", "html", function(){
				if( slider.drag==true ){
					slider.target.removeClass("enlarge");
					slider.drag=false;
				}
			});
			
			
			/* Search bar */
			$(document).on("tap", ".search-bar .cancel", function(){
				$(this).hide();
				input=$(this).parents(".search-bar").find("input");
				input.val("");
				input.focus();
			});
			$(document).on("keyup", ".search-bar input", function(){
				parent=cancel=$(this).parents(".search-bar");
				input=parent.find("input");
				cancel=$(this).parents(".search-bar").find(".cancel");
				if( $(this).val() == ""){
					cancel.hide();
				}
				else {
					cancel.show();
					ajax=parent.attr("data-ajax");
					extra=parent.attr("data-extra-post");
					target=parent.attr("data-target");
					$.ajax({
						type: "POST",
						url: ajax,
						data: "query="+escape(input.val())+"&"+extra,
						dataType: "json",
						success: function(data){
							if( data.html ){
								$.each(data.html, function(i, html){
									$(target).find( i ).html( html );
								});
								
							}
						}
					});
				}
			});
			current_panel=null;
			/* Menu Ajax */
			$(document).on("tap", ".menuAjax li a", function(){
				bottom=false;
				if( $(this).parents(".menu-bottom").length > 0){
					bottom=true;
				}
				el=$(this);
				ajax=el.attr("data-ajax");
				post=el.attr("data-post");
				after=el.attr("data-after");
				$.ajax({
					type: "POST",
					url: ajax,
					data: post,
					dataType: "json",
					success: function(data){
						if( data.html ){
							
							$.each(data.html, function(i, html){
								$( i ).html( html );
							});
							if( $(".framework").hasClass("slideright") ){
								$(".framework").removeClass("slideright");
							}
							if(bottom==true){
								tree=$(".tree")
								//tree.addClass("noAnimation");
								tree.css({"-webkit-transform":"translateX(0)"});
								tree.height();
								//tree.removeClass("noAnimation");
								tree.data("number", 0);
							}
							UI();
							uiBuild();
							
						}
					}
				});
			
			});
			
			$(document).on("focus", "input", function(event){	
				event.preventDefault();
				if(animationEnd==false){ return false; }
			
			});
			
			
			isTouch=false;
			if ("ontouchstart" in document.documentElement)
			{
				$(document).unbind("mousedown mouseup mousemove");
				isTouch=true;
			}
			else
			{
			}
		} // fine del core //
		
		if(settings.load=="content_slider"){
			content_slider={"target":false, "drag":false, "startX":false, "deltaX":false, "targetFilm":false, "widthFrame":false, "index":0, "num":0, "interval":false, "time":0, "animated":false, "position":false, "position_":0, "newMove":false, "options":{"mode":"default"}};
			if(settings.options){
				content_slider.options=$.extend(content_slider.options, settings.options );
			}
			console.log(content_slider.options);
			sliderObj={
				"moveSlide":function(add){
					
					el=$(content_slider.targetFilm);el.addClass("animate");el.height();
					if(content_slider.options.mode=="cube"){
					el2=$(content_slider.target).find(".allcube"); el2.addClass("animate");el2.height();
					}
					
					content_slider.index=content_slider.index+add;
					index=content_slider.index;
					dir=add;
					if(index >= content_slider.num){
						content_slider.index=content_slider.num-1;
						index=content_slider.index;
						dir=0;
					}
					else if(index < 0){
						content_slider.index=0;
						index=content_slider.index;
						dir=0;
					}
					/*if(content_slider.options.mode=="cube"){
						current=$(content_slider.target).find(".current");
						prev=current.prev();
						next=current.next();
						if(dir == 1){
							newcurrent=current.next(); newcurrent.addClass("current");
						}
						if(dir == -1){	
							newcurrent=current.prev(); newcurrent.addClass("current");
							
						}
						if(dir == 0){
						
						}
					}
					*/
					content_slider.target.trigger("changeSlide", [index]);
					content_slider.animated=true;
					if(content_slider.options.mode=="cube"){
						//console.log( index );
						move=-(90*index);
						el.css({
							"transform":"rotateY("+move+"deg)"
						});
						el2.css({
							"transform":"scale(1,1)"
						});
					}
					else{
						move=-(content_slider.widthFrame*index);
						el.css({
							"transform":"translateX("+move+"px)",
						});
					}
					evv="webkitTransitionEnd MozTransitionEnd transitionEnd transitionend";
					//evv="webkitTransitionEnd";
						$(content_slider.target).on(evv, ".film", function(event){
							console.log("end animation");
							content_slider.animated=false;
							el.removeClass("animate"); el.height();
							
							
							$(content_slider.target).off(evv, ".film");
						});
					$(document).on(evv, content_slider.target, function(event){
							el2.removeClass("animate"); el2.height();
							$(document).off(evv, content_slider.target);
						});
					
					
				},
				"setProp":function(total, delta){
					if(content_slider.options.mode=="cube"){
						prev=$(content_slider.target).find(".current").prev();
						next=$(content_slider.target).find(".current").next();
						if(content_slider.deltaX > 0){
							prev.removeClass("hide");
						}
						else {
							next.removeClass("hide");
						}
						oe=(Math.abs(delta))/content_slider.widthFrame;
						scx=1-oe*0.2;
						scy=1-oe*0.2;
						$(content_slider.targetFilm).css({
							"transform":"rotateY("+(total)+"deg)"
						});
						$(content_slider.target).find(".allcube").css({
							"transform":"scale("+scx+", "+scy+")"
						});
					}
					else{
						$(content_slider.targetFilm).css({
							"transform":"translateX("+total+"px)"
						});
					}
				},
				"matrixToArray":function(matrix) {
					return matrix.substr(7, matrix.length - 8).split(', ');
				}
			};
			if(content_slider.options.mode=="default"){
				function slideUI2d(sel){
					$(sel).each(function(){
						n=$(this).find(".frame").length;
						wm=parseInt($(this).outerWidth());
						w=wm*n;
						$(this).find(".film").css({"width":w+"px"});
						$(this).find(".frame").css({"width":wm+"px"});
					});
				}
				fdg=this.selector;
				slideUI2d(fdg);
				$(window).resize(function(){
						slideUI2d(fdg);
				});
			}
			
			if(content_slider.options.mode=="cube"){ // setup
				function slideUI3d(sel){
					$(sel).find(".cube-wrap").css({
						"perspective": ($(sel).width()*4)+"px",
						"perspective-origin":"50% "+($(sel).width()/4)+"px"
						});
					kok=$(sel).width();
					div2=(kok/2);
					
					cssprop=[ 
						{"transform":"translateZ("+div2+"px)"},
						{"transform":"rotateY(-270deg) translateX("+div2+"px)", "transform-origin": "top right"},
						{"transform": "translateZ(-"+div2+"px) rotateY(180deg)"},
						{"transform":"rotateY(270deg) translateX(-"+div2+"px)", "transform-origin": "center left"},
					];
					$(sel).each(function(){
						f=0; vis=true;
						$(this).find(".frame").each(function(){	
							if(vis==true){
								$(this).addClass("current");
							}
							$(this).css( cssprop[f] );
							if(vis==false){
								//$(this).addClass("hide");
							}
							if(f==0){ vis=false; }
							if(f==3){ f=-1;  }
							f++;
						});
						
					});
				}
				fdg=this.selector;
				
				slideUI3d(fdg);
				$(window).resize(function(){
						slideUI3d(fdg);
				});
			}
			

					
			
			$(document).on("touchstart", this.selector, function(event){
				
				cc=getC(event);
				content_slider.startX=cc[0];
				content_slider.drag=true;
				
				content_slider.target=$(this);

					content_slider.targetFilm=$(this).find(".film");
					content_slider.widthFrame=$(this).outerWidth();
					// reset
					if(content_slider.animated==true && content_slider.options.mode=="default"){
						console.log( "stop" );
						matrix = sliderObj.matrixToArray($(content_slider.targetFilm).css("transform"));
						content_slider.newMove=parseInt(matrix[4]);
						console.log( content_slider.newMove );
						content_slider.targetFilm.removeClass("animate");
						content_slider.targetFilm.height();
						$(content_slider.targetFilm).css({
							"transform":"translateX("+content_slider.newMove+"px)"
						});
					}
					// fine reset
				
				// length
				n=$(this).find(".frame").length;
				content_slider.num=n;
				content_slider.time=0;
				content_slider.interval=setInterval(function(){
					content_slider.time=content_slider.time+50;
				}, 50);
			});
			$(document).on("touchmove", document, function(event){
				if(content_slider.drag==true){
					if(content_slider.animated==true  && content_slider.options.mode=="default"){
						return false;
					}
					
					event.preventDefault();
					cc=getC(event);
					content_slider.deltaX=-content_slider.startX+cc[0];
					
					if(content_slider.options.mode=="cube"){
						sl=content_slider.index;
						move=-(90*sl);
						total=(move+content_slider.deltaX/content_slider.widthFrame*90);
					}
					else{
						move=-(content_slider.widthFrame*content_slider.index);
						if(content_slider.newMove){
							move=content_slider.newMove;
						}
						//console.log( content_slider.newMove );
						total=(move+content_slider.deltaX);
					}
					
					
					
					content_slider.position=total; // salvo ultima posizione ;)
					sliderObj.setProp(total, content_slider.deltaX);
				
				}				
			});
			
			$(document).on("touchend", document, function(event){
				
				if(content_slider.drag==true){
					// reset position (touch before animtion end)
					content_slider.newMove=false;
					
					// @calculate speed!
					clearInterval( content_slider.interval );
					speed=-content_slider.deltaX/content_slider.time;
					console.log( "speed: "+speed );
					// end @calculate speed!
					limit=-content_slider.deltaX;
					if(limit > 0){
						
						if(limit > content_slider.widthFrame/2){ // next slider
							sliderObj.moveSlide(1);
						}
						else if(speed > 1){ // speed
							sliderObj.moveSlide(1);
						}
						else{
							sliderObj.moveSlide(0);
						}
					}
					if(limit < 0){
						if(-limit > content_slider.widthFrame/2){ // next slider
							sliderObj.moveSlide(-1);
						}
						else if(-speed > 1){ // speed
							sliderObj.moveSlide(-1);
						}
						else{
							sliderObj.moveSlide(0);
						}
					}
				}
			});
		}
    };
	
}( jQuery ));
$(function(){
	$().powerTouch({"load":"core"});
});