var time = 0;
var timer_id = null;
var running = false;
var base_time = 60;

function init() {
	document.querySelector('#button-start').addEventListener('click', startButtonClicked);
	document.querySelector('#button-stop').addEventListener('click', stopButtonClicked);	
}

function updateTime() {
	time--;
	updateTimeText();
	if (time == 0) {
		playBell();
		stopTimer();
	}
}

function updateTimeText() {
	var time_label = document.querySelector('#time_label');
	time_label.innerHTML = secondsToMinutes(time);
}

function secondsToMinutes(seconds) {
    var minutes = Math.floor(seconds / 60);
    var seconds = seconds - (minutes * 60);
    if (minutes < 10) {minutes = "0"+minutes;}
    if (seconds < 10) {seconds = "0"+seconds;}
    var timey = minutes+':'+seconds;
    return timey;
}	

function startTimer() {
	// Make sure there is no other interval running 
	if (timer_id == null) {
		timer_id = window.setInterval(updateTime, 1000);
	}
}

function pauseTimer() {
	clearInterval(timer_id);
	timer_id = null;
}

function stopTimer() {
	pauseTimer();
	resetApp();
}

function getStopButton() {
	return document.querySelector('#button-stop');
}

function getStartButton() {
	return document.querySelector('#button-start');
}

function startButtonClicked(event) {
	var button = event.target;
	// Checking if the timer is currently going on
	if (timer_id == null) {
		if (!running) {
			playBell();	
		time = base_time;

		}
		running = true;
		button.innerHTML = 'Pause';
		startTimer();
		var stopButton = getStopButton();
		stopButton.disabled = false;
	} else {
		button.innerHTML = 'Start';
		pauseTimer();
	}
	updateTimeText();
}

function stopButtonClicked(event) {	
	stopTimer();
	running = false;
}

function resetApp() {
	var startButton = getStartButton();
	startButton.innerHTML = 'Start';

	var stopButton = getStopButton();
	stopButton.disabled = true;
	time = 0;
	updateTimeText();	
	time = 5;
	running = false;
}

function playBell() {
	var audio = document.querySelector('#audio-bell');
	audio.play();
}