var muControllers = angular.module('mu.controllers', []);

muControllers.controller('MainViewController',['$scope', '$location', '$interval', '$timeout', 'navigatorService', 'sessionsService', function ($scope, $location, $interval, $timeout, navigatorService, sessionsService) {

    $scope.buttons = {
        start: 'Start'
    };

    // Check for first run
    if (localStorage.getItem('not_first_run') == null ) {
        var sessions = new Array({
            id: (new Date).getTime(),
            name: 'Default',
            time: 60 * 30 * 1000,
            bells_start: true,
            bells_end: true,
            percent: (60* 5 * 1000) / (59 * 60 * 1000)
        });
        
        sessionsService.saveSessions(sessions);
        sessionsService.setCurrentSession(sessions[0].id);
        localStorage.setItem('not_first_run', true);
    }
    
    $scope.sessions = {
        savedSessions: sessionsService.getSessions(),
        currentSession:  null
    }

    if ($scope.sessions.savedSessions.length > 0) {
        $scope.sessions.currentSession = sessionsService.getCurrentSession();
        $scope.session_elapsed_time = $scope.sessions.currentSession.time;
    }


    $scope.level = 0;
    $scope.sections = {
        show_sidebar: false,
        sidebar: false
    }
    $scope.sidebary='';

    $scope.currentTimer = null;

    $scope.session_is_running = false;
    $scope.session_is_paused = false;

    $scope.editSessions = function () {
        navigatorService.previousLevel = $scope.level;
        navigatorService.currentLevel = $scope.level + 1;
                
        navigatorService.back = false;
        $location.path('/sessions/add');
        $scope.direction.name = 'right';
    };

    $scope.toggleSidebar = function($event) {
        $scope.sections.show_sidebar = !$scope.sections.show_sidebar;
        if ($scope.sidebary == '') {
            $scope.sidebary = 'sidebary';    
        } else {
            $scope.sidebary = '';
        }

        if ($event !== undefined) {
            $event.preventDefault();
        }
    }

    $scope.selectCurrentSession = function ($event,session_id) {
        sessionsService.setCurrentSession(session_id);
        $scope.sessions.currentSession = sessionsService.getCurrentSession();
        $scope.session_elapsed_time = $scope.sessions.currentSession.time;

        $scope.toggleSidebar();
        $event.preventDefault();
    }

    $scope.startSession = function() {
        $scope.session_is_running = true;
        if ($scope.sessions.currentSession.bells_start) {
            $scope.playBell();
        }
        $scope.startTimer();
    }


    $scope.startButtonClicked = function () {
        if (!$scope.session_is_running) {
            $scope.startSession();
            $scope.buttons.start = 'Pause';
        } else {
            if ($scope.session_is_paused) {
                $scope.resumeSession();
                $scope.buttons.start = 'Pause';
            } else {
                $scope.pauseSession();
                $scope.buttons.start = 'Resume';
            }
        }
    }

    $scope.pauseSession = function () {
        $scope.session_is_paused = true;
        $scope.stopTimer();
    }

    $scope.resumeSession = function () {
        $scope.session_is_paused = false;
        $scope.startTimer();
    }

    $scope.startTimer = function() {
        $scope.currentTimer = $interval(
            function () {
                $scope.updateElapsedTime();
            },
            1000
        );
    }

    $scope.stopClicked = function() {
        $scope.resetTimer();
    }

    $scope.stopTimer = function () {
        $interval.cancel($scope.currentTimer);        
    }

    $scope.resetTimer = function () {
        $scope.stopTimer();
        $scope.session_is_running = false;
        $scope.session_is_paused = false;
        $scope.session_elapsed_time = $scope.sessions.currentSession.time;
        $scope.buttons.start = 'Start';
    }

    $scope.playBell = function () {
        var mySound = new Audio();
        mySound.src = "/audio/bell.wav";
        mySound.preload = 'auto';
        mySound.mozAudioChannelType = 'content';
        mySound.play();
    }

    $scope.updateElapsedTime = function() {
        if ($scope.session_elapsed_time == 0) {
            if ( $scope.sessions.currentSession.bells_end) {
                $scope.playBell();                
            }

            $scope.resetTimer();
        
        } else {
            $scope.session_elapsed_time -= 1000;
        }
    }

}]);

muControllers.controller('SessionTimeController',function($scope){
    $scope.clicked = function() {
        $scope.setSelectedSessionTime($scope.sessionTime.time);
    }
});

muControllers.controller('AddSessionController', ['$scope', '$routeParams', '$location', 'navigatorService', 'sessionsService',
    function($scope, $routeParams, $location, navigatorService, sessionsService) {
        $scope.level = 1;

        $scope.edit = false;

        $scope.forms = {
            duration: false,
            sessions_select: false
        };


        $scope.temp = {
            temp_sessions: []
        }
        $scope.sess = sessionsService.getSessions();
        $scope.session = {
            current: $scope.sess[0]
        };

        // Session times
        $scope.sessionTimes = [];
        for (i = 5; i <= 60; i += 5)  {
            $scope.sessionTimes.push(
                {time: i}
            );
        }

        $scope.bellsText = function (value) {
            text = value ? 'yes' : 'no';
            return text;
        };

        $scope.selectSession = function(session) {
            $scope.session.current = session;
            $scope.forms.session_select = false;
        }

        $scope.setSelectedSessionTime = function(minutes) {
            $scope.session.current.time = minutes * 60 * 1000;
            $scope.forms.duration = false;
            sessionsService.saveSessions($scope.sess);
        };

        $scope.toggleStartBell = function() {
            $scope.session.current.bells_start = !$scope.session.current.bells_start
            sessionsService.saveSessions($scope.sess);  
        }

        $scope.toggleEndBell = function() {
            $scope.session.current.bells_end = !$scope.session.current.bells_end
            sessionsService.saveSessions($scope.sess);
        }

        $scope.sessionNameChanged = function() {
            sessionsService.saveSessions($scope.sess);
        }

        $scope.goBack = function () {
            navigatorService.previousLevel = $scope.level;
            navigatorService.currentLevel = $scope.level - 1;
            $scope.direction.name = 'left';
            $location.path('/');
        }

        $scope.editar = function () {
            temp_sessions = sessionsService.getSessions();
            $scope.temp.temp_sessions = temp_sessions.slice(0);
            $scope.edit = true;
        }

        $scope.addSession = function () {
            $scope.sess.unshift({
                id: (new Date).getTime(),
                name: null,
                time: 60* 5 * 1000,
                bells_start: true,
                bells_end: true,
                percent: (60* 5 * 1000) / (59 * 60 * 1000)
            })
            $scope.session.current = $scope.sess[0];
        }
        
        $scope.deleteSe = function() {
            var index = $scope.sess.indexOf($scope.session.current);
            $scope.sess.splice(index, 1);
            $scope.session.current = $scope.sess[0];
            sessionsService.saveSessions($scope.sess);
        }

        $scope.saveEditSessions = function () {
            sessionsService.saveSessions($scope.temp.temp_sessions);
            $scope.edit = false;
            $scope.sess = sessionsService.getSessions();
        }

        $scope.cancelEditSessions = function () {
            $scope.edit = false;
        }

        $scope.deleteSession = function (session_id) {
            for (var i = 0;i < $scope.temp.temp_sessions.length; i++) {
                var session = $scope.temp.temp_sessions[i];
                if (session.id = session_id) {
                    $scope.temp.temp_sessions.splice(i, 1);
                    break;
                }
            }
        }


        $scope.button_style = function(session, $index){
            progressBar = angular.element('.section_' + $index).find('progress');
            button_position = progressBar.width() * session.percent;
            var object = {
                left: (button_position + 20)+'px'
            }
            return object;
        }


        $scope.mouseMovido = function($event, session) {
            if ( $event.type == 'drag' || $event.type =='touch') {
                var progressBar = angular.element($event.explicitOriginalTarget).parent().find('progress');
                var mouseRelativePosition = $event.gesture.touches[0].pageX - progressBar.offset().left;    
                if (mouseRelativePosition < 0) {
                    mouseRelativePosition =  0;
                }

                var percent = mouseRelativePosition / progressBar.width();
                if (percent > 1) {
                    percent = 1;
                }

                session.button_position = (progressBar.width() * percent);
                session.percent = percent;

                session.time =  Math.floor( Math.floor( (59  * percent ) * 60000 ) / 60000 ) * 60000;
            }
        }

    }]);


muControllers.controller('NavigationCtrl', ['$scope','navigatorService', '$rootScope',
    function($scope, navigatorService, $rootScope) {
        $scope.direction = { name: ''};
    }]);