var lock = window.navigator.requestWakeLock('cpu');

var mu = angular.module('mu', [
'ngRoute',
'ngAnimate',
'angular-gestures',
'mu.controllers',
'mu.services'
]).config(['$compileProvider', function($compileProvider) {
        $compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|ftp|mailto|app):/);
    }
]);
mu.value('navigatorService',{
    previousLevel: null,
    currentLevel: 0,
    back: false
});

angular.module('mu.services',[])
    .factory('sessionsService', function() {
        return {
            getSessions: function() {
                sessions = localStorage.getItem('sessions');
                if (sessions == null) {
                    sessions = [];
                    console.log('empty sessions');
                    return sessions;
                }

                sessions = angular.fromJson(sessions);

                return sessions;
            },
            saveSessions: function(sessions_to_save) {
                if (sessions_to_save.length == 1) {
                    localStorage.setItem('current_session_id',  sessions_to_save[0].id);
                }
                localStorage.setItem('sessions', angular.toJson(sessions_to_save));
            },
            getCurrentSession: function() {
                sessions = localStorage.getItem('sessions');
                if (sessions == null || sessions.length == 0) {
                    return null;
                }
                sessions = angular.fromJson(sessions);
                current_session_id = localStorage.getItem('current_session_id');

                if (current_session_id != null) {
                    for (var i = 0; i < sessions.length; i++) {
                        var temp_session = sessions[i];
                        if (temp_session.id == current_session_id) {
                            return angular.copy(temp_session);
                        }
                    }
                }
            },
            setCurrentSession: function(id) {                
                localStorage.setItem('current_session_id', id);            
            }
        }


    });

mu.config(['$routeProvider',
    function($routeProvider) {
        $routeProvider.
        when('/main', {
            templateUrl: 'partials/main.html',
            controller: 'MainViewController'
        }).
        when('/sessions/add', {
            templateUrl: 'partials/add_session.html',
            controller: 'AddSessionController'
        }).
        otherwise({
            redirectTo: '/main'
        });
    }]);