﻿function Reaction(numberOfPlayers, pointsForVictory, windowHeight, windowWidth) {
    // TODO Auto-generated constructor stub
    this._numberOfPlayers = numberOfPlayers;
    this._pointsForVictory = pointsForVictory;
    Reaction.__windowHeight = windowHeight;
    Reaction.__windowWidth = windowWidth;
    Reaction.__windowHeightProp = Reaction.__windowHeight / Reaction.__height;
    Reaction.__windowWidthProp = Reaction.__windowWidth / Reaction.__width;
    Reaction.__windowMargin = Reaction.__margin*Reaction.__windowHeightProp;
    
    //Font-size: Minimum of height and width
    tmp = Reaction.__windowWidth / Reaction.__width;
    tmp2 = Reaction.__windowHeight / Reaction.__height;
    if (tmp > tmp2) {
        Reaction.__fontProp = tmp2;
    } else {
        Reaction.__fontProp = tmp;
    }
}

Reaction.prototype.Initialize = function() {
    this._bufferCanvas = $("#bufferCanvas")[0].getContext('2d');
    this._bufferCanvas.font = "Verdana";
    this._bufferCanvasField = $("#bufferCanvasField")[0].getContext('2d');
    this._bufferCanvasField.font = "Verdana";
    
	this._nextTaskTimeout = null;
	
    this._gameQueue = new Array();
    
    this._gameHadBeenIntroduced = new Array(this.__numberOfGames);
    for (var i=0;i<this.__numberOfGames;i++) {
        this._gameHadBeenIntroduced[i] = false;
    }
    
    //Eventlistener eintragen
    var t = this;
    
	//Neuer Canvas, um kein Problem mit Eventlistenern zu haben
	var old_element = document.getElementById("canvas");
	var new_element = old_element.cloneNode(true);
	old_element.parentNode.replaceChild(new_element, old_element);
	
    //Unterscheidung, ob Touch oder nicht
    //http://stackoverflow.com/questions/9294698/touch-screen-detection-chrome-17
    if ('ontouchstart' in window) {
        $("#canvas")[0].addEventListener("touchstart", function(e){
            //alert("Touch event!");
            t.OnTouchPressed(e.touches[0]);
        }, false)
        Bada.AppLog("touch enabled");
    } else {
    
        //Eventlistener fuer Maus, falls kein Touch vorhanden
        $("#canvas").unbind("mousedown");   
        $("#canvas").mousedown(function(e) {
            t.OnTouchPressed(e);
        })
        Bada.AppLog("touch disabled");
    }
    
    this.Startup();
    

    //this._countdown = new ReactionCountdownTimer(this, this._bufferCanvas, 15);
    //this._countdown.Run();
}

Reaction.__margin=230;
Reaction.__countdownSize=20;
Reaction.__innerMargin=10;
Reaction.__width = 480;
Reaction.__height = 800;
Reaction.__heightCanvasField = 280;
Reaction.__numberOfGames = 13;

Reaction.__windowHeight = 800;
Reaction.__windowWidth = 480;
Reaction.__windowHeightProp = 1;
Reaction.__windowWidthProp = 1;
Reaction.__windowMargin = 1;
Reaction.__fontProp = 1;

Reaction.prototype.Startup = function() {
    this._playerPoints = new Array(this._numberOfPlayers);
    for (var i=0;i<this._numberOfPlayers;i++) {
        this._playerPoints[i]=0;
    }

    Bada.Clear(this._bufferCanvas,"black");
    Bada.Clear(this._bufferCanvasField,"black");


    var zz = Bada.Rand() % Reaction.__numberOfGames;
	
	//For Demonstration
	/*this._gameQueue.push(0);
	this._gameQueue.push(0);
	this._gameQueue.push(0);
	this._gameQueue.push(1);
	this._gameQueue.push(1);
	this._gameQueue.push(2);
	this._gameQueue.push(2);
	this._gameQueue.push(4);
	this._gameQueue.push(4);
	this._gameQueue.push(5);
	this._gameQueue.push(5);
    this._gameQueue.push(9);
	this._gameQueue.push(9);
	this._gameQueue.push(6);
	this._gameQueue.push(6);
	this._gameQueue.push(7);
	this._gameQueue.push(7);


	this._gameQueue.push(10);
	this._gameQueue.push(10);
	this._gameQueue.push(8);
	this._gameQueue.push(8);
		this._gameQueue.push(12);
	this._gameQueue.push(12);
	this._gameQueue.push(11);
	this._gameQueue.push(11);*/
	
    for (var i = 0; i < this.__numberOfGames; i++) {
        this._gameHadBeenIntroduced[i] = false;
    }
	
	
    var factorForLast = 0;
    for (var i=0;i<40;i++) {
        //mit hÃ¶herer Wahrscheinlichkeit das letzte Spiel bestehen lassen
        if (Bada.Rand() % 100 > factorForLast) {
            zz = Bada.Rand() % Reaction.__numberOfGames;
            factorForLast = 75;
        }
        else {
            //Wahrscheinlichkeit fuer spaeter runtersetzen
            factorForLast = factorForLast - 20;
        }
        
        this._gameQueue.push(zz);
    }
    //this.DrawPlayerField();
    //this.DrawPlayerInfo();

        
        
    //var test = new ReactionGameEquations(this._bufferCanvas, this._bufferCanvasField);
    //test.NextChallenge();
    //this.DrawPlayerString(test.GetPlayerString());
        
    //this.RotateForUpperPlayers();
        
    this.NextTask();
}


Reaction.prototype.TimerEnded = function() {
    Bada.AppLog("timer ended");
    this.NextTask();
}



Reaction.prototype.OnTouchPressed = function(e) {
    this.StopTimer();
    //TouchInfo* pTouchTmp = static_cast<TouchInfo*>(pList.GetAt(i));
    var y;
    var x;
    
    //von http://dev.opera.com/articles/view/html5-canvas-painting/
    if (e.layerX || e.layerX == 0) { // Firefox
        x = e.layerX;
        y = e.layerY;
    } else if (e.offsetX || e.offsetX == 0) { // Opera
        x = e.offsetX;
        y = e.offsetY;
    } else if (e.pageX || e.pageY == 0) {
        x = e.pageX - $("#canvas").offset().left;
        y = e.pageY - $("#canvas").offset().top;
    }
    
    Bada.AppLog(e + "x: " + x + "; y:" + y);

    //Todo: mehr als 2 Spieler
    if (y <= Reaction.__windowMargin) {
        //Spieler 2 oder 4
        if (this._numberOfPlayers < 4 || x > (Reaction.__windowWidth/2)) {
            this.PlayerPressed(1);
        } else {
            this.PlayerPressed(3);
        }


    } else if (y >= (Reaction.__windowHeight-Reaction.__windowMargin)){
        //Spieler 1 oder 3
        if (this._numberOfPlayers < 3 || x < (Reaction.__windowWidth/2)) {
            this.PlayerPressed(0);
        } else {
            this.PlayerPressed(2);
        }


    } else {
        //TODO: Pause-Screen implimentiern
        this.Pause();
    }
	



}

Reaction.prototype.PlayerPressed = function(player) {
    if (this._playerPressed) {
        return;
    }


    this.DrawPlayerField(); //Grundieren


    this._playerPressed=true;
    this.StopTimer();
    Bada.AppLog("Player " + player+1 + " pressed");
    if (this._currentGameThread.IsTrue()) {
        Bada.AppLog("Richtig!");
        this._playerPoints[player]++;
        this.DrawPlayerField("rgb(0,144,58)",player);
    } else {
        Bada.AppLog("Falsch!");
        this._playerPoints[player]--;
        if (this._playerPoints[player] < 0) {
            this._playerPoints[player] = 0;
        }
        this.DrawPlayerField("rgb(165,0,0)",player);
    }
    this.DrawPlayerInfo();
    this.RotateForUpperPlayers();
	
    this.RequestRedraw();


    var t = this;
    this._nextTaskTimeout = window.setTimeout(function() {
        t.NextTask()
    }, 1000);


}

Reaction.prototype.Pause = function() {
    Bada.AppLog("pause");


    this.StopTimer();

    this._isPaused = true;
    

    if  (typeof Windows === "undefined") {
        var modalResult = confirm(Lang.GetString("ReturnToTheMainMenu"));
        if (modalResult) {
			window.location.hash = "#modal";
            Bada.SwitchToEntryForm();
            return;
        } else {
            //Spiel wieder fortsetzen
            this._isPaused = false;
			window.location.hash = "#game";
            this.NextTask();

        }
    } else {
        
        var md = new Windows.UI.Popups.MessageDialog(Lang.GetString("ReturnToTheMainMenu"));
    
        md.commands.append(new Windows.UI.Popups.UICommand("Yes"));
        md.commands.append(new Windows.UI.Popups.UICommand("No"));
        t = this;
        md.showAsync().then(function (e) {
            if (e.label == "Yes") {
                Bada.SwitchToEntryForm();
                return;
            }else {
                //Spiel wieder fortsetzen
                t._isPaused = false;
                t.NextTask();

            }
        });


    }
    
    




}

Reaction.prototype.NextTask = function() {
	//Sicherheitshalber Timeouts entfernen
	if (this._nextTaskTimeout !== null) {
		window.clearTimeout(this._nextTaskTimeout);
		this._nextTaskTimeout = null;
	}

    //Wenn der Spieler pausiert hat -> nichts tun,
    //die Pause-Methode wirft den Thread dann schon wieder an :)

    //Damit nicht wÃ¤hrend des Ladens gedrÃ¼ckt werden kann
    this._playerPressed = true;

    if (this._isPaused) {
        return;
    }

    if (this._currentGameThread != null) {
        Bada.AppLog("Stop all the threads!");
        this.StopTimer();
        if (this._currentGameThread.OnStop != undefined) {
            this._currentGameThread.OnStop();
        }




        this._currentGameThread = null;
        Bada.AppLog("null");

    }

    //if the app is changed -> pause
    if (document.hidden === true) {
        this.Pause();
        return;
    }



    Bada.AppLog("restart");

    this._currentGameThread = null;
    Bada.Clear(this._bufferCanvas, "black");
    //this._bufferCanvas.Clear();
    //this._bufferCanvasField.SetBackgroundColor(Color::COLORthis._BLACK);
    Bada.Clear(this._bufferCanvasField,"black");


    //Checken, ob das Spiel vllt. schon vorÃ¼ber ist
    if (this.CheckForVictory()) {
        this.GameOver();
        return;
    }

    //@TODO: Sinnvollerer, merkender Zufallsalgorithmus
    var zz = Bada.Rand() % Reaction.__numberOfGames;
    //zz = 4;
    if (this._gameQueue.length >= 1) {
        zz = this._gameQueue[0];
        this._gameQueue.shift();
    }
    //zz=12;
    switch (zz) {
        case 0:
            this._currentGameThread = new ReactionGameFlags(this._bufferCanvas,this._bufferCanvasField);
            break;
        case 1:
            Bada.AppLog("angelegt");
            this._currentGameThread = new ReactionGameEquations(this._bufferCanvas,this._bufferCanvasField);
            break;
        case 2:
            this._currentGameThread = new ReactionGameColorsMatch(this._bufferCanvas,this._bufferCanvasField);
            break;
        case 3:
            //Labyrinthe
            this._currentGameThread = new ReactionGameImages(this._bufferCanvas,this._bufferCanvasField,0);
            break;
        case 4:
            this._currentGameThread = new ReactionGameCircles(this._bufferCanvas,this._bufferCanvasField);
            break;
        case 5:
            this._currentGameThread = new ReactionGameDice(this._bufferCanvas,this._bufferCanvasField);
            break;
        case 6:
            this._currentGameThread = new ReactionGameCards(this._bufferCanvas,this._bufferCanvasField);
            break;
        case 7:
            this._currentGameThread = new ReactionGameCountdown(this._bufferCanvas,this._bufferCanvasField);
            break;
        case 8:
            //Alphabetische Sortierung
            this._currentGameThread = new ReactionGameStrings(this._bufferCanvas,this._bufferCanvasField,1);
            break;
        case 9:
            //Anagramme
            this._currentGameThread = new ReactionGameStrings(this._bufferCanvas,this._bufferCanvasField,2);
            break;
        case 10:
            //Tic Tac Toe
            this._currentGameThread = new ReactionGameImages(this._bufferCanvas,this._bufferCanvasField,1);
            break;
        case 11:
            this._currentGameThread = new ReactionGameRotatedImages(this._bufferCanvas,this._bufferCanvasField);
            break;
        case 12:
            this._currentGameThread = new ReactionGameMatch3(this._bufferCanvas,this._bufferCanvasField);
            break;
        case 13:
            //Zahlen . ausgelassen, bis mir was besseres einfÃ¤llt :)
            this._currentGameThread = new ReactionGameStrings(this._bufferCanvas,this._bufferCanvasField,0);
            break;
    }

    //this._currentGame = new ReactionGameEquations(this._bufferCanvas,this._bufferCanvasField);
    //this._currentGame = new ReactionGameColorsMatch(this._bufferCanvas,this._bufferCanvasField);

    //
    //this._currentGameThread = new ReactionGameFlags(this._bufferCanvas,this._bufferCanvasField);

        
    Bada.Clear(this._bufferCanvas, "black");
    Bada.Clear(this._bufferCanvasField, "black");
        
    //this._currentGameThread.Construct(*this._currentGame);

    //Spieler-Text ausgeben
    this.DrawPlayerField();
    this.DrawPlayerString(this._currentGameThread.GetPlayerString());
    this.DrawPlayerInfo();
    this.RotateForUpperPlayers();

    // TODO Wenn zum ersten Mal gespielt wird . helfen
    var sleepFor = 1;
    if (!this._gameHadBeenIntroduced[zz]) {
        this._gameHadBeenIntroduced[zz] = true;
        //this.Draw();
        //this.Show();
        this.RequestRedraw();
        //Thread::Sleep(1500);
        sleepFor = 1500;
    }

    var t = this;
    this._nextTaskTimeout = window.setTimeout(function() {
        t._currentGameThread.NextChallenge();

        if (t._currentGameThread.OnStart != undefined) {
            t._currentGameThread.OnStart();
        }

        Bada.AppLog("next challenge correct");

        t._countdown = new ReactionCountdownTimer(t,t._bufferCanvas,3*t._currentGameThread.Time());
	

        Bada.AppLog("timer: correct");


        //erst starten, wenn alles fertig
        //Countdown Ã¼bernimmt dann auch das RequestRedraw(true);
        t._playerPressed=false;
        //var t = this;
    
        //Absichtlich verzögern, damit für den Spiel-Thread Zeit zum erzeugen bleibt
        //window.setTimeout(function() {
        //    t._countdown.Run();
        //},100);
        t._countdown.Run();
        Bada.AppLog("Countdown started");
    }, sleepFor)

    

    //this.RequestRedraw(true);

}

Reaction.prototype.CheckForVictory = function() {
    Bada.AppLog("checkForVictory");
    var victory = false;
    for (var i=0;i<this._numberOfPlayers;i++) {
        //AppLog("%i: %i",i,_playerPoints[i]);
        if (this._playerPoints[i] >= this._pointsForVictory) {
            victory = true;
        }
    }
    return victory;
}


Reaction.prototype.StopTimer = function() {
    Bada.AppLog("Try stopping the timer");
    if (this._countdown != null) {	
        this._countdown.OnStop();
        this._countdown = null;

    }
    if (this._currentGameThread != null && this._currentGameThread.OnStop != undefined) {
        this._currentGameThread.OnStop();
    }
    Bada.AppLog("Timer stopped");
}


Reaction.prototype.GameOver = function() {
    Bada.AppLog("Game Over");
    
    this.StopTimer();

    //Spiel ist zu Ende . Gewinner informieren, neu starten
    var winningplayer = -1;
    for (var i=0;i<this._numberOfPlayers;i++) {
        this.DrawPlayerField("rgb(165,0,0)",i);
        if (this._playerPoints[i] >= this._pointsForVictory) {
            winningplayer = i;
            this.DrawPlayerField("rgb(0,144,58)",i);
        }
    }

    this.DrawPlayerInfo();
    this.RotateForUpperPlayers();

    Bada.AppLog("Game Over:1");

    var message = Lang.GetString("PlayerWins");
    Bada.AppLog("m: " + message);
    var repl = "";
    repl += ((winningplayer+1));
    message = message.replace("%1",repl);

    /*EnrichedText* etext = new EnrichedText();
	TextElement* text = new TextElement();
	etext.Construct(Dimension(Reaction.__width,__heightCanvasField/2));
	etext.SetHorizontalAlignment(TEXT_ALIGNMENT_CENTER);
	etext.SetVerticalAlignment(TEXT_ALIGNMENT_MIDDLE);
	etext.SetTextWrapStyle(TEXT_WRAP_WORD_WRAP);
	etext.SetTextAbbreviationEnabled(true);

	text.Construct(message);
	text.SetTextColor(Color.COLOR_WHITE);
	Font font;
	font.Construct(FONT_STYLE_BOLD, 40);
	text.SetFont(font);
	etext.Add(*text);

	this._bufferCanvasField.DrawText(Point(0,Reaction.__heightCanvasField/2),*etext);*/
    Bada.AppLog("m: " + message);
    this._bufferCanvasField.fillStyle = "white";
    this._bufferCanvasField.font = "40px sans-serif";
    Bada.SetTextCentered(this._bufferCanvasField, message, 0, Reaction.__heightCanvasField/2, Reaction.__width, Reaction.__heightCanvasField/2);

        

    ReactionGame.RotateForPlayer2(this._bufferCanvasField);

    Bada.AppLog("Game Over:2");

    this.RequestRedraw();

    var t = this;
    window.setTimeout(function() {
        Bada.AppLog("Game Over:3");

        // MessageBox messageBox;
        //messageBox.Construct(Lang.GetString("GameOver"), Lang.GetString("NewGame"), MSGBOX_STYLE_YESNO);
        if  (typeof Windows === "undefined") {
            var modalResult = confirm(Lang.GetString("NewGame"));
       
            Bada.AppLog("Game Over:4");

            if (modalResult) {


                //Spiel wieder starten
                t.Startup();
                //t.NextTask();

            } else {
                Bada.SwitchToEntryForm();
            }
        } else {
        
            var md = new Windows.UI.Popups.MessageDialog(Lang.GetString("NewGame"));
    
            md.commands.append(new Windows.UI.Popups.UICommand("Yes"));
            md.commands.append(new Windows.UI.Popups.UICommand("No"));
            //t = this;
            md.showAsync().then(function (e) {
                if (e.label == "Yes") {
                    t.Startup();
                    //t.NextTask();
                } else {
                    Bada.SwitchToEntryForm();
                }
            });
        }
   
        // Calls ShowAndWait - draw, show itself and process events
        
        //messageBox.ShowAndWait(modalResult);

    },1500);
    //Thread.Sleep(1500);





}

Reaction.prototype.RequestRedraw = function() {
    
    //this._bufferCanvas.drawImage(this._bufferCanvasField.canvas,0,(Reaction.__margin+Reaction.__innerMargin+Reaction.__countdownSize)*Reaction.__windowHeightProp,Reaction.__windowWidth,Reaction.__heightCanvasField*Reaction.__windowHeightProp);
    //Neue Methode, um Seitenverhältnis beizubehalten
    prop = Math.min(Reaction.__windowWidthProp,Reaction.__windowHeightProp);
    //alert(prop);
    
    width = Reaction.__width*prop;
    height = Reaction.__heightCanvasField*prop;
    
    
    x = Reaction.__windowWidth/2;
    y = Reaction.__windowHeight/2;
    
    this._bufferCanvas.drawImage(this._bufferCanvasField.canvas,x-width/2,y-height/2,width,height);

    //alert(x + ": " + y + ": " + width + ": " + height);

    var canvas = $("#canvas")[0].getContext("2d");
    
    canvas.drawImage(this._bufferCanvas.canvas, 0, 0);
    
}



Reaction.prototype.DrawPlayerField = function(color, player) {
    if (player === undefined) {
        player = -1;
    }
    
    //TODO: Mehr als 2 Spieler
    var color2 = "rgb(44,44,44)";
    if (color==null) {
        color = color2;
    }

    Bada.AppLog(this._numberOfPlayers);
          
    //_bufferCanvas->FillRectangle(color2,Rectangle(0,0,__width,__margin));
    //_bufferCanvas->FillRectangle(color2,Rectangle(0,__height-__margin,__width,__margin));
    if (player <0) {
        //Grundieren
        Bada.FillRectangle(this._bufferCanvas,"black",0,0,Reaction.__width*Reaction.__windowWidthProp,Reaction.__windowMargin);
        Bada.FillRectangle(this._bufferCanvas,"black",0,(Reaction.__windowHeight-Reaction.__windowMargin),Reaction.__width*Reaction.__windowWidthProp,Reaction.__windowMargin);

        for (var i=0;i<this._numberOfPlayers;i++) {
            this.DrawPlayerField(null,i);
        }
    }

    var width;
        
    switch(player) {
        case 0:
            width = Reaction.__width;
            if (this._numberOfPlayers > 2) {
                width = Reaction.__width/2-Reaction.__innerMargin;
            }
            width *= Reaction.__windowWidthProp
            Bada.FillRectangle(this._bufferCanvas,color,0,Reaction.__windowHeight-Reaction.__windowMargin,width,Reaction.__windowMargin);
            
            break;
        case 1:
            width = Reaction.__width;

            if (this._numberOfPlayers > 3) {
                width = Reaction.__width/2-Reaction.__innerMargin;
            }
            width *= Reaction.__windowWidthProp
            Bada.FillRectangle(this._bufferCanvas,color,0,0,width,Reaction.__windowMargin);
            break;
        case 2:
            //Ãœbermalen
            //_bufferCanvas->FillRectangle(Color::COLOR_BLACK,Rectangle(Reaction.__width/2-Reaction.__innerMargin,Reaction.__height-Reaction.__margin,2*Reaction.__innerMargin,Reaction.__height-Reaction.__margin));

            //Spieler 3 (neben 1)
            Bada.FillRectangle(this._bufferCanvas,color,Reaction.__windowWidth/2+Reaction.__innerMargin,Reaction.__windowHeight-Reaction.__windowMargin,Reaction.__windowWidth/2-Reaction.__innerMargin,Reaction.__windowHeight-Reaction.__windowMargin);
            break;
        case 3:
            //Ãœbermalen
            //_bufferCanvas->FillRectangle(Color::COLOR_BLACK,Rectangle(Reaction.__width/2-Reaction.__innerMargin,0,2*Reaction.__innerMargin,Reaction.__margin));

            //Spieler 4 (neben 2)
            Bada.FillRectangle(this._bufferCanvas,color,Reaction.__windowWidth/2+Reaction.__innerMargin,0,Reaction.__windowWidth/2-Reaction.__innerMargin,Reaction.__windowMargin);

        default:
            break;
    }



}


Reaction.prototype.DrawPlayerInfo = function() {
    for (var i=0;i<this._numberOfPlayers;i++) {
        var y;

        if (i==0 || i==2) {
            y = Reaction.__height-Reaction.__margin + Reaction.__innerMargin;
        } else {
            y= Reaction.__innerMargin;
        }
        
        //Für Bildschirm anpassen
        y *= Reaction.__windowHeightProp;

        var x = Reaction.__innerMargin;
        if (i==2 || i==3) {
            x=Reaction.__width/2+2*Reaction.__innerMargin;
        }

        var width = Reaction.__width-2*Reaction.__innerMargin;
                
        
        x *= Reaction.__windowWidthProp;
                
        if (this._numberOfPlayers==4 || (this._numberOfPlayers==3 && i==0) || i==2) {
            width = Reaction.__width/2-3*Reaction.__innerMargin;
                         
        }
        width *= Reaction.__windowWidthProp;

        //1.: Spielername
        var infoText = Lang.GetString("Player");
        infoText += " ";
        infoText+= (i+1);

        this._bufferCanvas.fillStyle = "white";

        this._bufferCanvas.font = (25*Reaction.__fontProp) + "px sans-serif";
        this._bufferCanvas.textAlign="left";
        this._bufferCanvas.textBaseline="top";

        Bada.AppLog(x + ":" + y + ":" + infoText);
        this._bufferCanvas.fillText(infoText,x,y);


        //2.: Punkte
        infoText = "";
        infoText += (this._playerPoints[i]);
        infoText += "/";
        infoText += (this._pointsForVictory);


        this._bufferCanvas.textAlign="right";
               
        this._bufferCanvas.fillText(infoText,(x+width),y);


    }
}

Reaction.prototype.DrawPlayerString = function(displayText)
{
    
    this._bufferCanvas.fillStyle = "white";

    this._bufferCanvas.font = Math.round(40*Reaction.__fontProp) + "px sans-serif";
        
        
    /*
	EnrichedText* etext = new EnrichedText();
	TextElement* text = new TextElement();
	etext->Construct(Dimension(Reaction::__width-Reaction::__innerMargin,Reaction::__margin-Reaction::__innerMargin));
	etext->SetHorizontalAlignment(TEXT_ALIGNMENT_CENTER);
	etext->SetVerticalAlignment(TEXT_ALIGNMENT_MIDDLE);
	etext->SetTextWrapStyle(TEXT_WRAP_WORD_WRAP);
	etext->SetTextAbbreviationEnabled(true);

	text->Construct(displayText);
	text->SetTextColor(Color::COLOR_WHITE);
	Font font;
	font.Construct(FONT_STYLE_BOLD, 40);
	text->SetFont(font);
	etext->Add(*text);

	//Spieler 1, 3
	_bufferCanvas->DrawText(Point(Reaction::__innerMargin,Reaction::__height-Reaction::__margin),*etext);*/
    Bada.SetTextCentered(this._bufferCanvas, displayText, Reaction.__innerMargin, Reaction.__windowHeight-Reaction.__windowMargin,Reaction.__windowWidth-Reaction.__innerMargin,Reaction.__windowMargin-Reaction.__innerMargin,Reaction.__fontProp);

    //Spieler 2, 4
    //_bufferCanvas->DrawText(Point(Reaction::__innerMargin,Reaction::__innerMargin),*etext);*/
    Bada.SetTextCentered(this._bufferCanvas, displayText, Reaction.__innerMargin,Reaction.__innerMargin,Reaction.__windowWidth-Reaction.__innerMargin,Reaction.__windowMargin-Reaction.__innerMargin,Reaction.__fontProp);


    //Freigeben
    //delete etext;
    //delete text;
}

Reaction.prototype.RotateForUpperPlayers = function() {
    //Bitmap* bitmap = new Bitmap();
    var height = Reaction.__windowMargin;
   
    var bitmap = this._bufferCanvas.getImageData(0,0,Reaction.__windowWidth,height);

    Bada.drawRotatedImageData(this._bufferCanvas, bitmap, Reaction.__windowWidth/2 , height/2, 180);

}

