﻿/*
 * ReactionGameMatch3.cpp
 *
 *  Created on: 14.07.2012
 *      Author: Thomas
 */



function ReactionGameMatch3(bufferCanvas, fieldCanvas) {
	Bada.AppLog("<construct>");
	this._bufferCanvasField = fieldCanvas;
	this._figuresSet = 0;
        this._figures = new Array(3);
        this._place = new Array(8);
	this._isTrue = false;
	for (i=0;i<3;i++) {
		this._figures[i] = 0;
	}
	for (i=0;i<8;i++) {
		this._place[i] = -1;
	}
}

ReactionGameMatch3.prototype.Time = function() { return 5; };
ReactionGameMatch3.prototype.GetPlayerString = function() {return Lang.GetString("3OfAKind");};

ReactionGameMatch3.prototype.IsTrue = function() {
	return this._isTrue;
}


ReactionGameMatch3.prototype.NextChallenge = function() {
	this._isRunning = true;


	this.Update();
	this.Update();
	this.Draw();
	Bada.AppLog("drawn");

}

/**
 * die nächste Figur aufschlagen
 */
ReactionGameMatch3.prototype.Update = function() {
	if (this._figuresSet<8) {
		this._figuresSet++;

		var figur = Bada.Rand() %3;

		//Platz für Figur festlegen
		//den zz-sten freien Platz nehmen -> Determinismus :)
		var frei = 8-(this._figuresSet-1);
		var zz = Bada.Rand() % frei;
		for (i=0;i<8;i++) {
			if (this._place[i] == -1) {
				if (zz == 0) {
					this._place[i] = figur;
					Bada.AppLog("Figur auf Platz %i",i);
					break;
				} else {
					zz--;
				}
			}
		}

		this._figures[figur]++;
		if (this._figures[figur] >= 3) {
			this._isTrue = true;
		}

	} else {
		this._isRunning = false;
	}
}


ReactionGameMatch3.prototype.OnStart = function() {
	Bada.AppLog("new timer");
	var t = this;
        this._timer = window.setTimeout(function() {
            t.OnTimerExpired(t);
        },999)
	Bada.AppLog("construct timer");
	//this._timer->Construct(*this);
	Bada.AppLog("timer constructed");
	//this._timer->Start(999);
	Bada.AppLog("timer started");


	return true;
}


    ReactionGameMatch3.prototype.OnTimerExpired = function(t) {
	if (this._isRunning) {
            t.Update();
            t.Draw();
            Bada.AppLog("updated...");
            this._timer = window.setTimeout(function() {
                t.OnTimerExpired(t);
            },666)
            
	}
    }



ReactionGameMatch3.prototype.OnStop = function() {
	//_pairs.RemoveAll(true);
	//Bada.AppLog("remove pairs");
	this._isRunning = false;
	if (this._timer != null) {
		window.clearTimeout(this._timer);
		//delete _timer;
	}

	Bada.AppLog("timer removed");
	//delete _dice;

}



ReactionGameMatch3.prototype.Draw = function() {
	var widthOfField = 102;
	var heightOfField = 103;
	var widthOfGrid = 402;
	var heightOfGrid = 200;

	//1. Spielgrid zeichnen
	var offsetX = Reaction.__width/2-widthOfGrid/2;
	var offsetY = Reaction.__heightCanvasField/2-heightOfGrid/2;

	//verzichten, falls schonmal gezeichnet (Performance + monotones UI)

	var path = "Home/Res/match3/grid.png";
	//Bitmap* bmp = null;
	//Image* img = new Image();
	if (this._figuresSet <= 2) {
		//img->Construct();
		//bmp = img->DecodeN(path,BITMAP_PIXEL_FORMAT_ARGB8888);

		//this._bufferCanvasField->DrawBitmap(Point(offsetX,offsetY),*bmp);
                Bada.DrawImage(this._bufferCanvasField,path,offsetX,offsetY,this);
                
	}
	//delete bmp;
	//delete img;



	//die Figuren einzeichnen
	for (j=0;j<3;j++) {
		path = "Home/Res/match3/";
		path += (j);
		path += ".png";

		//bmp = null;
		//img = new Image();
		//img->Construct();
		//bmp = img->DecodeN(path,BITMAP_PIXEL_FORMAT_ARGB8888);

		//Falls Spiel schon vorüber, steckt aber noch immer in Schleife fest
		if (!this._isRunning) {
			//delete bmp;
			//delete img;
			return;
		}

		for (i=0;i<8;i++) {

			//Falls am Feld keine Figur gesetzt -> mit nächstem Feld weitermachen
			if (this._place[i] != j) {
				continue;
			}

			var x=offsetX;
			var y=offsetY;
			var innerOffsetX = i*widthOfField;
			var innerOffsetY = 0;
			//zweite Zeile
			if (i > 3) {
				innerOffsetY += heightOfField;
				innerOffsetX = (i-4)*widthOfField;
			}

			//Laden und zeichnen
                        Bada.DrawImage(this._bufferCanvasField,path,(x+innerOffsetX),(y+innerOffsetY),this);
			//this._bufferCanvasField->DrawBitmap(Point(x+innerOffsetX,y+innerOffsetY),*bmp);
                        

			//Bada.AppLog("Figur %i an Stelle (%i,%i) -> Feld %i gezeichnet",_place[i],innerOffsetX,innerOffsetY,i);

		}

		//delete bmp;
		//delete img;
	}
}


