(function (scope) {
	"use strict";

	function Model() {
	}

	var m = Model.prototype;

	m.currentLevel = 1;

	m.getLevel = function() {
		return this.currentLevel;
	};

	m.setLevel = function(level) {
		this.currentLevel = level;
	};

	m.getVirusImgExt = function() {
		return "png";
	};

	m.getImageDir = function() {
		return "rsc/img";
	};

	m.getSoundDir = function() {
		return "rsc/sounds";
	};

	m.getDefaultManifest = function() {
		this.img_dir = this.getImageDir();
		this.sounds_dir = this.getSoundDir();

		var mani = [
				{src: this.img_dir + "/timed-btn.png", id: "timedBtn"},
				{src: this.img_dir + "/moves-btn.png", id: "movesBtn"},
				{src: this.img_dir + "/endless-btn.png", id: "endlessBtn"},
				{src: this.img_dir + "/play.png", id: "play"},
				{src: this.img_dir + "/start.png", id: "start"},
				{src: this.img_dir + "/exit.png", id: "exit"},
				{src: this.img_dir + "/play-again.png", id: "playAgain"},
				{src: this.img_dir + "/main-menu.png", id: "mainMenu"},
				{src: this.img_dir + "/down-arrow.png", id: "btnDown"},
				{src: this.img_dir + "/up-arrow.png", id: "btnUp"},
				{src: this.sounds_dir + "/Game-Spawn.mp3", id: "right"},
				{src: this.sounds_dir + "/GU-StealDaisy.mp3", id: "wrong"}
		];
		return mani;
	};

	m.getEnimyVelocity = function(level) {
		var resolution = this.getScreenSize();
		if (resolution.height < 890 && resolution.width < 550) {
			return (1 + Math.random()) * 1.3;
		} else {
			return (1 + Math.random()) * 2.5;
		}
	};

	m.maxEnimyCount = function(level) {
		return 5;
	};

	m.getNumber = function(factor) {
		var r = Math.random(),
			item = {};
		
		item.power = 0;	//No special power

		if (r > 0.5) {
			item.num = this.getRandomInt(1, factor*1000);
			if (item.num % factor === 0) {
				item.num--;
			}
			item.type = 0;	//Not a multiple
		} else {
			item.num = this.getRandomMultiple(factor);
			item.type = 1;	//Is a multiple
			if (r > 0.1 && r < 0.2) {
				item.power = "2x";	//Double the score
			}
		}
		return item;
	};

	m.getRandomInt = function (min, max) {
		return Math.floor(Math.random() * (max - min + 1)) + min;
	};

	m.getRandomMultiple = function(num) {
		return Math.floor(Math.random() * (1000)) * num;
	};

	m.getRandomColor = function() {
		var arr = ["#F0C600", "#A8C545", "#D9FF5B", "#046380", "#468966", "#FFB03B", "#A7C520", "#1695A3", "#FF358B", "#CD2C24", "#16193B"];
		return arr[Math.floor(Math.random()*arr.length)];
	};

	m.getScreenSize = function() {
		var ratio = window.devicePixelRatio || 1;
		var w = screen.width * ratio;
		var h = screen.height * ratio;
		return {
			"height" : h,
			"width" : w,
			"ratio" : ratio
		};
	};

	scope.Model = Model; 

} (window));

var gameModel = new Model();