(function (scope) {
	"use strict";

	function Multiple() {
		this.initialize();
		this.loadAssets();
	}
	var c = Multiple.prototype;

	c.initialize = function() {
		var _self = this;
		this.canvas = document.getElementById('canvas');
        this.resizeGame();

		this.MODE_TIMED = "timed";
		this.MODE_MOVES = "moves";
		this.MODE_ENDLESS = "endless";
		_self.timeLeft = 60;
		_self.time_elapsed = 0;
		_self.movesCount = 30;
		_self.movesLeft = _self.movesCount;

        this.stage = new createjs.Stage(canvas);
		this.stage.mouseEventsEnabled = true;
		createjs.Touch.enable(this.stage);

		this.bg = null;				//The background graphic
		this.main = null;			//The parent of canvas
		this.titleView = null;		//The title screen
		this.gameView = null;		//The title screens
		this.startB = null;			//The Start button on the home screen
		this.creditsB = null;			//The credits button on the home screen

		//Canvas configurations
		this.canvsOffsets = this.canvas.getBoundingClientRect();
		this.canvasMinX = this.canvsOffsets.left;						//The distance of canvas from left
		this.WIDTH = this.canvas.width;
		this.HEIGHT = this.canvas.height;

		this.loaderDiv = new createjs.Container();
        this.loading = new createjs.Text("Multiplying the numbers...", "bold italic 26px JosefinSans", "#ff7700");
        this.loading.x = 100;
        this.loading.y = this.HEIGHT/2 - 100;
        this.loaderDiv.addChild(this.loading);
        this.stage.addChild(this.loaderDiv);
        this.stage.update();

        this.audio = [];                    //Store all audio instances
        
        //Ticker object
		this.tkr = null;
		this.FPS = 30;

		//Preloader
		this.preloader = null;
		this.manifest = null;

		this.score = 0;
		this.gameOver = false;

        this.virus = null;
		this.viruses = [];
		this.powers = [];
		this.virusCache = [];

		this.circleShadow = new createjs.Shadow("#000000", 5, 5, 10);
		this.scoreFont = 18;
		this.txtObj = new createjs.Text();
		this.titleHeight = 50;

		this.resolution = gameModel.getScreenSize();

		this.isFirefox = false;
		if (navigator.userAgent.indexOf("Firefox") > -1) {
			this.isFirefox = true;
			this.right_sound = document.querySelector("#right");
			this.wrong_sound = document.querySelector("#wrong");
		}

		this.currentScreen = "loading";
		document.addEventListener("backbutton", onBackKeyDown, false);
		function onBackKeyDown() {
			if (_self.currentScreen === "loading") {
				_self.exitGame();
			} else if (_self.currentScreen === "start") {
				_self.exitGame();
			} else {
				_self.gotMainMenu();
			}
		}
	};

	c.exitGame = function() {
		navigator.app.exitApp();
	};

	c.loadAssets = function () {
		this.manifest = gameModel.getDefaultManifest();

		if (createjs.Sound.initializeDefaultPlugins()) {
			//It is necessary to set alternate extensions as image and audio
			//so that we can load the audio files from the manifest
			//which also contains the image and other files
			// createjs.Sound.alternateExtensions = ["mp3"];
			// createjs.Sound.registerManifest(this.manifest);
		}

        this.preloader = new createjs.LoadQueue(true);

		this.preloader.on("progress", this.handleProgress, this);
		this.preloader.on("fileload", this.handleFileLoad, this);
		this.preloader.on("complete", this.handleComplete, this);

		this.preloader.loadManifest(this.manifest, true);

		createjs.CSSPlugin.install();

	};

	c.handleProgress = function(e) {
        this.stage.removeAllChildren();
		var prog = e.progress * 100;
		prog = prog.toFixed(2);

		//This is a dirty hack
		//The initial loading text is not removed from stage
		//even after using removeallchildren
		//so make it transparent/empty initially
		if (prog < 10) {
			this.loading.text = " ";
			this.loading.color = "#FFFFFF";
		} else {
			this.loading.text = prog + "% multiplied...";
			this.loading.color = "#ff7700";
			var bounds = this.loading.getBounds();
			this.loading.x = this.WIDTH/2-bounds.width/2;
			this.loading.y = this.HEIGHT/2-bounds.height;
		}
		this.loaderDiv.addChild(this.loading);
        this.stage.addChild(this.loaderDiv);
        this.stage.update();
	};

	c.handleFileLoad = function() {
	};

	c.handleComplete = function() {
        this.stage.removeAllChildren();
		this.createStartScene();
	};

	c.log = function(str) {
		console.log(str);
	};

	c.getGameOver = function () {
		return this.gameOver;
	};

	c.setGameOver = function (status) {
		this.gameOver = status;
	};

	c.getMode = function() {
		return this.mode;
	};

	c.setMode = function(m) {
		this.mode = m;
		return this;
	};

	c.getCircleShadow = function() {
		return this.circleShadow;
	};

	c.getScoreText = function(txt) {
		var t = new createjs.Text();
		t.text = txt;
		t.font = "24px JosefinSans";
		t.color = "#000";
		// t.textAlign = "left";
		return t;
	};

	c.createStartScene = function() {
		var _self = this;
		_self.stage.removeAllChildren();
		_self.stage.update();

		this.currentScreen = "start";

		this.titleView = new createjs.Container();

        this.playBgSound();

		//var background = this.preloader.getResult("startBg");
		this.bg = new createjs.Container();
		this.stage.addChild(this.bg);
		this.bg.x = 0;
		this.bg.y = 0;
		this.stage.addChild(this.bg);
		//this.bg.graphics.beginBitmapFill(background, 'repeat').drawRect(0, 0, this.WIDTH, this.HEIGHT);

		var _timedMode = _self.getFileById("timedBtn");
		var timedMode = new createjs.Bitmap(_timedMode.tag);
		timedMode.x  = _self.WIDTH/2 - timedMode.image.width/2;
		timedMode.y = 50;
		timedMode.on("click", this.addNumberSelector.bind(this, _self.MODE_TIMED));

		var _movesMode = _self.getFileById("movesBtn");
		var movesMode = new createjs.Bitmap(_movesMode.tag);
		movesMode.x  = _self.WIDTH/2 - movesMode.image.width/2;
		movesMode.y = timedMode.y + 110;
		movesMode.on("click", this.addNumberSelector.bind(this, _self.MODE_MOVES));

		var _endlessMode = _self.getFileById("endlessBtn");
		var endlessMode = new createjs.Bitmap(_endlessMode.tag);
		endlessMode.x  = _self.WIDTH/2 - endlessMode.image.width/2;
		endlessMode.y = movesMode.y + 110;
		endlessMode.on("click", this.addNumberSelector.bind(this, _self.MODE_ENDLESS));
		
		this.titleView.addChild(timedMode, movesMode, endlessMode);
		this.stage.addChild(this.titleView);

		if (createjs.Ticker.getTicks()) {
			this.titleView.y = -(this.HEIGHT);
			createjs.Tween.get(_self.titleView, {override:true})
				.to({y: 0}, 300);
		}
		this.stage.update();
	};

	c.addGameView = function(mode) {
		var _self = this;

		try {
			_self.setMode(mode);
			_self.addStageItems();
			_self.startGame();
		} catch (e) {
			console.log(e.message);
		}
	};

	c.addNumberSelector = function(mode) {
		var _self = this;
		_self.currentScreen = "";

		//clear the stage to add the number selector
		this.stage.removeAllChildren();

		var num = gameModel.getRandomInt(3, 10);
		this.factor = num;

		var numT = new createjs.Text(this.factor, "bold 72px JosefinSans", "#C33");
		numT.x  = _self.WIDTH/2 - (numT.getMeasuredWidth())/2;
		numT.y = 50;

		var _btnDown = _self.getFileById("btnDown");
		var btnDown = new createjs.Bitmap(_btnDown.tag);
		btnDown.x  = _self.WIDTH/2 - btnDown.image.width - 50;
		btnDown.y = numT.y;
		btnDown.on("click", function() {
			_self.factor--;
			numT.text = _self.factor;
			_self.stage.update();
		});

		var _btnUp = _self.getFileById("btnUp");
		var btnUp = new createjs.Bitmap(_btnUp.tag);
		btnUp.x = btnDown.x + btnDown.image.width + btnUp.image.width;
		btnUp.y = btnDown.y;
		btnUp.on("click", function() {
			_self.factor++;
			numT.text = _self.factor;
			_self.stage.update();
		});

		var _play = _self.getFileById("play");
		var play = new createjs.Bitmap(_play.tag);
		play.x  = _self.WIDTH/2 - (play.image.width)/2;
		play.y = _self.HEIGHT/2;

		play.on("click", function() {
			//Validate the number in text box
			/*var intRegex = /^\d+$/;
			// var factor = document.getElementById("factor").value;
			var factor = num;
			if(!intRegex.test(factor)) {
				alert("Hmm! Trying to fool me. Play fair and enter a number..");
				return false;
			}
			if (!factor) {
				alert("We wont let you cheat!");
				return false;
			}
			if (factor < 2) {
				alert("You must enter some number!");
				return false;
			}
			if (factor > 99) {
				alert("Hmm! We got Einstein! But we wont let you do that :P");
				return false;
			}
			//Update the factor
			_self.factor = factor;*/
			_self.addGameView(mode);
		});

		var _mM = _self.getFileById("mainMenu");
		var mM = new createjs.Bitmap(_mM.tag);
		mM.x  = _self.WIDTH/2 - (mM.image.width)/2;;
		mM.y = play.y + 100;
		mM.on("click", _self.gotMainMenu.bind(_self));

		_self.stage.addChild(numT, btnUp, btnDown, play, mM);

		/*try {
			var box = document.createElement("input");
			box.id = "factor";
			box.value = num;
			box.type = "number";
			box.pattern = 'pattern="[2-9]{2}"';
			box.min = 2;
			box.max = 99;
			box.step = 1;
			box.style.appearance = "none";
			box.style.position = "absolute";
			box.style.width = "200px";
			box.style.height = "100px";
			box.style.top = _self.HEIGHT/2 - 150 + "px";
			box.style.left = _self.WIDTH/2 - 200/2 + "px";
			box.style.border = "2px solid #ff7700";
			box.style.color = "#ff7700";
			box.style.textAlign = "center";
			box.style.fontSize = "72px";
			// document.body.appendChild(box);
			// document.getElementById("factor").focus();
		} catch (e) {
			alert(e.message);
		}*/

		_self.stage.update();
	};

	c.removeTextBox = function() {
		try {
			var body = document.getElementsByTagName("body")[0];
			if (document.getElementById("factor")) {
				body.removeChild(document.getElementById("factor"));
			}
		} catch (e) {

		}
	};

	c.addStageItems = function() {
		var _self = this;
		_self.stage.clear();
		_self.stage.removeAllChildren();
		_self.stage.update();

		//Remove the textbox
		this.removeTextBox();

		if (this.gameView) {
			this.gameView.removeAllChildren();
		} else {
			this.gameView = new createjs.Container();
		}
		this.gameView.x = 0;
		this.gameView.y = 0;

		//Contains all the score and titles on top
		this.titleContainer = new createjs.Container();

		try {
			this.titleBorder = new createjs.Shape();
			this.titleBorder.graphics.beginFill("#FFFFFF").drawRect(0, 0, this.WIDTH, 1);
			this.titleBorder.y = this.titleHeight;
			this.titleBorder.shadow = new createjs.Shadow("#000000", 0, 5, 10);
		} catch (e) {
			console.log(e.message);
		}

		this.scoreText = this.getScoreText("Score: " + this.score);

		if (_self.getMode() === _self.MODE_TIMED) {
			this.levelText = this.getScoreText("Time: " + this.getTimeLeft());
		} else if (_self.getMode() === _self.MODE_MOVES) {
			this.levelLabel = this.getScoreText("Moves: ");
			this.levelText = this.getScoreText(this.getMovesLeft());
		} else if (_self.getMode() === _self.MODE_ENDLESS) {
			this.levelLabel = this.getScoreText("Endless");
			this.levelText = this.getScoreText(" ");
		}

		this.scoreText.x = this.WIDTH/5;
		this.scoreText.y = this.titleHeight/2-10;
		if (this.levelText) {
			this.levelText.x = this.WIDTH*3/5;
			this.levelText.y = this.scoreText.y;
		}

		var topBg = new createjs.Text(this.factor, "bold 272px JosefinSans", "#C33");
		topBg.alpha = 0.1;
		topBg.x = (this.WIDTH - topBg.getMeasuredWidth())/2;
		topBg.y = (this.HEIGHT - 400);
		if (topBg.getMeasuredWidth() > this.WIDTH) {
			var wFactor = this.WIDTH/topBg.getMeasuredWidth();
			topBg.scaleX = wFactor;
			topBg.x = 0;
		}

		this.titleContainer.addChild(this.titleBorder, this.scoreText, this.levelText, topBg);

		if (createjs.Ticker.getTicks()) {
			_self.titleContainer.y = -(this.titleHeight);
			createjs.Tween.get(_self.titleContainer, {override:true})
				.to({y: 0}, 100);

			_self.scoreText.x = -(_self.WIDTH/5);
			createjs.Tween.get(_self.scoreText, {override:true})
				.wait(150)
				.to({x: -(_self.scoreText.x)}, 200);

			_self.levelText.x = (_self.WIDTH + 100);
			createjs.Tween.get(_self.levelText, {override:true})
				.wait(150)
				.to({x: _self.WIDTH*3/5}, 200);
		}

		this.gameView.addChild(this.titleContainer, topBg);
		this.stage.addChild(this.gameView);
	};

	c.addLevelItems = function() {
	};

	c.levelComplete = function() {
		var _self = this;

		var X = _self.HEIGHT+200;

		try {
			createjs.Tween.get(_self.gameView, {override:true})
				.to({y: -X}, 300)
				.call(_self.afterLevelComplete(), [""], _self);
			// _self.afterLevelComplete();
		} catch(e) {
			console.log(e.message);
		}
		console.log("level complete");
	};

	c.afterLevelComplete = function() {
		var _self = this;
		try {
			_self.setGameOver(true);
			createjs.Ticker._inited = false;
			_self.createCompleteScreen();
		} catch(e) {
			console.log(e.message);
		}
	};

	c.createCompleteScreen = function() {
		var _self = this;

        var score = new createjs.Text("Your Score", "22px JosefinSans"),
			_width = score.getMeasuredWidth(),
			_height = score.getMeasuredHeight();
        score.x = _self.WIDTH/2 - _width/2;
        score.y = _self.WIDTH/2 - _height;

        var scoreN = new createjs.Text(_self.score, "bold 52px JosefinSans"),
			_widthN = scoreN.getMeasuredWidth(),
			_heightN = scoreN.getMeasuredHeight();
        scoreN.x = _self.WIDTH/2 - _widthN/2;
        scoreN.y = score.y + _heightN;

		var _pA = _self.getFileById("playAgain");
		var pA = new createjs.Bitmap(_pA.tag);
		pA.x  = _self.WIDTH/2 - pA.image.width/2;
		pA.y = scoreN.y + 100;
	
		var _mM = _self.getFileById("mainMenu");
		var mM = new createjs.Bitmap(_mM.tag);
		mM.x  = pA.x;
		mM.y = pA.y + 100;
	
		pA.on("click", function() {
			_self.reset();
			_self.setGameOver(false);
			_self.addGameView(_self.getMode());
		});
		mM.on("click", this.gotMainMenu.bind(this));

        _self.stage.addChild(score, scoreN, pA, mM);
	};

    c.reset = function() {
		var _self = this;
		_self.viruses = [];
		_self.setTimeLeft(_self.timeLeft);
		_self.setMovesLeft(_self.movesCount);
		_self.time_elapsed = 0;
		_self.score = 0;
		_self.flyingPoints = null;
		this.removeTextBox();
    };

    c.gotMainMenu = function() {
		var _self = this;
		_self.currentScreen = "start";
		_self.reset();
		_self.createStartScene();
    };

	c.startGame = function() {
		var _self = this;
		this.preStartGame();

		//The ticker should be started only once
		//If it has already been started, do not start again
		createjs.Ticker.init();
		// console.log(createjs.Ticker.getTicks());
		if (!createjs.Ticker.getTicks()) {
			createjs.Ticker.setFPS(_self.FPS);
			this.tkr = createjs.Ticker.on("tick", function() {
				_self.update();
			});
		}

	};

	c.preStartGame = function() {
		this.setGameOver(false);

		this.bg.on("click", function() {
			return false;
		});
		this.addLevelItems();
	};

	c.pauseGame = function() {
		createjs.Ticker.setPaused(true);
		this.pauseB.visible = false;
		this.resumeB.visible = true;
	};

	c.resumeGame = function() {
		createjs.Ticker.setPaused(false);
		this.resumeB.visible = false;
		this.pauseB.visible = true;
	};

	c.getTimeLeft = function() {
		return this.timeLeft;
	};

	c.setTimeLeft = function(t) {
		this.timeLeft = t;
	};

	c.getMovesLeft = function() {
		return this.movesLeft;
	};

	c.setMovesLeft = function(t) {
		this.movesLeft = t;
	};

	c.update = function() {
		var _self = this;
			// console.log(createjs.Ticker.getPaused());
			// console.log(_self.assetsLoaded);
		// console.log("ddd: " + createjs.Ticker.getTicks() + ", " + _self.getGameOver());
		if (!createjs.Ticker.getPaused()) {
			if (!_self.getGameOver()) {
				_self.preUpdate();
				_self.addObjects();
			}
			_self.stage.update();
		}
	};

	c.preUpdate = function() {
		var _self = this;
		if (_self.getMode() === _self.MODE_TIMED) {
			// If true only time elapsed while Ticker was not paused will be returned.
			// If false, the value returned will be total time elapsed since the first tick event listener was added.
			_self.time_elapsed += createjs.Ticker.getInterval();
			if (_self.time_elapsed >= _self.getTimeLeft()*1000) {
				_self.levelComplete();
			} else {
				var t = Math.round(_self.getTimeLeft() - _self.time_elapsed/1000);
				_self.displayTimeLeft(t);
			}
		} else if (_self.getMode() === _self.MODE_MOVES) {
			if (_self.getMovesLeft() <= 0) {
				_self.levelComplete();
			} else {
				_self.displayMovesLeft(_self.getMovesLeft());
			}
		}
	};

	c.addObjects = function() {
		var _self = this;
		var virus = null;
		var power = null;
		var currLevel = 1;
        var velocity = gameModel.getEnimyVelocity(currLevel);
        var maxEnimyCount = gameModel.maxEnimyCount(currLevel) - 1;

        var viruses = this.getViruses();
		var r = Math.random();
		for (var a = viruses.length - 1; a >= 0; a--) {
			if (this.viruses.length <= maxEnimyCount) {
				r = Math.random();
				if (r > 0.4 && r < 0.5) {
					virus = viruses[a];
					var bounds = virus.getBounds();
					virus.velY = velocity;
					virus.y = _self.titleHeight;
					virus.x = Math.random() * (this.WIDTH - (virus.scaleX*bounds.width));
					if (virus.x < bounds.width*virus.scaleX) {
						virus.x = bounds.width*virus.scaleX - 15;
					}

					if  (virus.power === "2x") {
						// createjs.Tween.get(virus, {loop:true}).to({rotation:360}, 1000);
					}

					this.viruses.push(virus);
					this.gameView.addChild(virus);
					virus.on("click", _self.highlightItem.bind(_self, virus));
				}
			}
		}
		

		for (var i = this.viruses.length - 1; i >= 0; i--) {
			var _virus = this.viruses[i];
			_virus.y += _virus.velY;
			var _bounds = _virus.getBounds();

			//Remove the virus if it crosses the bottom
			if (_virus.y > this.HEIGHT - _bounds.height*_virus.scaleY/2) {
				this.removeItem(_virus);	//true = dissolve
			}
			// this.checkCollision(_virus);
		}
	};

    c.getViruses = function() {
		var arr = [];

		var num_container = new createjs.Container();

		var item = gameModel.getNumber(this.factor);

		var str = item.num;
		if (item.power === "2x") {
			str = "2x";
		}
        var num = new createjs.Text(str, "bold 32px JosefinSans", "#fff");
        var num_width = num.getMeasuredWidth(),
			num_height = num.getMeasuredHeight();
        num.x -= num_width/2;
        num.y -= num_height/2+5;

        var color = gameModel.getRandomColor();
		var shape = new createjs.Shape();
		var g = shape.graphics;
		g.beginFill(color).drawCircle(0, 0, num_width/2 + 10).endFill();
		shape.alpha = 0.8;
		shape.radius = num_width/2;
		shape.shadow = this.getCircleShadow();
		if (this.resolution.height < 890 && this.resolution.width < 550) {
			shape.scaleX = 1;
			shape.scaleY = 1;
		} else {
			shape.scaleX = 1.5;
			shape.scaleY = 1.5;
		}

		num_container.setBounds(0, 0, num_width, num_height);

		//Store the number as a property of he container
		num_container.value = item.num;
		num_container.type = item.type;
		num_container.power = item.power;
		num_container.color = color;

        num_container.addChild(shape, num);

		arr.push(num_container);

		/*var viruses = gameModel.getVirusForLevel(this.getCurrentLevel());
		for (var x in viruses) {
			//If the object exists in cache, get it from cache
			if (this.virusCache[viruses[x]]) {
				var new_virus = this.virusCache[viruses[x]].clone();
				arr.push(new_virus);
			} else {
				var _v = this.getAssetById(viruses[x]);
				_v = new createjs.Bitmap(_v.tag);
				this.virusCache[viruses[x]] = _v;
				arr.push(_v);
			}
		}*/
		return arr;
    };

    c.highlightItem = function(item) {
		var circle = item.getChildAt(0);
		if (item.type === 1) {	//It is a multiple
			createjs.Tween.get(item, {loop:false})
				.to({scaleX:2, scaleY:2, alpha:0}, 500);
		} else if (item.type === 0) {
			createjs.Tween.get(item, {loop:false})
				.to({scaleX:0.2, scaleY:0.2, alpha:0}, 500);
		}
		this.explodeItem(item);
    };

	c.removeItem = function(item) {
		this.gameView.removeChild(item);
		var index = this.viruses.indexOf(item);
		if (index > -1) {
			this.viruses.splice(index, 1);
		}
	};

	/*c.checkCollision = function(item) {

		var Xhit = false,
			Yhit = false,
			bounds = item.getBounds();

		var paddleMaxW = this.paddle.x + this.paddleWidth,
			itemMinW = item.x - (bounds.width/2)*item.scaleX,
			itemMaxW = itemMinW + bounds.width*item.scaleX;

		var paddleMaxH = this.paddle.y + this.paddleHeight,
			itemMinH = item.y - (bounds.height/2)*item.scaleY,
			itemMaxH = itemMinH + bounds.height*item.scaleY;

		if (itemMaxW > this.paddle.x && itemMinW < paddleMaxW) {
			Xhit = true;
		} else {
			Xhit = false;
		}
		if (itemMaxH > this.paddle.y && item.y < paddleMaxH) {
			Yhit = true;
		} else {
			Yhit = false;
		}
		//if (item.type == "enimy") {
			// console.log(paddleMaxW +":"+ itemMinW +":"+ itemMaxW +":"+ this.paddle.x);
			// console.log(Xhit +":"+ Yhit);
			// console.log(item.type);
		//}

		if (Xhit && Yhit && item.removed !== true) {
			this.explodeItem(item);
			//this.removeItem(item);
		}
	};*/

	c.explodeItem = function(item) {
		var _self = this;
		if (!item.removed) {
			this.updateScore(item);
			var moves_left = this.getMovesLeft() - 1;
			this.setMovesLeft(moves_left);
		}

		if (item.type == 1) {	//It is a multiple
            this.playSound("right");
			createjs.Tween.get(item, {override:true})
				.to({scaleX:1.5, scaleY:1.5, alpha: 0, visible:false}, 100)
				.call(_self.explodeComplete.bind(_self, item));
		} else {
            this.playSound("wrong");
			createjs.Tween.get(item, {override:true})
				.to({scaleX:0.5, scaleY:0.5, alpha: 0, visible:false}, 150)
				.call(_self.explodeComplete.bind(_self, item));
		}
	};

	c.explodeComplete = function(item) {
		this.removeItem(item);
	};

	c.updateScore = function(item) {
		var points = null;
		this.score = parseInt(this.score, 10);
		item.removed = true;
		if (item.type === 1) {
			if (item.power === "2x") {
				points = "You got doubled!";
				this.score *= 2;
			} else {
				points = this.factor;
				this.score += parseInt(points, 10);
			}
		} else if (item.type === 0) {
			points = this.factor;
			this.score -= parseInt(points, 10);
		}

		if (this.score < 1) {
			this.score = 0;
		}
		this.scoreText.text = "Score: " + this.score;
		this.flyPoints(item, points);
	};

	c.flyPoints = function (item, points) {
		if (item.type === 0) {
			points = "-"+points;
		}
        //Show points image when enimy is hit
        if (!this.flyingPoints) {
			this.flyingPoints = new createjs.Text(points, "50px JosefinSans", item.color);
            this.gameView.addChild(this.flyingPoints);
        }
        this.flyingPoints.text = points;
        this.flyingPoints.color = item.color;
        this.flyingPoints.x = item.x;
        this.flyingPoints.y = item.y;
        this.flyingPoints.name = "flyingPoints";
        this.flyingPoints.alpha = 1;
        createjs.Tween.get(this.flyingPoints, {override:true})
             .to({x:item.x, y:item.y-80, alpha:0, }, 1500);
	};

	c.displayTimeLeft = function(val) {
		this.levelText.text = "Time: " + val;
	};

	c.displayMovesLeft = function(val) {
		this.levelText.text = "Moves: " + val;
	};

	c.playBgSound = function(type) {
        /**
         * Important: Always release media object before reusing it
         */
        return false;
        if (this.audio.bg !== null) {
            this.audio.bg.release();
        }
        var aud = this.getFileById("bg_sound");
        try {
            this.audio.bg = new Media(aud.src, null, function onError(error) {
                alert('code: '    + error.code    + '\n' + 'message: ' + error.message + '\n');
            }, this.onBgAudioStatus.bind(this));
            this.audio.bg.play();
        } catch (e) {
            alert(e.message);
        }
	};
    c.onBgAudioStatus = function(status) {
        if( status==Media.MEDIA_STOPPED ) {
            this.audio.bg.play();
        }
    };

    c.playSound = function(type) {
		if (this.isFirefox) {
			if (type == "right") {
				this.right_sound.play();
			} else {
				this.wrong_sound.play();
			}
		}
		createjs.Sound.play("right");
		return false;

        var name = "";
        if (type == "right") {
            name = "right";
        } else if (type == "wrong") {
            name = "wrong";
        }

        var aud = this.getFileById(name);
        try {
            /**
             * Important: Always release media object before reusing it
             */
            if (this.audio[name]) {
                this.audio[name].release();
            } else {
                this.audio[name] = new Media(aud.src, null, function onError(error) {
                    // alert('code: ' + error.code    + '\n' + 'message: ' + error.message + '\n');
                });
            }
            this.audio[name].play();
            if (name == "wrong") {
				this.audio[name].setVolume('0.5');
            }
        } catch (e) {
            // alert(e.message + " : " + aud.src);
        }
        
	};

	c.getCurrentLevel = function() {
		return this.currLevel;
	};

	c.setCurrentLevel = function(level) {
		this.currLevel = level;
	};

	c.getFileById = function(fileId) {
		return this.preloader.getItem(fileId);
	};

    c.resizeGame = function() {
        var gameArea = document.getElementById('main');
        var widthToHeight = 3 / 4;
        var newWidth = window.innerWidth;
        var newHeight = window.innerHeight;
        var newWidthToHeight = newWidth / newHeight;

        if (newWidthToHeight > widthToHeight) {
            newWidth = newHeight * widthToHeight;
            gameArea.style.height = newHeight + 'px';
            gameArea.style.width = newWidth + 'px';
        } else {
            newHeight = newWidth / widthToHeight;
            gameArea.style.width = newWidth + 'px';
            gameArea.style.height = newHeight + 'px';
        }

        //gameArea.style.marginTop = (-newHeight / 2) + 'px';
        //gameArea.style.marginLeft = (-newWidth / 2) + 'px';
        if( window.navigator.userAgent.match(/(iPhone|iPod|iPad|Android|BlackBerry)/i) ) {
            this.canvas.height = window.innerHeight;
            this.canvas.width  = window.innerWidth;
            gameArea.style.height = window.innerHeight+"px";
            gameArea.style.width = window.innerWidth+"px";
        } else {
            this.canvas.width = newWidth;
            this.canvas.height = newHeight;
        }
    };

	scope.Multiple = Multiple; 

} (window));

function chaserException(message) {
	this.name = name;
	this.message = message;
	console.log(message);
}

// document.addEventListener('deviceready', onDeviceReady, false);
window.addEventListener('load', onDeviceReady, false);
function onDeviceReady() {
	var multiple = new Multiple();
}
