// Cargo los partials que necesito
app.loadPartials([
	'cuando-llega/cuando-llega.html',
	'cuando-llega/cuando-llega-resultado.html'
]);

app.cuandoLlega = {
	// Attributes
	
	paradasFrecuentes: {},
	servlet: 'http://www.ushuaia.gob.ar/servicios/parada',

	// Methods

	listarParadaFavorita: function(paradaID) {
		// agregamos a las paradas favoritas
		jQuery(".paradas-favoritas").append('<div class="btn-group" id="' + paradaID + '" pid="p' + paradaID + '"><button onclick="return app.cuandoLlega.consultarParadaFavorita('+paradaID+');" class="btn btn-default parada-favorita">Parada ' + paradaID + '</button><button onclick="return app.cuandoLlega.quitarParadaFavorita('+paradaID+');" class="btn btn-default quitar-favorita">X</button></div>');
	},

	listarParadasFavoritas: function() {

		jQuery('.paradas-favoritas').empty();

		// Recorremos las paradas favoritas y las mostramos
		for ( pid in app.cuandoLlega.paradasFrecuentes ) {	
			// listamos las paradas favoritas
			app.cuandoLlega.listarParadaFavorita(app.cuandoLlega.paradasFrecuentes[pid].id);
		}
	},

	consultarParadaFavorita: function(paradaID) {
		try {
			// relleno el input
			jQuery("#fieldparada").val(paradaID);

			// ejecutamos el formulario
			jQuery("#form-consultar-parada").submit();
			
			return false;
		}
		catch(err) {
			console.log(err.message);
		}
	},

	quitarParadaFavorita: function(paradaID) {
		try {
			var pid = "p" + paradaID;

			delete app.cuandoLlega.paradasFrecuentes[pid];
			localStorage.setObject("paradasFrecuentes", app.cuandoLlega.paradasFrecuentes); 
			jQuery(".btn-group#"+paradaID).remove();

			return false;
		}
		catch(err) {
			console.log(err.message);
		}
	},


	// Consultamos cuánto falta para que llegue el colectivo
	cuantoFalta: function(paradaID) {

		//seteamos la url con el nro de parada en el analytics
		_gaq.push(['_trackEvent', 'parada', 'phone', paradaID.toString()]);

		if ( typeof app.cuandoLlega.paradasFrecuentes["p"+paradaID] !== "undefined" ) {
			app.cuandoLlega.paradasFrecuentes["p"+paradaID].count++;
		}
		else {
			app.cuandoLlega.paradasFrecuentes["p"+paradaID] = { 'id' : paradaID , 'count' : 1 } ;
			app.cuandoLlega.listarParadaFavorita(paradaID);
		}
		localStorage.setObject("paradasFrecuentes", app.cuandoLlega.paradasFrecuentes); 


		// Aqui llamaremos al proveedor con ajax para 
		// obtener el tiempo que falta para que llegue el colectivo
		jQuery.ajax({
			type:         'GET',
			url:          app.cuandoLlega.servlet,
			data:         { nro : paradaID , nocache : app.nocache() },
			dataType:     'json',

			success: function(data) {

				if (parseInt(data.Response.Cant.Valor) > 0) {

					espera = "<ul>";

					if (data.Response.Cant.Valor > 1) {
						for (var i in data.Response.Movil) {
							var movil = data.Response.Movil[i];
							espera += "<li>Linea " + movil.linea + ", " + movil.ramal.capitalize() + ": ";

							if (parseInt(movil.tiempo) > 0) {
								espera += "espera, " + movil.tiempo + "min</li>";                
							}
							else {
								espera += "arribando</li>";
							}

						} // for moviles

					} // Response.Cant > 1

					else {

							var movil = data.Response.Movil;

							espera += "<li>Linea " + movil.linea + ", " + movil.ramal.capitalize() + ": ";

							if (parseInt(movil.tiempo) > 0) {
								espera += "espera, " + movil.tiempo + "min</li>";                
							}
							else {
								espera += "arribando</li>";
							}

					} // Response.Cant == 1

					espera += "</ul>";
				} // if > 0

				else {
			        espera = "<p>"+data.Response.Estado.Valor+"</p>";
				}

				jQuery("#cuando-llega-info p").html(espera);

			}, // success

			error: function() {
				error = "<p>Error en la conexión con el servidor</p>";
				jQuery("#cuando-llega-info p").html(error);
			} // error

		}); // ajax

	}, // cuantoFalta(paradaID)

	consultarParada: function(paradaID) {
		try {
			window.location.hash = 'cuando-llega-resultado';

			setTimeout( function() {
	        	jQuery(".pages #cuando-llega-info h4").html("Parada " + paradaID);
				jQuery(".pages #cuando-llega-info p").html("Consultando servidor...");
	    	} , 100);
			
			app.cuandoLlega.cuantoFalta(paradaID);
		}
		catch(err) {
			console.log(err.message);
		}
	}

} // cuandoLlega


/*
 * ******************************************
 * MAIN
 * ******************************************
 */

// Configuramos el localStorage para las paradas favoritas
if ( typeof localStorage.paradasFrecuentes === "undefined" ) {
	localStorage.setObject("paradasFrecuentes", {}); 
}

app.cuandoLlega.paradasFrecuentes = localStorage.getObject('paradasFrecuentes');

jQuery('.pages').on('click', '#consultar-parada', function(event) {
	try {
		// Prevenimos que no se siga el link "<a href='#'>"
		event.preventDefault();
		jQuery("#cuando-llega #form-consultar-parada").submit();
	}
	catch(err) {
		console.log(err.message);
	}	
});

jQuery('.pages').on('submit', '#form-consultar-parada', function(event) {
	try {
		event.preventDefault();
		var paradaID = parseInt(jQuery("#fieldparada").val());
		app.cuandoLlega.consultarParada(paradaID);
	}
	catch(err) {
		console.log(err.message);
	}
});