/*
 * ******************************************
 * DEFINITIONS
 * ******************************************
 */

// string
String.prototype.capitalize = function() {
        word = this.toLowerCase();
        return word.charAt(0).toUpperCase() + word.slice(1);
};

String.prototype.toProperCase = function () {
    word = this.toLowerCase();
        return word.replace(/\w\S*/g, function(word) {

        if(skipProperCase.indexOf(word) == -1) {
                return word.capitalize();
            }
            else {
                return word;
            }
        });
};

// Agregamos capacidad para manejar objetos a localStorage
Storage.prototype.setObject = function(key, value) {
    this.setItem(key, JSON.stringify(value));
};
 
Storage.prototype.getObject = function(key) {
    return JSON.parse(this.getItem(key));
};


var app = {
    // Attributes
    deviceLoaded: false,
    
    modules: [
        'home',
        'cuando-llega',
        'vecino-cumplidor',
        'error-reporting',
        'telefonos'
    ],

    // Methods
    nocache: function() {
        return (new Date().getTime());
    },

    // Realiza el efecto de transicion si cambia el hash
    route: function(event) {
        var hash = window.location.hash;
        var page;

        if (hash === "#quit") {
            navigator.app.exitApp();
            return;
        }

        page = $(".pages " + hash);
        page.find(".dynamic-content").html("<p>Cargando contenidos...</p>");

        if (!page.length || hash === "" || hash === "#")  {
            page = $(".pages #home");
        }

        page.find()
        slider.showPage(page);
        
        try{
            var initFunc = jQuery(hash).attr('data-initialize');
            var module = initFunc.split('.')[1];
            var method = initFunc.split('.')[2];
            var fn = window['app'][module][method];
            
            if (fn && typeof(fn) === "function") {  
                fn();  
            }
        }
        catch(err) {
            //console.log(err.message);
        }
    }, // route()

    // carga las vistas parciales pasdas en el arreglo partials
    loadPartials: function(partials) {
        setTimeout( function() {
            for (var i = 0, length = partials.length; i < length; i++) {
                jQuery.get(
					"partials/" + partials[i], 
					function(data) { 
						jQuery(".pages").append(data);
					},
					"html"
				);
            }
        }, 0);
    },


    parseTemplate: function(tpl_id, content_class, data) {
        // Parsing Handlebars
        var source   = $(tpl_id).html();
        var template = Handlebars.compile(source);
        $(content_class).html(template(data));

        var page = jQuery(".page").not(".page-hidden");
        jQuery(".pages").height(page.height());
    }, // parseTemplate()


    // Se ejecuta con el evento onDeviceReady que ocurre en los moviles
    onDeviceReady: function() {
        if (! app.deviceLoaded) {

            app.deviceLoaded = true;
            jQuery(".page").addClass("page-hidden");
            slider = new PageRouter();

            setTimeout( function() {
                // Basic page routing
                window.onhashchange = app.route;

                // Default to Home
                slider.showPage($(".pages #home"));

                // Quitamos el splash
                jQuery(".splash").remove();

            } , 1500);
        }


        jQuery(window).resize(function () {
            var h = jQuery(window).height() - 50;
            jQuery('.map').css('height', h);
        }).resize();


    } // onDeviceReady()
} // app


/*
 * ******************************************
 * MAIN
 * ******************************************
 */

require.config({
    baseUrl: 'js',
    paths: {
        libs:               'lib',
        async:              'lib/requirejs/async',
        docRoot:            '..',
        modules:            '../partials',
        jquery:             'lib/jquery.min',
        ganalytics:         'lib/ga',
        handlebars:         'lib/handlebars-v1.1.2'
    }
});

// Convierto Google Maps en un modulo de require
define('gmaps', ['async!http://maps.google.com/maps/api/js?v=3&sensor=false'], function(){
    // return the gmaps namespace for brevity
    return window.google.maps;
});


// Cargo lo basico para la aplicacion
require(['jquery', 'libs/pagerouter', 'handlebars'], function(jQuery, slider, handlebars) {

    document.addEventListener("deviceready", app.onDeviceReady, false);

    // Si el dispositivo no acusa recibo, 
    // forzamos para quitar el splash
    // sirve para celus viejos y debug en PC
    setTimeout( function() {
        app.onDeviceReady();
    } , 4000);

    for (var i = 0, length = app.modules.length; i < length; i++) {
        require([app.modules[i]]);
    }
});


// Cargo fasclick
require(["libs/fastclick"], function(FastClick) {
    FastClick.attach(document.body);
});
