// Cargo los partials que necesito
app.loadPartials([
	'residuos-voluminosos/residuos-voluminosos.html',
	'residuos-voluminosos/residuos-voluminosos-resultado.html'
]);

app.residuosVoluminosos = {

	map: null,
	layer: null,
	nombre: '',
	descripcion: '',

	inicializarMapa: function() {
		require(['gmaps'],function(){
			
			var mapOptions = {
		      center: new google.maps.LatLng(-54.8038, -68.3037),
		      zoom: 13,
		      mapTypeId: google.maps.MapTypeId.ROADMAP
		    };
		    app.residuosVoluminosos.map = new google.maps.Map(document.getElementById("map_canvas"), mapOptions);

		    app.residuosVoluminosos.layer = new google.maps.KmlLayer({
		      	url: "https://maps.google.com/maps/ms?authuser=0&vps=2&ie=UTF8&msa=0&output=kml&msid=213226060073051276714.0004daa1115cc68c4d441",
		      	preserveViewport: true,
		      	suppressInfoWindows: true
	  		});
		    app.residuosVoluminosos.layer.setMap(app.residuosVoluminosos.map);

		    google.maps.event.addListener(app.residuosVoluminosos.layer, 'click', function (obj) {
			    
			    app.residuosVoluminosos.nombre = obj.featureData.name;
			    app.residuosVoluminosos.descripcion = obj.featureData.description;

			    jQuery("#residuos-voluminosos-info h4").html(app.residuosVoluminosos.nombre);
				jQuery("#residuos-voluminosos-info p").html(app.residuosVoluminosos.descripcion);			
			});

		});
	}, // inicializarMapa

	mostrarInformacion: function() {
		jQuery("#residuos-voluminosos-info h4").html(app.residuosVoluminosos.nombre);
		jQuery("#residuos-voluminosos-info p").html(app.residuosVoluminosos.descripcion);
	}
}; // app.residuosVoluminosos