// Cargo los partials que necesito
app.loadPartials(['vecino-cumplidor/vecino-cumplidor.html']);
app.loadPartials(['vecino-cumplidor/vecino-cumplidor-rubros.html']);
app.loadPartials(['vecino-cumplidor/vecino-cumplidor-mapa.html']);
app.loadPartials(['vecino-cumplidor/vecino-cumplidor-comercios.html']);
app.loadPartials(['vecino-cumplidor/vecino-cumplidor-ficha.html']);
app.loadPartials(['vecino-cumplidor/vecino-cumplidor-adherir.html']);

app.vecinoCumplidor = {

	map: null,
	loaded: false,
	api: "http://www.ushuaia.gob.ar/servicios/vecino-cumplidor",
	params : {},

	setupMap: function(lat, lng) {
		require(['gmaps'],function(){
			
			var mapOptions = {
		      center: new google.maps.LatLng(lat,lng),
		      zoom: 13,
		      mapTypeId: google.maps.MapTypeId.ROADMAP
		    };
		    app.vecinoCumplidor.map = new google.maps.Map(jQuery("#vecino-cumplidor-mapa .map")[0], mapOptions);

		    app.vecinoCumplidor.getMarkers();

		});
	}, // initializeMap()

	addMarkers: function(points) {
        jQuery.each(points,function(index, point) {

          var marker = new google.maps.Marker({
            "id"		: point.id,
            "position"  : new google.maps.LatLng(point.lat, point.lng),
            "map"       : app.vecinoCumplidor.map
          });

          marker.comercios = point.comercios;

          // asignamos el evento click al marcador
          google.maps.event.addListener(marker, 'click', function() {
          	if (marker.comercios.length == 1) {
	          	app.vecinoCumplidor.params.comercio = { id : marker.comercios[0], consulta : "comercio" };
	            window.location.hash = "#vecino-cumplidor-ficha";          		
          	}
          	else {
	          	app.vecinoCumplidor.params.comercios = { localizacion : marker.id, consulta : "comercios" };
	            window.location.hash = "#vecino-cumplidor-comercios";          		
          	}
          });
          
        }); // each
	}, // addMarkers()

	getMarkers: function() {

		jQuery.ajax({
			type:         'GET',
			url:          app.vecinoCumplidor.api,
			data:         { consulta : "localizaciones" },
			dataType:     'json',

			success: function(data) {
				app.vecinoCumplidor.addMarkers(data.localizaciones);
			}
		});

	}, // getMarkers()

	initializeMap: function() {

		if (!app.vecinoCumplidor.loaded) {

	        if (navigator.geolocation) {
	            navigator.geolocation.getCurrentPosition(app.vecinoCumplidor.geolocationOnSuccess, app.vecinoCumplidor.geolocationOnError, { timeout: 3000 });
	        }else{
	            app.vecinoCumplidor.geolocationOnError();
	        }

			app.vecinoCumplidor.loaded = true;
		}
	}, // initializeMap()

	geolocationOnSuccess: function(position) {
		app.vecinoCumplidor.setupMap(position.coords.latitude, position.coords.longitude);
	}, // geolocationOnSuccess()

	geolocationOnError: function(error) {
		app.vecinoCumplidor.setupMap(-54.8038, -68.3037);
	}, // geolocationOnError()


	// Consultamos cuánto falta para que llegue el colectivo
	getRubros: function() {
      	
      	app.vecinoCumplidor.params.rubros = { consulta : "rubros" };

		jQuery.ajax({
			type:         'GET',
			url:          app.vecinoCumplidor.api,
			data:         app.vecinoCumplidor.params.rubros,
			dataType:     'json',

			success: function(data) {
				app.parseTemplate("#rubros_tpl", ".rubros_tpl", data);
			}
		});

	}, // getRubros()


	getComercios: function() {

		jQuery.ajax({
			type:         'GET',
			url:          app.vecinoCumplidor.api,
			data:         app.vecinoCumplidor.params.comercios,
			dataType:     'json',

			success: function(data) {
				app.parseTemplate("#comercios_tpl", ".comercios_tpl", data);
			}
		});

	}, // getComercios()


	getComercio: function() {

		jQuery.ajax({
			type:         'GET',
			url:          app.vecinoCumplidor.api,
			data:         app.vecinoCumplidor.params.comercio,
			dataType:     'json',

			success: function(data) {
				app.parseTemplate("#comercio_tpl", ".comercio_tpl", data);
			}
		});

	} // getComercio()

}; // app.vecinoCumplidor
