/* 
Mecanismo para obtener paradas desde web http://paradas.efibus.com.ar

1. Copiar contenido de todas las páginas con las tablas de paradas y pegarlos en excel
2. Quitar las columnas que sobran y pegarlo en sublime
3. Aplicar estas dos expresiones regulares

	([0-9]..)\t(.*)\t(.+)\t(.+)
	paradas['p$1'] = { 'id': $1 , 'descripcion': '$2' , 'lat': $3 , 'lng': $4 }

	-([0-9].)
	-$1.

*/

var paradas = new Object();
paradas['p105'] = { 'id': 105 , 'descripcion': 'DELOQUI Y DON BOSCO' , 'lat': -54.807623 , 'lng': -68.312838 };
paradas['p110'] = { 'id': 110 , 'descripcion': 'DELOQUI Y FADUL' , 'lat': -54.806572 , 'lng': -68.308718 };
paradas['p115'] = { 'id': 115 , 'descripcion': 'YAGANES Y DELOQUI' , 'lat': -54.803653 , 'lng': -68.299084 };
paradas['p120'] = { 'id': 120 , 'descripcion': 'YAGANES Y HEROES DE MALVINAS' , 'lat': -54.800400 , 'lng': -68.301530 };
paradas['p125'] = { 'id': 125 , 'descripcion': 'HEROES DE MALVINAS Y YAGANES' , 'lat': -54.799510 , 'lng': -68.301530 };
paradas['p130'] = { 'id': 130 , 'descripcion': 'HEROES DE MALVINAS Y BAHIA BUEN SUCESO' , 'lat': -54.796417 , 'lng': -68.291702 };
paradas['p135'] = { 'id': 135 , 'descripcion': 'PIONEROS FUEGUINOS EN Bº 640 VIVIENDAS I' , 'lat': -54.793956 , 'lng': -68.232329 };
paradas['p140'] = { 'id': 140 , 'descripcion': 'HEROES DE MALVINAS Y AGENTE MARIA CAMIÑA' , 'lat': -54.789205 , 'lng': -68.228767 };
paradas['p145'] = { 'id': 145 , 'descripcion': 'PIONEROS FUEGUINOS Y PERITO MORENO' , 'lat': -54.794686 , 'lng': -68.229325 };
paradas['p150'] = { 'id': 150 , 'descripcion': 'PIONEROS FUEGUINOS EN Bº 640 VIVIENDAS' , 'lat': -54.793634 , 'lng': -68.232329 };
paradas['p155'] = { 'id': 155 , 'descripcion': 'PIONEROS FUEGUINOS Y JOSE CABEZAS' , 'lat': -54.793213 , 'lng': -68.235033 };
paradas['p160'] = { 'id': 160 , 'descripcion': 'PIONEROS FUEGUINOS Y TEODORO MENDOZA' , 'lat': -54.792471 , 'lng': -68.239045 };
paradas['p162'] = { 'id': 162 , 'descripcion': 'HEROES DE MALVINAS Y BAHIA CAMBACERES' , 'lat': -54.790714 , 'lng': -68.243959 };
paradas['p165'] = { 'id': 165 , 'descripcion': 'HEROES DE MALVINAS FRENTE A LAS 60 VIV. MASCIOTRA' , 'lat': -54.788970 , 'lng': -68.254688 };
paradas['p170'] = { 'id': 170 , 'descripcion': 'HEROES DE MALVINAS ENTRADA ANDORRA' , 'lat': -54.789069 , 'lng': -68.269472 };
paradas['p175'] = { 'id': 175 , 'descripcion': 'SOBERANIA NACIONAL Y EVA PERON' , 'lat': -54.791135 , 'lng': -68.271339 };
paradas['p180'] = { 'id': 180 , 'descripcion': 'SOBERANIA NACIONAL Y AYELEN' , 'lat': -54.792249 , 'lng': -68.274450 };
paradas['p185'] = { 'id': 185 , 'descripcion': 'ALAKUSH Y ALBATROS' , 'lat': -54.790665 , 'lng': -68.273699 };
paradas['p190'] = { 'id': 190 , 'descripcion': 'ALAKUSH Y HEROES DE MALVINAS' , 'lat': -54.789675 , 'lng': -68.274472 };
paradas['p195'] = { 'id': 195 , 'descripcion': 'HEROES DE MALVINAS FRENTE AL Bº DOS BANDERAS' , 'lat': -54.791952 , 'lng': -68.282411 };
paradas['p200'] = { 'id': 200 , 'descripcion': 'HEROES DE MALVINAS FRENTE AL Bº KAIKEN' , 'lat': -54.793152 , 'lng': -68.284600 };
paradas['p205'] = { 'id': 205 , 'descripcion': 'HEROES DE MALVINAS Y BAHIA BUEN SUCESO' , 'lat': -54.796516 , 'lng': -68.292260 };
paradas['p210'] = { 'id': 210 , 'descripcion': 'HEROES DE MALVINAS Y ALEM' , 'lat': -54.799213 , 'lng': -68.301723 };
paradas['p215'] = { 'id': 215 , 'descripcion': 'MAGALLANES Y FORTUNATO BEBAN' , 'lat': -54.805001 , 'lng': -68.314812 };
paradas['p220'] = { 'id': 220 , 'descripcion': 'RETAMAR Y ONAS' , 'lat': -54.806040 , 'lng': -68.320262 };
paradas['p225'] = { 'id': 225 , 'descripcion': 'MAGALLANES Y MONETA' , 'lat': -54.805743 , 'lng': -68.323073 };
paradas['p230'] = { 'id': 230 , 'descripcion': 'PAZ Y GUIRALDES' , 'lat': -54.810987 , 'lng': -68.326871 };
paradas['p235'] = { 'id': 235 , 'descripcion': 'KARUKINKA Y STORNI' , 'lat': -54.812384 , 'lng': -68.328266 };
paradas['p240'] = { 'id': 240 , 'descripcion': '12 DE OCTUBRE Y GRANANIELLO' , 'lat': -54.815079 , 'lng': -68.326893 };
paradas['p245'] = { 'id': 245 , 'descripcion': 'KUANIP Y KUPANAKA' , 'lat': -54.816798 , 'lng': -68.327987 };
paradas['p250'] = { 'id': 250 , 'descripcion': 'KUANIP Y PRIMER ARGENTINO' , 'lat': -54.817416 , 'lng': -68.334103 };
paradas['p255'] = { 'id': 255 , 'descripcion': 'KUANIP Y LAPATAIA' , 'lat': -54.818121 , 'lng': -68.338544 };
paradas['p260'] = { 'id': 260 , 'descripcion': 'KUANIP Y PROVINCIA GRANDE' , 'lat': -54.818591 , 'lng': -68.341742 };
paradas['p265'] = { 'id': 265 , 'descripcion': 'ISLA AÑO NUEVO E INDIO YAMANA' , 'lat': -54.819159 , 'lng': -68.346870 };
paradas['p270'] = { 'id': 270 , 'descripcion': '12 DE OCTUBRE E ISLA AÑO NUEVO' , 'lat': -54.817354 , 'lng': -68.349316 };
paradas['p275'] = { 'id': 275 , 'descripcion': 'ALEM Y NEUQUEN' , 'lat': -54.821323 , 'lng': -68.352385 };
paradas['p280'] = { 'id': 280 , 'descripcion': 'ALEM Y BUENOS AIRES' , 'lat': -54.825489 , 'lng': -68.359487 };
paradas['p285'] = { 'id': 285 , 'descripcion': 'IRIGOYEN Y SAN LUIS' , 'lat': -54.827479 , 'lng': -68.353393 };
paradas['p290'] = { 'id': 290 , 'descripcion': 'IRIGOYEN Y FORMOSA' , 'lat': -54.829209 , 'lng': -68.345819 };
paradas['p295'] = { 'id': 295 , 'descripcion': 'PUERTO ARGENTINO E IRIZAR' , 'lat': -54.830606 , 'lng': -68.341742 };
paradas['p300'] = { 'id': 300 , 'descripcion': 'PUERTO ARGENTINO Y BAHIA AGRADABLE' , 'lat': -54.830804 , 'lng': -68.339682 };
paradas['p305'] = { 'id': 305 , 'descripcion': 'HIPÓLITO IRIGOYEN Y MONTE SUSANA' , 'lat': -54.829098 , 'lng': -68.339403 };
paradas['p310'] = { 'id': 310 , 'descripcion': 'INDEPENDENCIA Y CONSTITUCION FUEGUINA' , 'lat': -54.827603 , 'lng': -68.335798 };
paradas['p315'] = { 'id': 315 , 'descripcion': 'CONSTITUCION FUEGUINA CASI CONGRESO NACIONAL' , 'lat': -54.826095 , 'lng': -68.336613 };
paradas['p320'] = { 'id': 320 , 'descripcion': 'CONGRESO NACIONAL Y CONSITUCION FUEGUINA' , 'lat': -54.825810 , 'lng': -68.337471 };
paradas['p325'] = { 'id': 325 , 'descripcion': 'CONSTITUCION FUEGUINA Y MANUEL GAREA' , 'lat': -54.825452 , 'lng': -68.340154 };
paradas['p330'] = { 'id': 330 , 'descripcion': 'CONSTITUCION FUEGUINA Y PADIN OTERO' , 'lat': -54.823696 , 'lng': -68.341935 };
paradas['p335'] = { 'id': 335 , 'descripcion': 'PADIN OTERO Y FRANCISCO TORRES' , 'lat': -54.822658 , 'lng': -68.342965 };
paradas['p340'] = { 'id': 340 , 'descripcion': 'FRANCISCO TORRES E ISLA SAN PEDRO' , 'lat': -54.822102 , 'lng': -68.342021 };
paradas['p345'] = { 'id': 345 , 'descripcion': 'FUEGIA BASQUET E ISLA AÑO NUEVO' , 'lat': -54.821397 , 'lng': -68.341227 };
paradas['p350'] = { 'id': 350 , 'descripcion': 'FUEGIA BASQUET Y PERON' , 'lat': -54.820581 , 'lng': -68.336034 };
paradas['p355'] = { 'id': 355 , 'descripcion': 'MARCOS ZAR Y WALANIKA' , 'lat': -54.818949 , 'lng': -68.329875 };
paradas['p360'] = { 'id': 360 , 'descripcion': '12 DE OCTUBRE Y ARTURO CORONADO' , 'lat': -54.815574 , 'lng': -68.333974 };
paradas['p365'] = { 'id': 365 , 'descripcion': '12 DE OCTUBRE Y DAMIANA FIQUE' , 'lat': -54.815537 , 'lng': -68.329682 };
paradas['p370'] = { 'id': 370 , 'descripcion': 'KARUKINKA Y 12 DE OCTUBRE' , 'lat': -54.816130 , 'lng': -68.325884 };
paradas['p375'] = { 'id': 375 , 'descripcion': 'PAZ Y ANDRADE' , 'lat': -54.811048 , 'lng': -68.326142 };
paradas['p380'] = { 'id': 380 , 'descripcion': 'DARWIN Y TERESA LAVADO' , 'lat': -54.808711 , 'lng': -68.325198 };
paradas['p385'] = { 'id': 385 , 'descripcion': 'DARWIN Y CANGA' , 'lat': -54.807302 , 'lng': -68.325176 };
paradas['p390'] = { 'id': 390 , 'descripcion': 'RETAMAR Y PATAGONIA' , 'lat': -54.806325 , 'lng': -68.320198 };
paradas['p395'] = { 'id': 395 , 'descripcion': 'PREFECTURA NAVAL Y JUANA FADUL' , 'lat': -54.808513 , 'lng': -68.305843 };
paradas['p400'] = { 'id': 400 , 'descripcion': 'PREFECTURA NAVAL Y RIVADAVIA' , 'lat': -54.806621 , 'lng': -68.300693 };
paradas['p405'] = { 'id': 405 , 'descripcion': 'PREFECTURA NAVAL Y PERITO MORENO' , 'lat': -54.805286 , 'lng': -68.295994 };
paradas['p410'] = { 'id': 410 , 'descripcion': 'PERITO MORENO Y CRISTOPHER' , 'lat': -54.800227 , 'lng': -68.282046 };
paradas['p415'] = { 'id': 415 , 'descripcion': 'PERITO MORENO FRENTE A LA ANONIMA' , 'lat': -54.798347 , 'lng': -68.279021 };
paradas['p420'] = { 'id': 420 , 'descripcion': 'PERITO MORENO CON RETORNO' , 'lat': -54.797259 , 'lng': -68.274086 };
paradas['p425'] = { 'id': 425 , 'descripcion': 'PERITO MORENO CON RETORNO' , 'lat': -54.797259 , 'lng': -68.274236 };
paradas['p430'] = { 'id': 430 , 'descripcion': 'FACUNDO QUIROGA Y MURIEL' , 'lat': -54.796949 , 'lng': -68.284299 };
paradas['p435'] = { 'id': 435 , 'descripcion': 'FACUNDO QUIROGA Y GUANACO' , 'lat': -54.795836 , 'lng': -68.281553 };
paradas['p440'] = { 'id': 440 , 'descripcion': 'FACUNDO QUIROGA Y ABUTARDA' , 'lat': -54.794574 , 'lng': -68.278248 };
paradas['p445'] = { 'id': 445 , 'descripcion': 'FACUNDO QUIROGA Y EVA PERON' , 'lat': -54.792904 , 'lng': -68.271446 };
paradas['p450'] = { 'id': 450 , 'descripcion': 'FACUNDO QUIROGA Y 17 DE OCTUBRE' , 'lat': -54.792063 , 'lng': -68.267326 };
paradas['p455'] = { 'id': 455 , 'descripcion': 'FACUNDO QUIROGA Y CIPRIANO REYES' , 'lat': -54.791927 , 'lng': -68.265953 };
paradas['p458'] = { 'id': 458 , 'descripcion': 'PERITO MORENO FRENTE NEW SAN' , 'lat': -54.796244 , 'lng': -68.241813 };
paradas['p460'] = { 'id': 460 , 'descripcion': 'HEROES DE MALVINAS Y CABO NICOLAS FLORES' , 'lat': -54.791073 , 'lng': -68.238294 };
paradas['p465'] = { 'id': 465 , 'descripcion': 'FELIPE ROMERO EN Bº 640 VIVIENDAS' , 'lat': -54.794574 , 'lng': -68.232629 };
paradas['p470'] = { 'id': 470 , 'descripcion': 'FELIPE ROMERO Y PERITO MORENO' , 'lat': -54.796504 , 'lng': -68.235075 };
paradas['p475'] = { 'id': 475 , 'descripcion': 'PERITO MORENO FRENTE NEW SAN' , 'lat': -54.795984 , 'lng': -68.241556 };
paradas['p480'] = { 'id': 480 , 'descripcion': 'PERITO MORENO CASI COMISARIO CELESTINO DALMASO' , 'lat': -54.793213 , 'lng': -68.251812 };
paradas['p485'] = { 'id': 485 , 'descripcion': 'EVA PERON CASI MARTIN FIERRO' , 'lat': -54.792694 , 'lng': -68.262370 };
paradas['p490'] = { 'id': 490 , 'descripcion': 'EVA PERON Y CIPRIANO REYES' , 'lat': -54.791531 , 'lng': -68.265288 };
paradas['p495'] = { 'id': 495 , 'descripcion': 'FACUNDO QUIROGA Y GUANACO I' , 'lat': -54.795626 , 'lng': -68.281810 };
paradas['p500'] = { 'id': 500 , 'descripcion': 'FACUNDO QUIROGA EN Bº LA OCA' , 'lat': -54.796578 , 'lng': -68.284385 };
paradas['p505'] = { 'id': 505 , 'descripcion': 'PERITO MORENO Y GENDARME ARGETINO' , 'lat': -54.800413 , 'lng': -68.283226 };
paradas['p510'] = { 'id': 510 , 'descripcion': 'MAIPU Y ANTARTIDA ARGENTINA' , 'lat': -54.806003 , 'lng': -68.300071 };
paradas['p515'] = { 'id': 515 , 'descripcion': 'MAIPU Y ROCA' , 'lat': -54.806943 , 'lng': -68.303804 };
paradas['p520'] = { 'id': 520 , 'descripcion': 'MAIPU Y JUANA FADUL' , 'lat': -54.807660 , 'lng': -68.306551 };
paradas['p525'] = { 'id': 525 , 'descripcion': 'MAIPU Y DON BOSCO' , 'lat': -54.808761 , 'lng': -68.311014 };
paradas['p530'] = { 'id': 530 , 'descripcion': 'MAIPU Y ONAS' , 'lat': -54.810467 , 'lng': -68.318782 };
paradas['p535'] = { 'id': 535 , 'descripcion': 'MAIPU Y ALFERES SOBRAL' , 'lat': -54.812285 , 'lng': -68.321722 };
//paradas['p540'] = { 'id': 540 , 'descripcion': 'PERON Y RIO GALLEGOS' , 'lat': -54.822633 , 'lng': 0 };
paradas['p545'] = { 'id': 545 , 'descripcion': 'CONSTITUCION FUEGUINA E INDEPENDENCIA' , 'lat': -54.827504 , 'lng': -68.335283 };
paradas['p550'] = { 'id': 550 , 'descripcion': 'INDEPENDENCIA Y MONTE SUSANA' , 'lat': -54.828048 , 'lng': -68.338201 };
paradas['p555'] = { 'id': 555 , 'descripcion': 'HIPÓLITO IRIGOYEN Y MONTE SUSANA' , 'lat': -54.829024 , 'lng': -68.339767 };
paradas['p560'] = { 'id': 560 , 'descripcion': 'HIPÓLITO IRIGOYEN FRENTE AL Bº MIRADOR DEL PIPO' , 'lat': -54.827986 , 'lng': -68.347900 };
paradas['p565'] = { 'id': 565 , 'descripcion': 'HIPOLITO IRIGOYEN Y SANTA FE' , 'lat': -54.826577 , 'lng': -68.355217 };
paradas['p570'] = { 'id': 570 , 'descripcion': 'HIPOLITO IRIGOYEN Y ALEM' , 'lat': -54.826774 , 'lng': -68.362663 };
paradas['p575'] = { 'id': 575 , 'descripcion': 'ALEM Y BUENOS AIRES' , 'lat': -54.825093 , 'lng': -68.357556 };
paradas['p580'] = { 'id': 580 , 'descripcion': 'ALEM Y ENTRE RIOS' , 'lat': -54.824426 , 'lng': -68.355646 };
paradas['p585'] = { 'id': 585 , 'descripcion': 'ALEM Y NEUQUEN' , 'lat': -54.821508 , 'lng': -68.352041 };
paradas['p590'] = { 'id': 590 , 'descripcion': 'ALEM Y RIO NEGRO' , 'lat': -54.819914 , 'lng': -68.350046 };
paradas['p595'] = { 'id': 595 , 'descripcion': '12 DE OCTUBRE Y ALEM' , 'lat': -54.817478 , 'lng': -68.348823 };
paradas['p600'] = { 'id': 600 , 'descripcion': 'ISLA AÑO NUEVO Y TEHUELCHE' , 'lat': -54.818937 , 'lng': -68.347514 };
paradas['p605'] = { 'id': 605 , 'descripcion': 'ISLA AÑO NUEVO Y KUANIP' , 'lat': -54.820420 , 'lng': -68.344703 };
paradas['p610'] = { 'id': 610 , 'descripcion': '12 DE OCTUBRE Y FITZ ROY' , 'lat': -54.814597 , 'lng': -68.323674 };
paradas['p615'] = { 'id': 615 , 'descripcion': '12 DE OCTUBRE Y PREFECTURA NAVAL' , 'lat': -54.814028 , 'lng': -68.321979 };
paradas['p620'] = { 'id': 620 , 'descripcion': 'PREFECTURA NAVAL Y ONAS' , 'lat': -54.810727 , 'lng': -68.318760 };


// Pisamos los titulos de paradas para hacerlos más lindos

var skipProperCase = new Array("y","en","de","al","casi","e","frente","a","las","entrada","con","del");

for(pid in paradas) {
	parada = paradas[pid];
	parada.descripcion = parada.descripcion.toProperCase();
}



// ----------------------------

var map;
var ushuaia = new google.maps.LatLng(-54.8038, -68.3037);
var initialLocation = null;
var initialZoom = null;
var browserSupportFlag =  new Boolean();
var recorridoLineasKml = "https://maps.google.com/maps/ms?authuser=0&vps=2&ie=UTF8&msa=0&output=kml&msid=213226060073051276714.0004dc9c0cf2de51141ef";

/*
window.onresize = function(event) {
	google.maps.event.trigger(map, 'resize');
	if (initialLocation) map.setCenter(initialLocation);
	initialLocation = null;
}
*/

function setCenter() {

	// No está definida la localización, trataremos de obtenerla 
	// con geolocation y sino ubicaremos en el centro de Ushuaia
	if (initialLocation === null) {
		// Try W3C Geolocation (Preferred)
		if(navigator.geolocation) {
			browserSupportFlag = true;
			navigator.geolocation.getCurrentPosition(
				function(position) {
					initialLocation = new google.maps.LatLng(position.coords.latitude,position.coords.longitude);
					map.setCenter(initialLocation);
				}, 
				function() {
					handleNoGeolocation(browserSupportFlag);
				}
			);
		}
		// Browser doesn't support Geolocation
		else {
			browserSupportFlag = false;
			handleNoGeolocation(browserSupportFlag);
		}

		function handleNoGeolocation(errorFlag) {
			initialLocation = ushuaia;
			map.setCenter(initialLocation);
		}
	}

	// Ya estaba definida la localización y preferimos no tocarla
	else {
		map.setCenter(initialLocation);
	}

} // setCenter()


function initialize() {
	var mapOptions = {
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	map = new google.maps.Map(document.getElementById("mapa_paradas"), mapOptions);


    map.layers = new Object();
    map.layers.lineas = new google.maps.KmlLayer({
    	url : recorridoLineasKml, 
    	preserveViewport : true
    });
    map.layers.lineas.setMap(map);


    if (initialZoom === null) {
    	initialZoom = 17;
    }
	map.setZoom(initialZoom);
	setCenter();


	for(var pid in paradas) {
		paradas[pid].marker = new google.maps.Marker({
		    position: new google.maps.LatLng(paradas[pid].lat, paradas[pid].lng),
		    map: map
		});
		paradas[pid].marker.id = paradas[pid].id;
		paradas[pid].marker.setTitle("Parada " + paradas[pid].id + " - " + paradas[pid].descripcion);

		google.maps.event.addListener(paradas[pid].marker, 'click', function(event) {
		    $("#container .modal .modal-header h3").html(this.getTitle());
		    $("#container .modal .modal-body").html("<p>Consultando servidor...</p>");
		    cuantoFalta(this.id);

		    $("#container .modal").show();
		    $("#container .modal-backdrop").show();
		});

	}


	google.maps.event.addListener(map, 'center_changed', function() {
		initialLocation = map.getCenter();
	});


} // initialize
