    
    // Affchage du spin ("loading")
    var spin_options = {
        lines: 13, // The number of lines to draw
        length: 20, // The length of each line
        width: 10, // The line thickness
        radius: 30, // The radius of the inner circle
        corners: 1, // Corner roundness (0..1)
        rotate: 0, // The rotation offset
        direction: 1, // 1: clockwise, -1: counterclockwise
        color: '#000', // #rgb or #rrggbb or array of colors
        speed: 1, // Rounds per second
        trail: 60, // Afterglow percentage
        shadow: false, // Whether to render a shadow
        hwaccel: false, // Whether to use hardware acceleration
        className: 'spinner', // The CSS class to assign to the spinner
        zIndex: 2e9,          // The z-index (defaults to 2000000000)
        top: '50%',           // Top position relative to parent
        left: '50%'           // Left position relative to parent
    };
    var target  = document.getElementById('spin');
    var spinner = new Spinner(spin_options).spin(target);
    
    var equipements = this;
    equipements.liste = [];

    var req = new XMLHttpRequest();
    req.open('GET', 'data/liste_des_musees_franciliens.json', true);
    req.onreadystatechange = function () {
        if (req.readyState == 4) {
            equipements.liste = req.responseText;
            displayMap();
        }
    };
    req.send(null);

    /* Affichage de la carte */
    function displayMap()
    {
        spinner.stop(); 
        var tiles = L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {
            maxZoom: 18,
            attribution: 'Map data &copy; <a href="http://osm.org/copyright">OpenStreetMap</a> contributors, Points &copy 2012 LINZ' + 
                '<a href="http://creativecommons.org/licenses/by-sa/2.0/">CC-BY-SA</a>, ' +
                'Imagery © <a href="http://mapbox.com">Mapbox</a>' + 
                ' - <a href="infos.htm">Informations</a>'
        });
        var latlng = L.latLng(48.8571, 2.3409);
        var map = L.map('map', { center: latlng, zoom: 13, layers: [tiles] });
        
        // Markers et données
        var markers = L.markerClusterGroup({ chunkedLoading: true, chunkProgress: updateProgressBar });
        var markerList = [];
        points = JSON.parse(equipements.liste); //console.log(points); return;
        points_nb = points.length;
        if ( points_nb > 0 ) {
            for (var i = 0; i < points_nb; i++) {
                var p = points[i], html;
                if ( p.fields.hasOwnProperty('wgs84') && !isNaN(p.fields.wgs84[0]) && !isNaN(p.fields.wgs84[1]) ) {
                    html =  '<div class="lcol">Nom</div>' +
                            '<div class="rcol">'+p.fields.nom_du_musee+' (<a target="_blank" href="http://'+p.fields.sitweb+'">lien</a>)</div>' +
                            '<div class="lcol">Adresse</div>' +
                            '<div class="rcol">'+p.fields.adresse+' ('+p.fields.cp+' '+p.fields.ville+')</div>' +
                            '<div class="lcol">Ouverture</div>' +
                            '<div class="rcol">'+p.fields.periode_ouverture+'</div>' +
                            '<div class="lcol">Coordonnées</div>' +
                            '<div class="rcol">'+p.fields.wgs84[0]+', '+p.fields.wgs84[1]+'</div>'
                    ;
                    var marker = L.marker(new L.LatLng(p.fields.wgs84[0], p.fields.wgs84[1])).bindPopup(html);
                    markerList.push(marker);
                }
                else {
                    console.log(p.fields.nom_du_musee);
                }
            }
        }
        
        markers.addLayers(markerList);
        map.addLayer(markers);
        
    } // end displayMap()

    function updateProgressBar(processed, total, elapsed, layersArray)
    {
        var progress = document.getElementById('progress');
        var progressBar = document.getElementById('progress-bar');

        if (elapsed > 1000) {
            // if it takes more than a second to load, display the progress bar:
            progress.style.display = 'block';
            progressBar.style.width = Math.round(processed/total*100) + '%';
        }
        
        if (processed === total) {
            // all markers processed - hide the progress bar:
            progress.style.display = 'none';
        }
    } // end updateProgressBar()
